/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.unittest.resultview.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.web.unittest.resultview.style.LinkInfo;
import org.tizen.web.unittest.resultview.style.StyledString;
import org.tizen.web.unittest.resultview.ui.EditorUtil;

public class WUTDetailInfoViewer
extends StyledText {
    private static final Logger logger = LoggerFactory.getLogger(WUTDetailInfoViewer.class);
    private List<LinkInfo> linkInfoList = new ArrayList<LinkInfo>();

    public WUTDetailInfoViewer(Composite parent) {
        super(parent, 8);
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                try {
                    LinkInfo linkInfo;
                    int offset = WUTDetailInfoViewer.this.getOffsetAtLocation(new Point(e.x, e.y));
                    StyleRange style = WUTDetailInfoViewer.this.getStyleRangeAtOffset(offset);
                    if (style != null && style.underline && (linkInfo = WUTDetailInfoViewer.this.getLinkInfoAtOffset(offset)) != null) {
                        EditorUtil.openEditor(linkInfo.getFile(), linkInfo.getLineNumber());
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    logger.info("Out of location.");
                }
            }
        });
    }

    public void setStyledString(StyledString styledString) {
        this.setText(styledString.getString());
        this.setStyleRanges(styledString.getStyleRangeList().toArray(new StyleRange[0]));
    }

    public void clearLinkInfoList() {
        this.linkInfoList.clear();
    }

    public void addLinkInfo(LinkInfo linkInfo) {
        this.linkInfoList.add(linkInfo);
    }

    private LinkInfo getLinkInfoAtOffset(int offset) {
        for (LinkInfo linkInfo : this.linkInfoList) {
            if (!linkInfo.withinRange(offset)) continue;
            return linkInfo;
        }
        return null;
    }
}

