/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.unittest.resultview.ui;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.ImageUtil;
import org.tizen.web.unittest.WebUnitTestPlugin;
import org.tizen.web.unittest.resultview.action.CheckFailedAction;
import org.tizen.web.unittest.resultview.action.CollapseAllAction;
import org.tizen.web.unittest.resultview.action.RunCheckedAction;
import org.tizen.web.unittest.resultview.action.ShowFailedOnlyAction;
import org.tizen.web.unittest.resultview.model.IWUTResultTreeElement;
import org.tizen.web.unittest.resultview.model.WUTGlobalFailure;
import org.tizen.web.unittest.resultview.model.WUTResult;
import org.tizen.web.unittest.resultview.model.WUTResultFailure;
import org.tizen.web.unittest.resultview.model.WUTResultParent;
import org.tizen.web.unittest.resultview.model.WUTResultTestCase;
import org.tizen.web.unittest.resultview.model.WUTResultTestSuite;
import org.tizen.web.unittest.resultview.parser.WUTXmlParser;
import org.tizen.web.unittest.resultview.style.LinkInfo;
import org.tizen.web.unittest.resultview.style.StyledString;
import org.tizen.web.unittest.resultview.ui.EditorUtil;
import org.tizen.web.unittest.resultview.ui.WUTDetailInfoViewer;
import org.tizen.web.unittest.resultview.ui.WUTResultProgressBar;
import org.tizen.web.unittest.resultview.ui.WUTResultTreeViewer;

public class WUTResultView
extends ViewPart {
    public static final String ID = "org.tizen.web.unittest.views.resultView";
    private static final String EMPTY = "";
    private static final Logger logger = LoggerFactory.getLogger(WUTResultView.class);
    private static WUTResultView wutResultView;
    private static final Color ERR_COLOR;
    private static final Color OK_COLOR;
    private Composite topComposite;
    private Composite counterComposite;
    private Label runCountLabel;
    private Link errorCountLink;
    private Label failureCountLabel;
    private WUTResultProgressBar progressBar;
    private WUTResultTreeViewer testResultTreeViewer;
    private WUTDetailInfoViewer testDetailInfoViewer;
    private SashForm sashForm;
    private RunCheckedAction runCheckedAction;

    static {
        ERR_COLOR = new Color((Device)Display.getDefault(), 159, 63, 63);
        OK_COLOR = new Color((Device)Display.getDefault(), 95, 191, 95);
    }

    public WUTResultView() {
        wutResultView = this;
    }

    public boolean isCreated() {
        return this.counterComposite != null;
    }

    public static WUTResultView getWUTResultView() {
        return wutResultView;
    }

    public void displayResult(String xml, IProject project, ILaunchConfiguration config, String mode) {
        this.runCheckedAction.setLaunchInfo(config, mode);
        this.runCheckedAction.setEnabled(false);
        this.testDetailInfoViewer.clearLinkInfoList();
        final WUTResult testResult = WUTXmlParser.parseResult(project, xml);
        if (testResult == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (WUTResultView.this.testDetailInfoViewer.isDisposed()) {
                    return;
                }
                WUTResultView.this.testDetailInfoViewer.setText(WUTResultView.EMPTY);
                WUTResultView.this.runCountLabel.setText(Integer.toString(testResult.getTotalAssertionCount()));
                WUTResultView.this.errorCountLink.setText("<a>" + Integer.toString(testResult.getErrorCount()) + "</a>");
                StyledString styledString = new StyledString();
                List<WUTGlobalFailure> globalFailureList = testResult.getGlobalFailureList();
                for (WUTGlobalFailure gFailure : globalFailureList) {
                    String filePath = gFailure.getFile().getProjectRelativePath().toOSString();
                    WUTResultView.this.testDetailInfoViewer.addLinkInfo(new LinkInfo(gFailure.getFile(), gFailure.getLineNumber(), styledString.getString().length(), styledString.getString().length() + filePath.length()));
                    styledString.appendLinkString(filePath);
                    styledString.appendString(" :" + gFailure.getMessage() + "\n");
                }
                WUTResultView.this.errorCountLink.setData((Object)styledString);
                WUTResultView.this.failureCountLabel.setText(Integer.toString(testResult.getFailedAssertionCount()));
                WUTResultView.this.counterComposite.layout();
                WUTResultView.this.testResultTreeViewer.setInput(testResult);
                if (testResult.getFailedAssertionCount() > 0 || testResult.getErrorCount() > 0) {
                    WUTResultView.this.progressBar.setBackground(ERR_COLOR);
                } else {
                    WUTResultView.this.progressBar.setBackground(OK_COLOR);
                }
            }
        });
    }

    public void createPartControl(Composite parent) {
        GridLayout gridLayout = this.newGridLayout(1);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        parent.setLayout((Layout)gridLayout);
        this.createTopPart(parent);
        this.createBottomPart(parent);
    }

    private void createTopPart(Composite parent) {
        this.topComposite = new Composite(parent, 0);
        GridLayout gridLayout = this.newGridLayout(2);
        this.topComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.topComposite.setLayoutData((Object)gridData);
        this.counterComposite = new Composite(this.topComposite, 0);
        gridLayout = this.newGridLayout(8);
        this.counterComposite.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.counterComposite.setLayoutData((Object)gridData);
        Label runLabel = new Label(this.counterComposite, 0);
        runLabel.setText("Runs: ");
        this.runCountLabel = new Label(this.counterComposite, 0);
        this.runCountLabel.setText("0");
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        this.runCountLabel.setLayoutData((Object)gridData);
        Label errorImageLabel = new Label(this.counterComposite, 0);
        errorImageLabel.setImage(ImageUtil.getImage((Plugin)WebUnitTestPlugin.getDefault(), (String)"icons/obj16/abnormal.png"));
        Label errorLabel = new Label(this.counterComposite, 0);
        errorLabel.setText("Errors: ");
        this.errorCountLink = new Link(this.counterComposite, 0);
        this.errorCountLink.setText("0");
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        this.errorCountLink.setLayoutData((Object)gridData);
        this.errorCountLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StyledString styledString = (StyledString)WUTResultView.this.errorCountLink.getData();
                WUTResultView.this.testDetailInfoViewer.setStyledString(styledString);
            }
        });
        Label failureImageLabel = new Label(this.counterComposite, 0);
        failureImageLabel.setImage(ImageUtil.getImage((Plugin)WebUnitTestPlugin.getDefault(), (String)"icons/obj16/failed.png"));
        Label failureLabel = new Label(this.counterComposite, 0);
        failureLabel.setText("Failures: ");
        this.failureCountLabel = new Label(this.counterComposite, 0);
        this.failureCountLabel.setText("0");
        this.progressBar = new WUTResultProgressBar(this.topComposite);
    }

    private void createBottomPart(final Composite parent) {
        Composite bottomComposite = new Composite(parent, 0);
        GridLayout gridLayout = this.newGridLayout(1);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        bottomComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        bottomComposite.setLayoutData((Object)gridData);
        this.sashForm = new SashForm(bottomComposite, 256);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.sashForm.setLayoutData((Object)gridData);
        this.testResultTreeViewer = new WUTResultTreeViewer((Composite)this.sashForm, 0);
        this.testResultTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeSelection selection;
                Object element;
                if (event.getSelection() instanceof TreeSelection && (element = (selection = (TreeSelection)event.getSelection()).getFirstElement()) instanceof IWUTResultTreeElement) {
                    StyledString detail = ((IWUTResultTreeElement)element).getDetail();
                    WUTResultView.this.testDetailInfoViewer.setStyledString(detail);
                }
            }
        });
        this.testResultTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection selection;
                if (event.getSelection() instanceof TreeSelection && (selection = (TreeSelection)event.getSelection()).getFirstElement() instanceof WUTResultFailure) {
                    WUTResultFailure failureInfo = (WUTResultFailure)selection.getFirstElement();
                    IFile file = failureInfo.getFile();
                    if (!file.exists()) {
                        logger.error("Cannot find source file");
                        return;
                    }
                    EditorUtil.openEditor(file, failureInfo.getLineNumber());
                }
            }
        });
        this.testResultTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof WUTResultParent) {
                    boolean isCheckEvent = event.getChecked();
                    WUTResultView.this.testResultTreeViewer.setSubtreeChecked(element, isCheckEvent);
                    if (element instanceof WUTResultTestCase) {
                        WUTResultTestCase testCase = (WUTResultTestCase)element;
                        WUTResultTestSuite testSuite = testCase.getParent();
                        if (isCheckEvent) {
                            for (WUTResultTestCase tc : testSuite.getTestCaseList()) {
                                if (!WUTResultView.this.testResultTreeViewer.isFilteredElement(testSuite, tc) || WUTResultView.this.testResultTreeViewer.getChecked(tc)) continue;
                                isCheckEvent = false;
                                break;
                            }
                            WUTResultView.this.testResultTreeViewer.setChecked(testSuite, isCheckEvent);
                        } else {
                            WUTResultView.this.testResultTreeViewer.setChecked(testSuite, false);
                        }
                    }
                } else if (element instanceof WUTResultFailure) {
                    WUTResultView.this.testResultTreeViewer.setChecked(element, !event.getChecked());
                }
                if (WUTResultView.this.testResultTreeViewer.getCheckedElements().length == 0) {
                    WUTResultView.this.runCheckedAction.setEnabled(false);
                } else {
                    WUTResultView.this.runCheckedAction.setEnabled(true);
                }
            }
        });
        this.testDetailInfoViewer = new WUTDetailInfoViewer((Composite)this.sashForm);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        this.testDetailInfoViewer.setLayoutData(gridData);
        this.testDetailInfoViewer.setWordWrap(true);
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)new CollapseAllAction((TreeViewer)this.testResultTreeViewer));
        ShowFailedOnlyAction showFailedOnlyAction = new ShowFailedOnlyAction(this.testResultTreeViewer);
        toolBarManager.add((IAction)showFailedOnlyAction);
        CheckFailedAction checkFailedAction = new CheckFailedAction(this.testResultTreeViewer);
        toolBarManager.add((IAction)checkFailedAction);
        this.runCheckedAction = new RunCheckedAction(this.testResultTreeViewer);
        toolBarManager.add((IAction)this.runCheckedAction);
        showFailedOnlyAction.addActionRunNotifyRequester(this.runCheckedAction);
        checkFailedAction.addActionRunNotifyRequester(this.runCheckedAction);
        this.runCheckedAction.setEnabled(false);
        parent.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                Point size = parent.getSize();
                if (size.x != 0 && size.y != 0) {
                    if (size.x > size.y) {
                        WUTResultView.this.setOrientation(256);
                    } else {
                        WUTResultView.this.setOrientation(512);
                    }
                    parent.layout();
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    private void setOrientation(int orientation) {
        int horizontalIndent;
        int numColumns;
        if (this.sashForm != null && !this.sashForm.isDisposed()) {
            this.sashForm.setOrientation(orientation);
        }
        GridLayout gridLayout = (GridLayout)this.topComposite.getLayout();
        if (orientation == 256) {
            numColumns = 2;
            horizontalIndent = 30;
        } else {
            numColumns = 1;
            horizontalIndent = 0;
        }
        if (gridLayout.numColumns != numColumns) {
            gridLayout.numColumns = numColumns;
            ((GridData)this.progressBar.getLayoutData()).horizontalIndent = horizontalIndent;
        }
    }

    public void setFocus() {
    }

    private GridLayout newGridLayout(int numColumns) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = numColumns;
        return gridLayout;
    }
}

