/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.contentassist;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ITizenProject;
import org.tizen.common.TizenProjectType;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.ProjectUtil;
import org.tizen.web.editor.Activator;

public class WebResourceManager {
    private final Logger logger = LoggerFactory.getLogger(WebResourceManager.class);
    public static final String EMPTY_STRING = "";
    public static final String CURRENT_FOLDER = "./";
    public static final String FOLDER_PARENT = "../";
    public static final String FOLDER_LOCALES = "locales/";
    private WebResourceVisitor visitor = null;
    private IProject project = null;
    private IFile currentSourceFile = null;
    private Map<String, IResource> jsFiles = null;
    private Map<String, IResource> htmlFiles = null;
    private Map<String, IResource> cssFiles = null;
    private Map<String, IResource> imageFiles = null;

    public WebResourceManager(IProject project) {
        this(project, null);
    }

    public WebResourceManager(IProject project, IFile file) {
        this.initialize();
        this.getDefaultExcludedFolders();
        this.visitor = new WebResourceVisitor();
        this.project = project;
        this.currentSourceFile = file;
    }

    public void initialize() {
        this.visitor = null;
        this.project = null;
        this.currentSourceFile = null;
        this.jsFiles = null;
        this.htmlFiles = null;
        this.cssFiles = null;
        this.imageFiles = null;
    }

    public void makeProjectManagedResourceMap() {
        try {
            this.project.accept((IResourceVisitor)this.visitor);
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public IFile getFile(String fileFullPath, ResourceType resourceType) {
        IFile file = null;
        switch (resourceType) {
            case HTML: {
                file = (IFile)this.htmlFiles.get(fileFullPath);
                break;
            }
            case JS: {
                file = (IFile)this.jsFiles.get(fileFullPath);
                break;
            }
            case CSS: {
                file = (IFile)this.cssFiles.get(fileFullPath);
                break;
            }
            case IMAGE: {
                file = (IFile)this.imageFiles.get(fileFullPath);
                break;
            }
        }
        return file;
    }

    public IFile getFile(String fileFullPath, String fileExtension) {
        IFile file = null;
        if (fileExtension == null || fileFullPath == null || fileFullPath.equals(EMPTY_STRING)) {
            return file;
        }
        fileExtension = fileExtension.toLowerCase();
        if (ResourceType.HTML.getName().contains(fileExtension) && this.htmlFiles != null) {
            file = (IFile)this.htmlFiles.get(fileFullPath);
        } else if (ResourceType.JS.getName().contains(fileExtension) && this.jsFiles != null) {
            file = (IFile)this.jsFiles.get(fileFullPath);
        } else if (ResourceType.CSS.getName().contains(fileExtension) && this.cssFiles != null) {
            file = (IFile)this.cssFiles.get(fileFullPath);
        } else if (this.imageFiles != null) {
            file = (IFile)this.imageFiles.get(fileFullPath);
        }
        return file;
    }

    protected boolean isTizenWebProjects(IProject project) {
        ITizenProject tizenProject = ProjectUtil.getTizenProject((IProject)project);
        return tizenProject != null && (tizenProject.getTizenProjectType() == TizenProjectType.TIZEN_WEB_APPLICATION || tizenProject.getTizenProjectType() == TizenProjectType.TIZEN_WEB_UIBUILDER_APPLICATION || tizenProject.getTizenProjectType() == TizenProjectType.TIZEN_WEB_UIFW_APPLICATION);
    }

    private boolean isContainedExcludedFolders(IResource resource) {
        boolean isContained = false;
        String resourceFullPath = resource.getFullPath().toString();
        String lastSegment = resource.getFullPath().lastSegment();
        String[] defaultExcludedFolders = this.getDefaultExcludedFolders();
        if (defaultExcludedFolders != null) {
            String[] stringArray = defaultExcludedFolders;
            int n = defaultExcludedFolders.length;
            int n2 = 0;
            while (n2 < n) {
                String folder = stringArray[n2];
                if (folder.contains(lastSegment) && resourceFullPath.contains(folder)) {
                    isContained = true;
                    break;
                }
                ++n2;
            }
        }
        return isContained;
    }

    public IFile getCurrentSourceFile() {
        return this.currentSourceFile;
    }

    public void setCurrentSourceFile(IFile currentSourceFile) {
        this.currentSourceFile = currentSourceFile;
    }

    public Map<String, IResource> getJsFiles() {
        return this.jsFiles;
    }

    public void setJsFiles(Map<String, IResource> jsFiles) {
        this.jsFiles = jsFiles;
    }

    public Map<String, IResource> getHtmlFiles() {
        return this.htmlFiles;
    }

    public void setHtmlFiles(Map<String, IResource> htmlFiles) {
        this.htmlFiles = htmlFiles;
    }

    public Map<String, IResource> getCssFiles() {
        return this.cssFiles;
    }

    public void setCssFiles(Map<String, IResource> cssFiles) {
        this.cssFiles = cssFiles;
    }

    public Map<String, IResource> getImageFiles() {
        return this.imageFiles;
    }

    public void setImageFiles(Map<String, IResource> imageFiles) {
        this.imageFiles = imageFiles;
    }

    public String[] getDefaultExcludedFolders() {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        String excludedFolderList = prefs.getString("org.tizen.web.editor.EDITOR_ADVANCED_FEATURE_EXCLUDED_FOLDER_STORE_KEY");
        if (excludedFolderList != null) {
            return excludedFolderList.split(",");
        }
        return null;
    }

    public static void checkLocaleResources(IResource res, Iterator<Map.Entry<String, IResource>> iterator) {
        while (iterator.hasNext()) {
            Map.Entry<String, IResource> fileEntry = iterator.next();
            String key = fileEntry.getKey();
            if (res.getProjectRelativePath().toString().contains(FOLDER_LOCALES)) {
                if (key.contains(FOLDER_LOCALES)) continue;
                iterator.remove();
                continue;
            }
            if (!key.contains(FOLDER_LOCALES)) continue;
            iterator.remove();
        }
    }

    public static enum ResourceType {
        HTML("html", 0),
        JS("js", 1),
        CSS("css", 2),
        IMAGE("img", 3),
        HTM("htm", 4);

        private String name = null;
        private int code = 0;

        private ResourceType(String name, int code) {
            this.name = name;
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public static boolean isTizenSupportedImage(String extension) {
            return extension.equals("png") || extension.equals("jpg") || extension.equals("jpeg") || extension.equals("gif") || extension.equals("ico");
        }
    }

    private class WebResourceVisitor
    implements IResourceVisitor {
        private WebResourceVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFolder) {
                if (WebResourceManager.this.isContainedExcludedFolders(resource)) {
                    return false;
                }
            } else if (resource instanceof IFile) {
                String extension;
                String projectName = WebResourceManager.this.project.getName();
                String targetFilePath = resource.getFullPath().toString();
                targetFilePath = targetFilePath.substring(projectName.length() + 2);
                IFile soureFile = WebResourceManager.this.getCurrentSourceFile();
                if (soureFile != null) {
                    String sourceFilePath = soureFile.getFullPath().toString();
                    targetFilePath = FilenameUtil.getRelativePath((String)(sourceFilePath = sourceFilePath.substring(projectName.length() + 2)), (String)targetFilePath);
                    if (targetFilePath.startsWith(WebResourceManager.FOLDER_PARENT)) {
                        targetFilePath = targetFilePath.substring(3);
                    }
                }
                if ((extension = resource.getFileExtension()) != null) {
                    if ((extension = extension.toLowerCase()).equals(ResourceType.JS.getName())) {
                        if (WebResourceManager.this.jsFiles == null) {
                            WebResourceManager.this.jsFiles = new HashMap();
                        }
                        WebResourceManager.this.jsFiles.put(targetFilePath, resource);
                    } else if (extension.equals(ResourceType.CSS.getName())) {
                        if (WebResourceManager.this.cssFiles == null) {
                            WebResourceManager.this.cssFiles = new HashMap();
                        }
                        WebResourceManager.this.cssFiles.put(targetFilePath, resource);
                    } else if (extension.equals(ResourceType.HTML.getName()) || extension.equals(ResourceType.HTM.getName())) {
                        if (WebResourceManager.this.htmlFiles == null) {
                            WebResourceManager.this.htmlFiles = new HashMap();
                        }
                        WebResourceManager.this.htmlFiles.put(targetFilePath, resource);
                    } else if (ResourceType.isTizenSupportedImage(extension)) {
                        if (WebResourceManager.this.imageFiles == null) {
                            WebResourceManager.this.imageFiles = new HashMap();
                        }
                        WebResourceManager.this.imageFiles.put(targetFilePath, resource);
                    }
                }
            }
            return true;
        }
    }
}

