/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.unittest.step;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.Resource;
import org.tizen.common.file.StandardFileHandler;
import org.tizen.common.file.VirtualFileHandler;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.util.Assert;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.web.common.util.PackageUtil;
import org.tizen.web.packager.ui.WebPackager;
import org.tizen.web.unittest.util.WUTUtil;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.step.PackageStep;
import org.tizen.web.zimlaunch.util.LaunchUtil;

public class WUTPackageStep
extends PackageStep {
    public void executeStep(ILaunchContext ctx) throws Exception {
        UserLogger.start((String)"web.launch", (String)".packaging");
        IProject project = this.getProject(ctx);
        Assert.notNull((Object)project);
        WebPackager packMan = new WebPackager();
        ZimLaunchResource launchResource = (ZimLaunchResource)ctx.getValue((Object)"resource");
        packMan.setDevice(launchResource.getDeviceinfo().getDevice());
        ByteArrayOutputStream os = null;
        boolean isSuccess = false;
        ILaunchConfiguration launchConfig = (ILaunchConfiguration)ctx.getValue((Object)"config");
        try {
            Resource resource = null;
            String mode = (String)ctx.getValue((Object)"mode");
            String packPath = PackageUtil.getPackagePath((IProject)project);
            if (LaunchUtil.isLiveEditingMode((ILaunchConfiguration)launchConfig) && !"debug".equals(mode)) {
                os = new ByteArrayOutputStream();
                packMan.removePackage(project);
                isSuccess = packMan.createLiveEditingPackage(project, (OutputStream)os);
                if (isSuccess) {
                    resource = new Resource((FileHandler)new VirtualFileHandler(), packPath);
                    resource.setContents(os.toByteArray());
                }
            } else {
                packMan.removePackage(project);
                String testFilter = launchConfig.getAttribute("attribute_wut_query", "");
                isSuccess = packMan.createUnitTestPackage(project, "webUnitTest/test.html", WUTUtil.createTestHtmlByteArray(project, testFilter));
                if (isSuccess) {
                    project.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    resource = new Resource((FileHandler)new StandardFileHandler(), packPath);
                }
            }
            if (isSuccess) {
                ctx.setValue((Object)"package", resource);
            }
        }
        catch (Throwable throwable) {
            ILaunchConfigurationWorkingCopy wc = launchConfig.getWorkingCopy();
            wc.setAttribute("attribute_wut_query", "");
            wc.doSave();
            IOUtil.tryClose((Object[])new Object[]{os});
            throw throwable;
        }
        ILaunchConfigurationWorkingCopy wc = launchConfig.getWorkingCopy();
        wc.setAttribute("attribute_wut_query", "");
        wc.doSave();
        IOUtil.tryClose((Object[])new Object[]{os});
    }
}

