/*
 * Decompiled with CFR 0.152.
 */
package org.eclipselabs.jsdt.jquery.api.js;

import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.core.compiler.libraries.LibraryLocation;
import org.eclipse.wst.jsdt.core.compiler.libraries.SystemLibraryLocation;
import org.eclipselabs.jsdt.jquery.api.JQueryApiMessages;
import org.eclipselabs.jsdt.jquery.api.JQueryApiPlugin;
import org.eclipselabs.jsdt.jquery.api.Version;

abstract class JQueryGlobalScopeContainerInitializer
extends JsGlobalScopeContainerInitializer
implements IJsGlobalScopeContainerInitializer {
    private final Version version;
    private final boolean noConflict;
    private final LibraryLocation libraryLocation;
    private final char[][] libraryFileNames;

    JQueryGlobalScopeContainerInitializer(Version version, boolean noConflict) {
        this.version = version;
        this.noConflict = noConflict;
        this.libraryFileNames = new char[][]{JQueryGlobalScopeContainerInitializer.getLibraryFileName(version, noConflict).toCharArray()};
        this.libraryLocation = new JQueryLibraryLocation();
    }

    private static String getLibraryFileName(Version version, boolean noConflict) {
        if (noConflict) {
            return "jquery-doc-noconflict-" + version + ".js";
        }
        return "jquery-doc-" + version + ".js";
    }

    public String getDescription() {
        if (this.noConflict) {
            return NLS.bind((String)JQueryApiMessages.container_noConflictDescription, (Object)this.version.toString());
        }
        return NLS.bind((String)JQueryApiMessages.container_conflictDescription, (Object)this.version.toString());
    }

    public LibraryLocation getLibraryLocation() {
        return this.libraryLocation;
    }

    public boolean allowAttachJsDoc() {
        return false;
    }

    public boolean canUpdateJsGlobalScopeContainer(IPath containerPath, IJavaScriptProject project) {
        return true;
    }

    final class JQueryLibraryLocation
    extends SystemLibraryLocation {
        JQueryLibraryLocation() {
        }

        public char[][] getLibraryFileNames() {
            return JQueryGlobalScopeContainerInitializer.this.libraryFileNames;
        }

        protected String getPluginId() {
            return JQueryApiPlugin.getDefault().getBundle().getSymbolicName();
        }
    }
}

