/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.step;

import java.io.IOException;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.util.log.UserLogger;
import org.tizen.web.common.WebCommonActivator;
import org.tizen.web.zimlaunch.core.CompositeStep;
import org.tizen.web.zimlaunch.core.IStep;
import org.tizen.web.zimlaunch.debug.core.InspectorManager;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.step.Messages;

public class DebugInspectorOpenStep
extends CompositeStep {
    protected static final Logger logger = LoggerFactory.getLogger(DebugInspectorOpenStep.class);
    public static final String name = Messages.STEP_DEBUG_INSPECTOR_OPEN;
    protected TizenWebNotifier notifier;
    protected String url;
    protected int percent;

    public DebugInspectorOpenStep() {
        super(new IStep[0]);
    }

    @Override
    public void executeStep(ILaunchContext ctx) throws Exception {
        UserLogger.start((String)"web.launch", (String)".debug.inspector.open");
        this.preExecuteStep(ctx);
        String errMsg = "";
        int code = 0;
        this.notifier.notifyContents(NLS.bind((String)Messages.STEP_DEBUG_INSPECTOR_OPEN_WITH_URL, (Object)this.url), this.getWorkCount(50));
        ZimLaunchResource launchResource = (ZimLaunchResource)ctx.getValue((Object)"resource");
        if (this.runInspector(launchResource.getAppinfo().getAppID())) {
            UserLogger.end((String)"web.launch", (String)".debug.inspector.open");
        } else {
            String message = NLS.bind((String)Messages.STEP_DEBUG_INSPECTOR_OPEN_FAILED, (Object)WebCommonActivator.getChromeExceutePath());
            this.notifier.notifyContents(message, this.getWorkCount(100));
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPINSPECTOR_OPEN_FAIL.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name);
            TizenWebIDEException.abort(message, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
    }

    private boolean runInspector(String appId) {
        InspectorManager im = InspectorManager.getInstance();
        String[] options = WebCommonActivator.getChromeOptions();
        try {
            return im.runInspector(appId, this.url, options);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected void preExecuteStep(ILaunchContext ctx) throws Exception {
        this.notifier = (TizenWebNotifier)ctx.getValue((Object)"notifier");
        this.url = (String)ctx.getValue((Object)"url");
        this.work = 100;
        this.rwork = 100;
        this.percent = 100;
        this.pwork = this.notifier.getRemainWork() < 20 ? this.notifier.getPercentRemainWork(this.percent) : 10;
    }

    @Override
    public String getStepName() {
        return name;
    }
}

