/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CheckCycle {
    private final Map<String, List<String>> adjList = new HashMap<String, List<String>>();
    private final Set<String> visited = new HashSet<String>();

    public void addEdge(String source, String dest) {
        if (!this.adjList.containsKey(source)) {
            this.adjList.put(source, new ArrayList());
        }
        this.adjList.get(source).add(dest);
    }

    private boolean search(String pkg, String source) {
        boolean result = false;
        if (this.visited.contains(pkg)) {
            return result;
        }
        this.visited.add(pkg);
        List<String> children = this.adjList.get(pkg);
        if (children != null) {
            for (String str : children) {
                if (result) break;
                if (str.equals(source)) {
                    result = true;
                    break;
                }
                result |= this.search(str, source);
            }
        }
        return result;
    }

    public List<String> check(String source) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.adjList.containsKey(source)) {
            for (String pkg : this.adjList.get(source)) {
                this.visited.clear();
                if (!this.search(pkg, source)) continue;
                result.add(pkg);
            }
        }
        return result;
    }
}

