/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.csslint;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.builder.error.BuildErrorInfo;
import org.tizen.common.builder.error.Location;
import org.tizen.common.file.IResource;
import org.tizen.common.util.IOUtil;
import org.tizen.web.csslint.engine.CssLint;
import org.tizen.web.csslint.engine.CssLintResult;
import org.tizen.web.csslint.engine.Issue;
import org.tizen.web.csslint.engine.Option;

public class CssLintValidator {
    protected static final Logger logger = LoggerFactory.getLogger(CssLintValidator.class);
    protected CssLint cssLint = CssLint.getInstance();
    protected int severity = 1;

    public CssLintValidator() {
        this.resetOption();
    }

    public CssLint getCssLint() {
        return this.cssLint;
    }

    public void resetOption() {
        this.cssLint.resetOptions();
    }

    public void addOption(Option o) {
        this.cssLint.addOption(o);
    }

    public void addOption(Option o, String arg) {
        this.cssLint.addOption(o, arg);
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public int getSeverity() {
        return this.severity;
    }

    public CssLintResult validate(IResource res) {
        CssLintResult lintResult;
        block6: {
            if (res == null) {
                return null;
            }
            lintResult = null;
            InputStream is = null;
            try {
                try {
                    is = res.getContents();
                    lintResult = this.cssLint.lint(res.getPath(), IOUtil.getString((InputStream)is));
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    IOUtil.tryClose((Object[])new Object[]{is});
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{is});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{is});
        }
        return lintResult;
    }

    public Collection<BuildErrorInfo> validate(IResource res, String level) {
        CssLintResult lintResult;
        if (level.equalsIgnoreCase("IGNORE")) {
            return null;
        }
        if (level.equalsIgnoreCase("ERROR")) {
            this.severity = 2;
        }
        if ((lintResult = this.validate(res)) == null) {
            return null;
        }
        HashSet<BuildErrorInfo> buildErrInfos = new HashSet<BuildErrorInfo>();
        for (Issue issue : lintResult.getIssues()) {
            BuildErrorInfo info = new BuildErrorInfo(new Location(res, issue.getLine(), -1), this.severity, issue.getMessage());
            buildErrInfos.add(info);
        }
        return buildErrInfos;
    }
}

