/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.packager.ui.properties.multi.view.provider;

import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.common.util.ImageUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.web.packager.ui.Activator;

public abstract class AbstractImageLabelProvider
extends OwnerDrawLabelProvider {
    protected static String CHECKBOX_CHECKED_PATH = "icons/obj16/complete_tsk.png";
    protected static String CHECKBOX_UNCHECKED_PATH = "icons/obj16/incomplete_tsk.png";
    protected static String RADIO_CHECKED_PATH = "icons/obj16/brkp_obj.png";
    protected static String RADIO_UNCHECKED_PATH = "icons/obj16/brkpd_obj.png";

    public void update(ViewerCell cell) {
        super.update(cell);
        String text = this.getText(cell.getElement());
        if (!StringUtil.isEmpty((CharSequence)text)) {
            cell.setText("    " + text);
        }
    }

    protected void paint(Event event, Object element) {
        Image img = this.getImage(element);
        if (img != null) {
            Rectangle bounds = ((TableItem)event.item).getBounds(event.index);
            int x = bounds.x;
            int y = bounds.y + 1;
            if (StringUtil.isEmpty((CharSequence)this.getText(element))) {
                Rectangle imgBounds = img.getBounds();
                bounds.width /= 2;
                bounds.width -= imgBounds.width / 2;
                bounds.height /= 2;
                bounds.height -= imgBounds.height / 2;
                x = bounds.width > 0 ? bounds.x + bounds.width : bounds.x;
                y = bounds.height > 0 ? bounds.y + bounds.height : bounds.y;
            }
            event.gc.drawImage(img, x, y);
        }
    }

    public static Image getCheckboxImg(boolean isReferenced) {
        String buttonKey = "";
        buttonKey = isReferenced ? CHECKBOX_CHECKED_PATH : CHECKBOX_UNCHECKED_PATH;
        return ImageUtil.getImage((String)Activator.PLUGIN_ID, (String)buttonKey);
    }

    public Image getRadioImg(boolean isNativeMain) {
        if (isNativeMain) {
            return ImageUtil.getImage((String)Activator.PLUGIN_ID, (String)RADIO_CHECKED_PATH);
        }
        return ImageUtil.getImage((String)Activator.PLUGIN_ID, (String)RADIO_UNCHECKED_PATH);
    }

    protected abstract Image getImage(Object var1);

    protected abstract String getText(Object var1);

    protected void measure(Event arg0, Object arg1) {
    }

    protected void erase(Event event, Object element) {
    }
}

