/*
 * Decompiled with CFR 0.152.
 */
package json.validation;

import java.io.File;
import java.io.FileNotFoundException;
import json.util.JsonCharUtility;
import json.util.reader.JsonFileReader;
import json.util.reader.JsonReaderException;
import json.validation.JsonValidationException;
import json.validation.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;

public class JsonTextValidator {
    private JsonFileReader parser;
    public static final String KEY = "key";
    public static final String VIOLATION = "violation";

    public JsonTextValidator(IFile file) throws CoreException {
        this.parser = new JsonFileReader(file);
    }

    public JsonTextValidator(File file) throws FileNotFoundException {
        this.parser = new JsonFileReader(file);
    }

    public void parse() {
        try {
            char current = this.parser.getNextClean();
            if (current == '{') {
                this.doJsonObject();
            } else if (current == '[') {
                this.doJsonArray();
            } else {
                this.reportProblem(Messages.JsonTextValidator_2, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
            }
        }
        catch (Exception exception) {}
    }

    private void doJsonObject() throws JsonReaderException, JsonValidationException {
        char ch;
        do {
            if ((ch = this.parser.getNextClean()) == '}') {
                this.parser.getNextClean();
                break;
            }
            if (ch != '\"') {
                this.reportProblem(Messages.JsonTextValidator_4, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
                throw new JsonValidationException();
            }
            this.doJsonKey();
            ch = this.parser.getNextClean();
            if (ch != ':') {
                this.reportProblem(Messages.JsonTextValidator_6, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
                throw new JsonValidationException();
            }
            ch = this.parser.getNextClean();
            if (ch == '{') {
                this.doJsonObject();
            } else if (ch == '[') {
                this.doJsonArray();
            } else if (ch == 'n') {
                this.doJsonNull();
            } else if (ch == '\"') {
                this.doJsonValue();
            } else if (ch == 't') {
                this.doJsonTrueValue();
            } else if (ch == 'f') {
                this.doJsonFalseValue();
            } else if (Character.isDigit(ch) || ch == '-') {
                this.doJsonNumber();
            } else {
                this.reportProblem(Messages.JsonTextValidator_8, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
                throw new JsonValidationException();
            }
            if (this.parser.getCurrent() == ',') continue;
            if (this.parser.getCurrent() == '}') {
                this.parser.getNextClean();
                break;
            }
            this.reportProblem(String.valueOf(Messages.JsonTextValidator_10) + ch, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
            throw new JsonValidationException();
        } while (ch != '\uffff');
    }

    private void doJsonArray() throws JsonReaderException, JsonValidationException {
        char ch;
        do {
            if ((ch = this.parser.getNextClean()) == '{') {
                this.doJsonObject();
            } else if (ch == '[') {
                this.doJsonArray();
            } else if (ch == 'n') {
                this.doJsonNull();
            } else if (ch == '\"') {
                this.doJsonValue();
            } else if (ch == 't') {
                this.doJsonTrueValue();
            } else if (ch == 'f') {
                this.doJsonFalseValue();
            } else if (Character.isDigit(ch) || ch == '-') {
                this.doJsonNumber();
            } else {
                if (ch == ']') {
                    this.parser.getNextClean();
                    break;
                }
                this.reportProblem(Messages.JsonTextValidator_12, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
                throw new JsonValidationException();
            }
            ch = this.parser.getCurrent();
            if (ch == ',') continue;
            if (ch == ']') {
                this.parser.getNextClean();
                break;
            }
            this.reportProblem(String.valueOf(Messages.JsonTextValidator_14) + ch, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
            throw new JsonValidationException();
        } while (ch != '\uffff');
    }

    private void doJsonTrueValue() throws JsonReaderException, JsonValidationException {
        char ch = this.parser.getNextChar();
        if (ch != 'r') {
            this.reportProblem(Messages.JsonTextValidator_16, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
            throw new JsonValidationException();
        }
        ch = this.parser.getNextChar();
        if (ch != 'u') {
            this.reportProblem(Messages.JsonTextValidator_18, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
            throw new JsonValidationException();
        }
        ch = this.parser.getNextChar();
        if (ch != 'e') {
            this.reportProblem(Messages.JsonTextValidator_20, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
            throw new JsonValidationException();
        }
        ch = this.parser.getNextClean();
        if (JsonCharUtility.isNotClosed(ch)) {
            this.reportProblem(Messages.JsonTextValidator_22, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
            throw new JsonValidationException();
        }
    }

    private void doJsonFalseValue() throws JsonReaderException, JsonValidationException {
        char ch = this.parser.getNextChar();
        if (ch != 'a') {
            this.reportProblem(Messages.JsonTextValidator_24, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
            throw new JsonValidationException();
        }
        ch = this.parser.getNextChar();
        if (ch != 'l') {
            this.reportProblem(Messages.JsonTextValidator_26, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
            throw new JsonValidationException();
        }
        ch = this.parser.getNextChar();
        if (ch != 's') {
            this.reportProblem(Messages.JsonTextValidator_28, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
            throw new JsonValidationException();
        }
        ch = this.parser.getNextChar();
        if (ch != 'e') {
            this.reportProblem(Messages.JsonTextValidator_30, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
            throw new JsonValidationException();
        }
        ch = this.parser.getNextClean();
        if (JsonCharUtility.isNotClosed(ch)) {
            this.reportProblem(Messages.JsonTextValidator_32, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
            throw new JsonValidationException();
        }
    }

    private void doJsonNull() throws JsonReaderException, JsonValidationException {
        char ch = this.parser.getNextChar();
        if (ch != 'u') {
            this.reportProblem(Messages.JsonTextValidator_34, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
            throw new JsonValidationException();
        }
        ch = this.parser.getNextChar();
        if (ch != 'l') {
            this.reportProblem(Messages.JsonTextValidator_36, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
            throw new JsonValidationException();
        }
        ch = this.parser.getNextChar();
        if (ch != 'l') {
            this.reportProblem(Messages.JsonTextValidator_38, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
            throw new JsonValidationException();
        }
        ch = this.parser.getNextClean();
        if (JsonCharUtility.isNotClosed(ch)) {
            this.reportProblem(Messages.JsonTextValidator_40, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
            throw new JsonValidationException();
        }
    }

    private void doJsonValue() throws JsonReaderException, JsonValidationException {
        char ch;
        int earlyPrevious = 65535;
        do {
            int earlyPreviousPrevious = earlyPrevious;
            earlyPrevious = this.parser.getPrevious();
            char previous = this.parser.getCurrent();
            ch = this.parser.getNextChar();
            if (ch == '\uffff') {
                this.reportProblem(Messages.JsonTextValidator_42, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
                break;
            }
            if (ch != '\"' || earlyPreviousPrevious == 92 && earlyPrevious == 92 && previous == '\\' && ch == '\"') continue;
            if (earlyPrevious == 92 && '\\' == this.parser.getPrevious() && '\"' == ch) {
                ch = this.parser.getNextClean();
                break;
            }
            if (this.parser.getPrevious() == '\\') continue;
            ch = this.parser.getNextClean();
            break;
        } while (ch != '\uffff');
    }

    private void doJsonNumber() throws JsonReaderException, JsonValidationException {
        char ch;
        boolean decimalPointSet = false;
        do {
            if (Character.isDigit(ch = this.parser.getNextChar())) continue;
            if (JsonCharUtility.isClosed(ch)) break;
            if (!decimalPointSet && ch == '.') {
                decimalPointSet = true;
                continue;
            }
            if (JsonCharUtility.isNotWhiteSpace(ch)) {
                this.reportProblem(String.valueOf(Messages.JsonTextValidator_44) + ch + Messages.JsonTextValidator_45, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
                throw new JsonValidationException();
            }
            ch = this.parser.getNextClean();
            if (!JsonCharUtility.isNotClosed(ch)) break;
            this.reportProblem(Messages.JsonTextValidator_47, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
            throw new JsonValidationException();
        } while (ch != '\uffff');
    }

    private void doJsonKey() throws JsonReaderException, JsonValidationException {
        char previous;
        int earlyPreviousPrevious;
        char ch;
        int earlyPrevious = 65535;
        do {
            earlyPreviousPrevious = earlyPrevious;
            earlyPrevious = this.parser.getPrevious();
            previous = this.parser.getCurrent();
            ch = this.parser.getNextChar();
            if (ch != '\uffff') continue;
            this.reportProblem(Messages.JsonTextValidator_49, new Location(this.parser.getIFile(), "", this.parser.getPosition(), this.parser.getPosition()), 0, true);
            throw new JsonValidationException();
        } while ((ch != '\"' || earlyPreviousPrevious == 92 && earlyPrevious == 92 && previous == '\\' && ch == '\"' || (earlyPrevious != 92 || '\\' != this.parser.getPrevious() || '\"' != ch) && this.parser.getPrevious() == '\\') && ch != '\uffff');
    }

    public void reportProblem(String msg, Location loc, int violation, boolean isError) {
        try {
            IMarker marker = loc.file.createMarker("json.validation.marker");
            marker.setAttribute("message", (Object)msg);
            marker.setAttribute("charStart", loc.charStart);
            marker.setAttribute("charEnd", loc.charEnd);
            marker.setAttribute("severity", isError ? 2 : 1);
            marker.setAttribute(KEY, (Object)loc.key);
            marker.setAttribute(VIOLATION, violation);
        }
        catch (CoreException coreException) {}
    }

    public static class Location {
        IFile file;
        String key;
        int charStart;
        int charEnd;

        public Location(IFile file, String key, int charStart, int charEnd) {
            this.file = file;
            this.key = key;
            this.charStart = charStart;
            this.charEnd = charEnd;
        }
    }
}

