/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssTextUnderlinePosition
extends org.w3c.css.properties.css.CssTextUnderlinePosition {
    public static final CssIdent auto;
    public static final CssIdent alphabetic;
    public static final CssIdent below;
    public static final CssIdent[] horizontalValues;

    public static CssIdent getHorizontalValue(CssIdent ident) {
        for (CssIdent id : horizontalValues) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static final CssIdent getAllowedValue(CssIdent ident) {
        if (auto.equals(ident)) {
            return auto;
        }
        if (alphabetic.equals(ident)) {
            return alphabetic;
        }
        if (below.equals(ident)) {
            return below;
        }
        return CssTextUnderlinePosition.getHorizontalValue(ident);
    }

    public CssTextUnderlinePosition() {
        this.value = initial;
    }

    public CssTextUnderlinePosition(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 4) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssIdent horValue = null;
        CssIdent verValue = null;
        CssValue val = expression.getValue();
        char op = expression.getOperator();
        if (val.getType() != 0) {
            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
        }
        CssIdent ident = (CssIdent)val;
        if (inherit.equals(ident)) {
            this.value = inherit;
            if (check2 && expression.getCount() != 1) {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
        } else if (auto.equals(ident)) {
            this.value = auto;
            if (check2 && expression.getCount() != 1) {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
        } else if (alphabetic.equals(ident)) {
            this.value = alphabetic;
            if (check2 && expression.getCount() != 1) {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
        } else {
            int nbgot = 0;
            do {
                boolean match = false;
                if (verValue == null && below.equals(ident)) {
                    verValue = below;
                    match = true;
                } else if (horValue == null) {
                    horValue = CssTextUnderlinePosition.getHorizontalValue(ident);
                    boolean bl = match = horValue != null;
                }
                if (!match) {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                if (expression.getRemainingCount() == 1 || !check2 && ++nbgot == 2) break;
                if (op != ' ') {
                    throw new InvalidParamException("operator", new Character(op).toString(), ac);
                }
                expression.next();
                val = expression.getValue();
                op = expression.getOperator();
                if (val.getType() != 0) {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                ident = (CssIdent)val;
            } while (!expression.end());
            ArrayList<CssValue> v = new ArrayList<CssValue>(nbgot);
            if (horValue != null) {
                v.add(horValue);
            }
            if (verValue != null) {
                v.add(verValue);
            }
            this.value = nbgot > 1 ? new CssValueList(v) : (CssValue)v.get(0);
        }
        expression.next();
    }

    public CssTextUnderlinePosition(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        String[] _horizontalValues = new String[]{"left", "right"};
        horizontalValues = new CssIdent[_horizontalValues.length];
        int i = 0;
        for (String s : _horizontalValues) {
            CssTextUnderlinePosition.horizontalValues[i++] = CssIdent.getIdent(s);
        }
        alphabetic = CssIdent.getIdent("alphabetic");
        below = CssIdent.getIdent("below");
        auto = CssIdent.getIdent("auto");
    }
}

