/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.localization;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.web.localization.support.PatternConstructor;

public class LocaleFolderFilesContentProvider {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String WILDCARD = "*";
    public static final String DELIMITER = ":";

    public Object[] getElements(Object inputElement) {
        IFolder folder = (IFolder)inputElement;
        List<IFile> folderFiles = this.getFolderFileList(folder);
        if (folderFiles == null) {
            return null;
        }
        String patterns = "*.css:*.html:*.js:*.png";
        String ignoreFilter = "";
        List<IFile> filteredFiles = this.findFilesMatchingPattern(folderFiles, patterns, ignoreFilter);
        folderFiles = this.findFilesMatchingPattern(filteredFiles, "locales/*", ".*");
        folderFiles = this.findFilesMatchingPattern(folderFiles, "*.css:*.html:*.js:*.png", ".*");
        return folderFiles.toArray();
    }

    private List<IFile> getFolderFileList(IFolder folder) {
        if (folder == null) {
            return null;
        }
        ArrayList<IFile> files = new ArrayList<IFile>();
        try {
            IResource[] resources = folder.members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IFile) {
                    files.add((IFile)resources[i]);
                } else if (resources[i] instanceof IFolder) {
                    files.addAll(this.getFiles((IFolder)resources[i]));
                }
                ++i;
            }
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return files;
    }

    private List<IFile> getFiles(IFolder folder) {
        if (folder == null) {
            return null;
        }
        ArrayList<IFile> files = new ArrayList<IFile>();
        try {
            IResource[] resources = folder.members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IFile) {
                    files.add((IFile)resources[i]);
                } else if (resources[i] instanceof IFolder) {
                    files.addAll(this.getFiles((IFolder)resources[i]));
                }
                ++i;
            }
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return files;
    }

    private List<IFile> findFilesMatchingPattern(List<IFile> files, String patterns, String ignore) {
        ArrayList<IFile> outputFiles = new ArrayList<IFile>();
        block0: for (IFile file : files) {
            String[] patternArray;
            String pattern;
            int n;
            int n2;
            String[] stringArray;
            String name = file.getProjectRelativePath().toString();
            boolean ignorePatternMatched = false;
            if (ignore != null && !ignore.isEmpty()) {
                String[] patternIgnore;
                stringArray = patternIgnore = ignore.split(DELIMITER);
                n2 = patternIgnore.length;
                n = 0;
                while (n < n2) {
                    pattern = stringArray[n];
                    if (PatternConstructor.createPattern(pattern, true).matcher(name.toLowerCase()).matches()) {
                        ignorePatternMatched = true;
                        break;
                    }
                    ++n;
                }
                if (ignorePatternMatched) continue;
            }
            if (patterns == null || patterns.isEmpty()) {
                patterns = WILDCARD;
            }
            stringArray = patternArray = patterns.split(DELIMITER);
            n2 = patternArray.length;
            n = 0;
            while (n < n2) {
                pattern = stringArray[n];
                if (PatternConstructor.createPattern(pattern, true).matcher(name.toLowerCase()).matches()) {
                    outputFiles.add(file);
                    continue block0;
                }
                ++n;
            }
        }
        return outputFiles;
    }
}

