/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.localization.support;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.tizen.web.localization.support.PatternConstructor;

public class FilteredFilesContentProvider
extends ArrayContentProvider {
    public static final String WILDCARD = "*";
    public static final String DELIMITER = ":";

    public Object[] getElements(Object inputElement) {
        List projectFiles = (List)inputElement;
        String patterns = "*.css:*.html:*.js:*.png";
        String ignoreFilter = ".*";
        List<IFile> filteredFiles = this.findFilesMatchingPattern(projectFiles, patterns, ignoreFilter);
        return filteredFiles.toArray();
    }

    private List<IFile> findFilesMatchingPattern(List<IFile> files, String patterns, String ignore) {
        ArrayList<IFile> outputFiles = new ArrayList<IFile>();
        block0: for (IFile file : files) {
            String[] patternArray;
            String pattern;
            int n;
            int n2;
            String[] stringArray;
            String name = file.getName();
            boolean ignorePatternMatched = false;
            if (ignore != null && !ignore.isEmpty()) {
                String[] patternIgnore;
                stringArray = patternIgnore = ignore.split(DELIMITER);
                n2 = patternIgnore.length;
                n = 0;
                while (n < n2) {
                    pattern = stringArray[n];
                    if (PatternConstructor.createPattern(pattern, true).matcher(name.toLowerCase()).matches()) {
                        ignorePatternMatched = true;
                        break;
                    }
                    ++n;
                }
                if (ignorePatternMatched) continue;
            }
            if (patterns == null || patterns.isEmpty()) {
                patterns = WILDCARD;
            }
            stringArray = patternArray = patterns.split(DELIMITER);
            n2 = patternArray.length;
            n = 0;
            while (n < n2) {
                pattern = stringArray[n];
                if (PatternConstructor.createPattern(pattern, true).matcher(name.toLowerCase()).matches()) {
                    outputFiles.add(file);
                    continue block0;
                }
                ++n;
            }
        }
        return outputFiles;
    }
}

