/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.step;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.core.application.Version;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.PlatformInformationUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.PlatformInfo;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.web.common.JSONArray;
import org.tizen.web.common.JSONException;
import org.tizen.web.common.JSONObject;
import org.tizen.web.common.JSONTokener;
import org.tizen.web.zimlaunch.core.CompositeStep;
import org.tizen.web.zimlaunch.core.IStep;
import org.tizen.web.zimlaunch.exception.HTTPResponseCode;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.resource.TizenDeviceInfo;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.step.Messages;

public class DebugURLSettingStep
extends CompositeStep {
    protected static final Logger logger = LoggerFactory.getLogger(DebugURLSettingStep.class);
    protected static final String LATEST_JSON_DATA_DEFAULT_PATH = "json";
    protected static final String MOBILE_JSON_DATA_DEFAULT_PATH = "WidgetDebug";
    protected static final String WEARABLE_JSON_DATA_DEFAULT_PATH = "pagelist.json";
    public static final String name = Messages.STEP_DEBUG_URL_SETTING;
    protected TizenWebNotifier notifier;
    protected ZimLaunchResource resource;
    protected int timeout = 300;
    protected int lport;
    protected int percent;

    public DebugURLSettingStep() {
        super(new IStep[0]);
    }

    @Override
    public void executeStep(ILaunchContext ctx) throws CoreException {
        UserLogger.start((String)"web.launch", (String)".debug.url.setting");
        this.preExecuteStep(ctx);
        try {
            String debugUrl = this.getDebugUrl("http://127.0.0.1:", this.lport);
            ctx.setValue((Object)"url", (Object)debugUrl);
            logger.debug("Debugging URL: " + debugUrl, (Object)this.getWorkCount(100));
        }
        finally {
            UserLogger.end((String)"web.launch", (String)".debug.url.setting");
        }
    }

    protected String getDebugUrl(String baseUrl, int port) throws CoreException {
        TizenDeviceInfo deviceInfo = this.resource.getDeviceinfo();
        String inspectorPath = deviceInfo.getInspectorPath();
        String jsonPath = null;
        String inspectorUrlKey = null;
        String debugUrl = null;
        if (StringUtil.isEmpty((CharSequence)inspectorPath)) {
            try {
                IDevice device = deviceInfo.getDevice();
                PlatformInfo platformInfo = device.getPlatformInfo();
                String profileName = platformInfo.getProfileName();
                String platformVersion = platformInfo.getPlatformVersion();
                jsonPath = this.getJsonPath(device, profileName, platformVersion);
                logger.debug("json path : " + jsonPath);
                inspectorUrlKey = this.getInspectorPathKey(device, profileName, platformVersion);
                inspectorPath = this.getInspectorPath(baseUrl, port, jsonPath, inspectorUrlKey);
                logger.debug("inspector path : " + inspectorPath);
                if (!inspectorPath.startsWith("/")) {
                    inspectorPath = "/" + inspectorPath;
                }
                debugUrl = String.valueOf(baseUrl) + port + inspectorPath;
                logger.debug("debugUrl : " + debugUrl);
            }
            catch (IOException e) {
                int code = TizenWebIDEExceptionCode.WEB_IDE_FAIL_TO_WEBKIT_RESPONSE.getCode();
                this.generalError(e.getLocalizedMessage(), code);
            }
        }
        return debugUrl;
    }

    protected String getInspectorPath(String baseUrl, int port, String jsonPath, String inspectorUrlKey) throws IOException, CoreException {
        String inspectorPath;
        block9: {
            int code = 0;
            String errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name);
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpResponse response = this.getHttpResponse(httpclient, String.valueOf(baseUrl) + port + "/" + jsonPath);
            logger.debug("http response : " + response);
            if (response == null || 200 != (code = response.getStatusLine().getStatusCode())) {
                errMsg = String.valueOf(StringUtil.trim((String)errMsg)) + "\n (Return Code:" + code + ")" + HTTPResponseCode.getDescriptionforCode(code);
                TizenWebIDEException.abort(String.valueOf(Messages.getFailMessage((String)Messages.STEP_DEBUG_URL_SETTING)) + "\n" + (Object)((Object)TizenWebIDEExceptionCode.WEB_IDE_FAIL_TO_WEBKIT_RESPONSE), new TizenWebIDEException(errMsg), new TizenWebNotifier[0]);
            }
            HttpEntity entity = response.getEntity();
            inspectorPath = "";
            if (entity != null) {
                InputStream instream = null;
                try {
                    code = TizenWebIDEExceptionCode.WEB_IDE_FAIL_TO_READ_CONTENT.getCode();
                    instream = entity.getContent();
                    int contentLength = (int)entity.getContentLength();
                    logger.debug("content length : " + contentLength);
                    String content = StringUtil.asString((InputStream)instream);
                    logger.debug("content : " + content);
                    if (content.length() != contentLength) {
                        this.generalError(errMsg, code);
                    }
                    inspectorPath = this.getJsonValue(content, inspectorUrlKey);
                    logger.debug("inpectorPath : " + inspectorPath);
                }
                catch (IllegalStateException illegalStateException) {
                    this.generalError(errMsg, code);
                    IOUtil.tryClose((Object[])new Object[]{instream});
                    httpclient.getConnectionManager().shutdown();
                    break block9;
                }
                catch (JSONException jSONException) {
                    try {
                        this.generalError(errMsg, code);
                    }
                    catch (Throwable throwable) {
                        IOUtil.tryClose((Object[])new Object[]{instream});
                        httpclient.getConnectionManager().shutdown();
                        throw throwable;
                    }
                    IOUtil.tryClose((Object[])new Object[]{instream});
                    httpclient.getConnectionManager().shutdown();
                    break block9;
                }
                IOUtil.tryClose((Object[])new Object[]{instream});
                httpclient.getConnectionManager().shutdown();
            }
        }
        return inspectorPath;
    }

    protected String getInspectorPathKey(IDevice device, String profileName, String platformVersion) throws TimeoutException, SdbCommandRejectedException, IOException {
        Version version = new Version(PlatformInformationUtil.getPlatformVersion((IDevice)device));
        if (version.isSameOrBiggerThanVersion3()) {
            return "devtoolsFrontendUrl";
        }
        String[] stringArray = TizenPlatformConstants.PROFILE_WEARABLES;
        int n = TizenPlatformConstants.PROFILE_WEARABLES.length;
        int n2 = 0;
        while (n2 < n) {
            String wearablePlatform = stringArray[n2];
            if (wearablePlatform.equals(profileName)) {
                return "inspectorUrl";
            }
            ++n2;
        }
        return "inspector_url";
    }

    protected String getJsonPath(IDevice device, String profileName, String platformVersion) throws TimeoutException, SdbCommandRejectedException, IOException {
        Version version = new Version(PlatformInformationUtil.getPlatformVersion((IDevice)device));
        if (version.isSameOrBiggerThanVersion3()) {
            return LATEST_JSON_DATA_DEFAULT_PATH;
        }
        String[] stringArray = TizenPlatformConstants.PROFILE_WEARABLES;
        int n = TizenPlatformConstants.PROFILE_WEARABLES.length;
        int n2 = 0;
        while (n2 < n) {
            String wearableProfile = stringArray[n2];
            if (wearableProfile.equals(profileName)) {
                return WEARABLE_JSON_DATA_DEFAULT_PATH;
            }
            ++n2;
        }
        return MOBILE_JSON_DATA_DEFAULT_PATH;
    }

    protected String getJsonValue(String jsonContent, String jsonKey) throws JSONException {
        JSONObject obj = null;
        String responseURL = null;
        if (jsonContent.startsWith("[")) {
            JSONArray jsonArray = new JSONArray(new JSONTokener(jsonContent));
            obj = jsonArray.getJSONObject(0);
        } else {
            obj = new JSONObject(new JSONTokener(jsonContent));
        }
        responseURL = obj.getString(jsonKey);
        return responseURL;
    }

    @Deprecated
    protected HttpResponse getHttpResponse(String uri) throws ClientProtocolException, IOException {
        DefaultHttpClient httpclient = null;
        HttpResponse response = null;
        try {
            httpclient = new DefaultHttpClient();
            httpclient.getParams().setParameter("http.protocol.expect-continue", (Object)false);
            httpclient.getParams().setParameter("http.connection.timeout", (Object)(this.timeout * 1000));
            httpclient.getParams().setParameter("http.socket.timeout", (Object)(this.timeout * 1000));
            HttpGet httpget = new HttpGet(uri);
            response = httpclient.execute((HttpUriRequest)httpget);
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        return response;
    }

    protected HttpResponse getHttpResponse(DefaultHttpClient httpclient, String uri) throws ClientProtocolException, IOException {
        HttpResponse response = null;
        httpclient.getParams().setParameter("http.protocol.expect-continue", (Object)false);
        httpclient.getParams().setParameter("http.connection.timeout", (Object)(this.timeout * 1000));
        httpclient.getParams().setParameter("http.socket.timeout", (Object)(this.timeout * 1000));
        HttpGet httpget = new HttpGet(uri);
        response = httpclient.execute((HttpUriRequest)httpget);
        return response;
    }

    protected void generalError(String errMsg, int code) throws CoreException {
        TizenWebIDEException.abort(Messages.getFailMessage((String)Messages.STEP_DEBUG_URL_SETTING), new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
    }

    protected void preExecuteStep(ILaunchContext ctx) throws CoreException {
        String errMsg = "";
        int code = 0;
        this.resource = (ZimLaunchResource)ctx.getValue((Object)"resource");
        if (this.resource == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_LAUNCH_RESOURCE.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(Messages.getFailMessage((String)Messages.TRANSFER_PACKAGE), new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        this.notifier = (TizenWebNotifier)ctx.getValue((Object)"notifier");
        this.timeout = this.resource.getDeviceinfo().getTimeout();
        this.lport = (Integer)ctx.getValue((Object)"local port");
        this.work = 100;
        this.rwork = 100;
        this.percent = 30;
        this.pwork = this.notifier.getRemainWork() < 20 ? this.notifier.getPercentRemainWork(this.percent) : 10;
    }

    @Override
    public String getStepName() {
        return name;
    }
}

