/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.packager.ui;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.CommonPlugin;
import org.tizen.common.ITizenNativeProject;
import org.tizen.common.ITizenNativeXMLStore;
import org.tizen.common.ITizenProject;
import org.tizen.common.builder.BuildDependencyListener;
import org.tizen.common.builder.BuildResult;
import org.tizen.common.builder.IBuildDependency;
import org.tizen.common.builder.IBuildListener;
import org.tizen.common.builder.IBuilder;
import org.tizen.common.builder.dependency.DependencyInMemory;
import org.tizen.common.builder.exception.BuildException;
import org.tizen.common.builder.ide.IdeBuildProcess;
import org.tizen.common.core.application.PackageResourceInfo;
import org.tizen.common.core.application.TizenPackageInfoStore;
import org.tizen.common.core.application.Version;
import org.tizen.common.core.command.Executor;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.LinkedResource;
import org.tizen.common.file.StandardFileHandler;
import org.tizen.common.file.VirtualFileHandler;
import org.tizen.common.packager.PackageResource;
import org.tizen.common.ui.dialog.FileDialogUtils;
import org.tizen.common.ui.page.properties.PackageConfigUtil;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.Assert;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.FontUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.PluginUtil;
import org.tizen.common.util.ResourceUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.web.builder.BuilderFactory;
import org.tizen.web.builder.CowhideBuilder;
import org.tizen.web.builder.FontProjectBuilder;
import org.tizen.web.builder.UIFWBuilder;
import org.tizen.web.builder.ide.manager.BuildManager;
import org.tizen.web.builder.util.WebProjectUtil;
import org.tizen.web.common.WebConstant;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.config.schema.model.AppWidget;
import org.tizen.web.config.schema.model.Feature;
import org.tizen.web.config.schema.model.Metadata;
import org.tizen.web.config.schema.model.Privilege;
import org.tizen.web.config.schema.model.TrustAnchor;
import org.tizen.web.config.schema.model.UseSystemCertsType;
import org.tizen.web.config.schema.model.Widget;
import org.tizen.web.config.schema.model.WidgetContent;
import org.tizen.web.config.schema.model.WidgetIcon;
import org.tizen.web.config.schema.model.WidgetSize;
import org.tizen.web.editor.configuration.ConfigurationEditor;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.ConfiguratorFactory;
import org.tizen.web.editor.configuration.IMobileConfigurator;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.packager.core.IResourceHandler;
import org.tizen.web.packager.core.PackageProcessType;
import org.tizen.web.packager.core.exception.HandleException;
import org.tizen.web.packager.core.exception.PackageException;
import org.tizen.web.packager.ui.AbstractResourceHandler;
import org.tizen.web.packager.ui.Activator;
import org.tizen.web.packager.ui.Messages;
import org.tizen.web.packager.ui.util.PackageUtil;

public class ResourceManager
extends org.tizen.web.builder.ide.manager.ResourceManager {
    private static final String[] EXCLUDE_NATIVE_RESOURCES = new String[]{"/.sign*", "/manifest.xml", "/.manifest.tmp", "/tizen-manifest.xml", "/data", "/res/edje*/*.edc", "/shared/res/edje*/*.edc", "/res/po/*.po", "/shared/res/po/*.po", "*.ninja", "*.mk"};
    Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String projectFullPath = null;
    public static final String MERGED_APP_WIDGET_ID_FORMAT = "%s.%s";
    public static final String TRUE_VALUE = "true";
    public static final String FALSE_VALUE = "false";
    public static final int MODIFY_USE_SYSTEM_VALUE_TO_FALSE = 1;
    public int useSystemValueFlag = 0;
    HashMap<IProject, String> certsMap = new HashMap();

    public ResourceManager(IProject project) throws CoreException {
        super(project);
        this.setExcludes(project);
        this.projectFullPath = project.getLocation().toOSString();
    }

    private void setExcludes(IProject project) {
        HashSet<String> excludes = new HashSet<String>();
        excludes.addAll(Arrays.asList(WebConstant.DEFAULT_EXCLUDING_RESOURCES));
        if (ProjectUtil.isTizenWebUIFWProject((IProject)project) && ProjectUtil.isCheckedUsingTargetLibrary((IProject)project)) {
            excludes.add("tizen-web-ui-fw/*");
            excludes.add("tizen-web-ui-fw");
        } else if (ProjectUtil.isTizenCowhideProject((IProject)project) && ProjectUtil.isCheckedUsingTargetLibrary((IProject)project)) {
            excludes.add("cowhide/*");
            excludes.add("cowhide");
        }
        this.setExcludes(excludes.toArray(new String[0]));
    }

    public Collection<org.tizen.common.file.IResource> generatePackagingWebResources(PackageProcessType type) throws PackageException, CoreException, IOException, ConfigurationException {
        return this.generatePackagingWebResources(type, null);
    }

    public Collection<org.tizen.common.file.IResource> generatePackagingWebResources(PackageProcessType type, IProject mainProject) throws PackageException, CoreException, IOException, ConfigurationException {
        this.logger.debug("Get packaging web resources.");
        Collection<org.tizen.common.file.IResource> packagingWebResources = null;
        if (ResourceManager.getOriginResources((IProject)this.project) == null) {
            this.project.accept((IResourceVisitor)this);
        }
        this.modifyUseSystemCertsToFalse(mainProject);
        packagingWebResources = this.generatePackagableResources(ResourceManager.getOriginResources((IProject)this.project), true);
        this.handleCancel();
        packagingWebResources = this.handleUIFWProject(packagingWebResources);
        this.handleCancel();
        packagingWebResources = this.handleFontProject(packagingWebResources);
        this.handleCancel();
        packagingWebResources = this.handleCompanionProject(packagingWebResources);
        this.handleCancel();
        packagingWebResources = this.handleCompress(type, packagingWebResources);
        this.handleCancel();
        packagingWebResources = this.handleResourcesUsingExtension(type, packagingWebResources);
        this.handleCancel();
        packagingWebResources = this.handleWebWidgetProject(packagingWebResources);
        this.handleCancel();
        packagingWebResources = this.handleHybridProject(packagingWebResources);
        this.handleCancel();
        this.project.refreshLocal(2, null);
        return packagingWebResources;
    }

    private Collection<org.tizen.common.file.IResource> handleHybridProject(Collection<org.tizen.common.file.IResource> packagingWebResources) throws CoreException, PackageException {
        if (ProjectUtil.isHybridApp((IProject)this.project)) {
            this.checkProfiles(this.project, ProjectUtil.getReferencedNativeCoreProjects((IProject)this.project));
            this.logger.debug("Convert resources to hybrid app structure.");
            this.setSubTask(Messages.SUBTASK_STRUCTURE_HYBRID_APP);
            packagingWebResources = this.generateHybridWebResources(packagingWebResources);
        }
        return packagingWebResources;
    }

    private Collection<org.tizen.common.file.IResource> handleWebWidgetProject(Collection<org.tizen.common.file.IResource> packagingWebResources) throws CoreException, PackageException, IOException, ConfigurationException {
        Object[] webWidgetProjects = ProjectUtil.getReferenceWebWidgetProject((IProject)this.project);
        HashSet<org.tizen.common.file.IResource> excludeResources = new HashSet<org.tizen.common.file.IResource>();
        if (webWidgetProjects != null && !ArrayUtil.isEmpty((Object[])webWidgetProjects)) {
            for (org.tizen.common.file.IResource packagingResource : packagingWebResources) {
                if (!packagingResource.getPath().equals("config.xml")) continue;
                excludeResources.add(packagingResource);
            }
            packagingWebResources.removeAll(excludeResources);
            packagingWebResources = this.makeTempFile(packagingWebResources);
            Object[] objectArray = webWidgetProjects;
            int n = webWidgetProjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object webWidgetProject = objectArray[n2];
                this.generateWebWidgetConfiguration(this.project, (IProject)webWidgetProject);
                this.existDirectoryInWidget(this.project, webWidgetProject.getName());
                Collection<org.tizen.common.file.IResource> packagingWebWidgetResources = this.generatePackagableResources(ResourceManager.getOriginResources((IProject)webWidgetProject), true);
                if (!this.existWidgetDirectory((IProject)webWidgetProject, packagingWebWidgetResources) && DialogUtil.openQuestionDialog((String)Messages.WARNING, (String)Messages.WEB_WIDGET_DIRECTORY_WARNING) == 128) {
                    throw new PackageException(Messages.PACKAGE_CANCELED);
                }
                packagingWebWidgetResources = this.generateWebWidgetResources(packagingWebWidgetResources, (IProject)webWidgetProject, false);
                this.checkExistResource(packagingWebResources, packagingWebWidgetResources);
                packagingWebResources.addAll(packagingWebWidgetResources);
                ++n2;
            }
            if (ProjectUtil.isHybridApp((IProject)this.project)) {
                String configurationPath = String.valueOf(this.project.getLocation().toString()) + "/" + "widgettempdir" + "/" + "config.xml";
                String innerConfigurationPath = String.valueOf(this.project.getLocation().toString()) + "/" + "widgettempdir" + "/" + "inner_config.xml";
                FileUtil.copyTo((String)configurationPath, (String)innerConfigurationPath);
                IFile file = this.project.getFile("widgettempdir/inner_config.xml");
                org.tizen.common.file.IResource res = this.createResource((IResource)file);
                packagingWebResources.add((org.tizen.common.file.IResource)new PackageResource(res.getFileHandler(), res.getPath(), "res/wgt/config.xml"));
                org.tizen.common.file.IResource configResource = ResourceUtil.getResource((String)"widgettempdir/config.xml", (org.tizen.common.file.IResource[])packagingWebResources.toArray(new org.tizen.common.file.IResource[0]));
                this.createCoreHybridConfigResource((FileHandler)new StandardFileHandler(String.valueOf(this.project.getLocation().toOSString()) + "/" + "widgettempdir"), configResource);
            }
        } else if (ProjectUtil.isWebWidgetProject((IProject)this.project)) {
            Collection<org.tizen.common.file.IResource> packagingWebWidgetResources = this.generateWebWidgetResources(packagingWebResources, this.project, true);
            if (!this.existWidgetDirectory(this.project, packagingWebWidgetResources) && DialogUtil.openQuestionDialog((String)Messages.WARNING, (String)Messages.WEB_WIDGET_DIRECTORY_WARNING) == 128) {
                throw new PackageException(Messages.PACKAGE_CANCELED);
            }
            packagingWebResources.removeAll(packagingWebResources);
            packagingWebWidgetResources = this.makeTempFile(packagingWebWidgetResources);
            this.generateWebWidgetConfiguration(this.project);
            packagingWebResources.addAll(packagingWebWidgetResources);
        }
        return packagingWebResources;
    }

    private void checkExistResource(Collection<org.tizen.common.file.IResource> packagingWebResources, Collection<org.tizen.common.file.IResource> packagingWebWidgetResources) throws PackageException {
        int checkValue = -1;
        HashSet<org.tizen.common.file.IResource> removeWebResource = new HashSet<org.tizen.common.file.IResource>();
        HashSet<org.tizen.common.file.IResource> removeWebWidgetResource = new HashSet<org.tizen.common.file.IResource>();
        for (org.tizen.common.file.IResource webResource : packagingWebResources) {
            for (org.tizen.common.file.IResource webWidgetResource : packagingWebWidgetResources) {
                if (!webResource.getPath().equals(webWidgetResource.getPath())) continue;
                if (checkValue != 1) {
                    checkValue = FileDialogUtils.checkOverwrite((String)webResource.getPath());
                    if (checkValue == 0) {
                        removeWebResource.add(webResource);
                    } else if (checkValue == 2) {
                        removeWebWidgetResource.add(webWidgetResource);
                    } else if (checkValue == 3) {
                        throw new PackageException(Messages.PACKAGE_CANCELED);
                    }
                }
                if (checkValue != 1) continue;
                removeWebResource.add(webResource);
            }
        }
        packagingWebResources.removeAll(removeWebResource);
        packagingWebWidgetResources.removeAll(removeWebWidgetResource);
    }

    private boolean existWidgetDirectory(IProject webWidgetProject, Collection<org.tizen.common.file.IResource> packagingWebWidgetResources) {
        for (org.tizen.common.file.IResource resource : packagingWebWidgetResources) {
            File file;
            if (!resource.getName().equals("widget") || !(file = new File(String.valueOf(webWidgetProject.getLocation().toString()) + "/" + "widget")).isDirectory()) continue;
            return true;
        }
        return false;
    }

    private void existDirectoryInWidget(IProject project, String widgetProjectName) throws PackageException {
        if (FileUtil.isExist((String)(String.valueOf(project.getLocation().toString()) + "/" + "widget" + "/" + widgetProjectName))) {
            throw new PackageException(String.valueOf(widgetProjectName) + " is same with directory name in widget folder.");
        }
    }

    private Collection<org.tizen.common.file.IResource> makeTempFile(Collection<org.tizen.common.file.IResource> tempResources) throws PackageException, IOException, CoreException {
        org.tizen.common.file.IResource res = null;
        String tempDirectoryPath = String.valueOf(this.project.getLocation().toString()) + "/" + "widgettempdir";
        if (FileUtil.isExist((String)tempDirectoryPath)) {
            FileUtil.recursiveDelete((String)tempDirectoryPath);
        }
        FileUtil.createDirectory((String)tempDirectoryPath);
        IFile file = FileUtil.getIFile((IProject)this.project, (String)(String.valueOf(tempDirectoryPath) + "/" + "config.xml"), (String)"", null);
        file = this.project.getFile("widgettempdir/config.xml");
        res = this.createResource((IResource)file);
        Assert.notNull((Object)res);
        tempResources.add((org.tizen.common.file.IResource)new PackageResource(res.getFileHandler(), res.getPath(), "config.xml"));
        if (ProjectUtil.isHybridApp((IProject)this.project)) {
            tempResources.add((org.tizen.common.file.IResource)new PackageResource(res.getFileHandler(), "widgettempdir/inner_config.xml", "res/wgt/config.xml"));
        }
        return tempResources;
    }

    private void generateWebWidgetConfiguration(IProject webProject) throws IOException, PackageException {
        try {
            String tempConfigurationPath = "widgettempdir/config.xml";
            ITizenConfigurator webConfigurator = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)webProject);
            webConfigurator.doSave(tempConfigurationPath);
        }
        catch (ConfigurationException e) {
            throw new PackageException((Exception)((Object)e));
        }
    }

    private void generateWebWidgetConfiguration(IProject webProject, IProject widgetProject) throws IOException, PackageException {
        try {
            String tempConfigurationPath = "widgettempdir/config.xml";
            ITizenConfigurator widgetConfigurator = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)widgetProject);
            ITizenConfigurator webConfigurator = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)webProject);
            ITizenConfigurator tempConfigurator = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)webProject, (String)tempConfigurationPath);
            ITizenConfigurator config = tempConfigurator == null ? webConfigurator : tempConfigurator;
            String webProjectId = null;
            ArrayList<String> existAppWidgetIdList = new ArrayList<String>();
            if (webConfigurator instanceof IMobileConfigurator) {
                webProjectId = String.valueOf(((IMobileConfigurator)webConfigurator).getApplicationPackage()) + "." + webProject.getName();
            }
            if (widgetConfigurator instanceof IMobileConfigurator) {
                this.generatePrivilegeElements(tempConfigurationPath, widgetConfigurator, webConfigurator, tempConfigurator);
                List existWidgetList = ((IMobileConfigurator)config).getDynamicBoxes();
                for (AppWidget wgt : existWidgetList) {
                    existAppWidgetIdList.add(this.getWebWidgetId(wgt.getId()));
                }
                List appWidgetList = ((IMobileConfigurator)widgetConfigurator).getDynamicBoxes();
                for (AppWidget wgt : appWidgetList) {
                    AppWidget appWidgetElement = new AppWidget();
                    if (existAppWidgetIdList.contains(this.getWebWidgetId(wgt.getId()))) {
                        throw new PackageException(String.valueOf(this.getWebWidgetId(wgt.getId())) + " exists with a different web widget project.");
                    }
                    appWidgetElement.setId(this.getMergedAppWidgetID(webProjectId, wgt.getId()));
                    appWidgetElement.setPrimary(wgt.getPrimary());
                    appWidgetElement.setUpdatePeriod(wgt.getUpdatePeriod());
                    List contents = wgt.getContent();
                    for (Object content : contents) {
                        if (content instanceof WidgetIcon) {
                            ((WidgetIcon)content).setSrc(((WidgetIcon)content).getSrc());
                        } else if (content instanceof WidgetContent) {
                            ((WidgetContent)content).setSrc(((WidgetContent)content).getSrc());
                            for (Object widgetSize : ((WidgetContent)content).getContent()) {
                                if (!(widgetSize instanceof WidgetSize)) continue;
                                ((WidgetSize)widgetSize).setPreview(((WidgetSize)widgetSize).getPreview());
                            }
                        }
                        appWidgetElement.getContent().add(content);
                    }
                    config.addElement((Object)appWidgetElement);
                }
            }
            if (this.useSystemValueFlag == 1 && this.certsMap.get(this.project) != null && this.certsMap.get(webProject).equals(TRUE_VALUE) && config instanceof IMobileConfigurator) {
                ((IMobileConfigurator)config).setTrustAnchorUseSystemCerts(UseSystemCertsType.FALSE);
            }
            config.doSave(tempConfigurationPath);
        }
        catch (ConfigurationException e) {
            throw new PackageException((Exception)((Object)e));
        }
    }

    private void generatePrivilegeElements(String tempConfigurationPath, ITizenConfigurator widgetConfigurator, ITizenConfigurator webConfigurator, ITizenConfigurator tempConfigurator) throws IOException, ConfigurationException {
        List privileges = ((IMobileConfigurator)widgetConfigurator).getPrivileges();
        ITizenConfigurator config = tempConfigurator == null ? webConfigurator : tempConfigurator;
        List existPrivilegeList = ((IMobileConfigurator)config).getPrivileges();
        if (privileges != null) {
            Version widgetVersion;
            Version webVersion = new Version(((IMobileConfigurator)webConfigurator).getApplicationRequiredVersion());
            if (webVersion.compareTo(widgetVersion = new Version(((IMobileConfigurator)widgetConfigurator).getApplicationRequiredVersion())) == 1) {
                Executor executor = CommonPlugin.getDefault().getExecutor();
                executor.getContext().getPrompter().notify(Messages.VERSION_WARNNING_WEB_WIDGET);
            }
            privileges.removeAll(existPrivilegeList);
            for (Privilege pri : privileges) {
                Privilege privilegeElement = new Privilege();
                privilegeElement.setName(pri.getName());
                config.addElement((Object)privilegeElement);
            }
            config.doSave(tempConfigurationPath);
        }
    }

    private String getMergedAppWidgetID(String webProjectId, String webWidgetProjectId) {
        String webWidgetId = this.getWebWidgetId(webWidgetProjectId);
        webWidgetProjectId = String.format(MERGED_APP_WIDGET_ID_FORMAT, webProjectId, webWidgetId);
        return webWidgetProjectId;
    }

    private String getWebWidgetId(String webWidgetProjectId) {
        String[] webWidgetId = webWidgetProjectId.split("[.]");
        return webWidgetId[2];
    }

    private Collection<org.tizen.common.file.IResource> generateWebWidgetResources(Collection<org.tizen.common.file.IResource> resources, IProject webWidgetProject, boolean isStandAlone) throws PackageException, CoreException {
        HashSet<org.tizen.common.file.IResource> webWidgetResources = new HashSet<org.tizen.common.file.IResource>();
        String widgetDirectoryPath = this.generateWebWidgetPath(webWidgetProject.getName());
        PackageResource addingResource = null;
        for (org.tizen.common.file.IResource packagingResource : resources) {
            if (packagingResource == null || packagingResource.getPath().equals("config.xml") || !isStandAlone && packagingResource.getPath().equals("index.html")) continue;
            String destPath = FileUtil.appendPath((String)widgetDirectoryPath, (String)packagingResource.getPath());
            if (packagingResource.getPath().equals("widgettempdir" + File.separator + "config.xml")) continue;
            if (packagingResource instanceof PackageResource) {
                destPath = FileUtil.appendPath((String)widgetDirectoryPath, (String)((PackageResource)packagingResource).getDestination());
                ((PackageResource)packagingResource).setDestination(destPath);
                addingResource = packagingResource;
            } else {
                addingResource = new PackageResource(packagingResource.getFileHandler(), packagingResource.getPath(), destPath);
            }
            webWidgetResources.add((org.tizen.common.file.IResource)addingResource);
        }
        return webWidgetResources;
    }

    private String generateWebWidgetPath(String webWidgetProjectName) throws CoreException {
        String path = "";
        if (ProjectUtil.isHybridApp((IProject)this.project)) {
            path = "res/wgt";
        }
        return path;
    }

    private void checkProfiles(IProject webProject, IProject[] referencedNativeCoreProjects) throws PackageException {
        String webProfile = PackageUtil.getProfile(webProject);
        if (StringUtil.isEmpty((CharSequence)webProfile)) {
            return;
        }
        IProject[] iProjectArray = referencedNativeCoreProjects;
        int n = referencedNativeCoreProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject nativeProject = iProjectArray[n2];
            String nativeProfile = PackageUtil.getNativeProfile(nativeProject);
            if (StringUtil.isEmpty((CharSequence)nativeProfile)) {
                return;
            }
            if (!webProfile.equals(nativeProfile)) {
                Object[] bind = new String[]{this.project.getName(), webProfile, nativeProject.getName(), nativeProfile};
                String errMsg = NLS.bind((String)Messages.PROFILE_MUST_BE_SAME, (Object[])bind);
                throw new PackageException(errMsg);
            }
            ++n2;
        }
    }

    private Collection<org.tizen.common.file.IResource> handleCompress(PackageProcessType mode, Collection<org.tizen.common.file.IResource> packagingWebResources) throws CoreException {
        String tempPackageDir = FileUtil.appendPath((String)this.projectFullPath, (String)".package");
        if (PackageUtil.needToOptimize((IProject)this.project) && (PackageProcessType.RELEASE.equals((Object)mode) || PackageProcessType.RUN.equals((Object)mode))) {
            try {
                this.logger.debug("Optimize web resources.");
                packagingWebResources = this.compressResources(tempPackageDir, packagingWebResources);
            }
            catch (BuildException e) {
                throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, e.getMessage(), (Throwable)e));
            }
        }
        return packagingWebResources;
    }

    private Collection<org.tizen.common.file.IResource> handleFontProject(Collection<org.tizen.common.file.IResource> packagingWebResources) throws PackageException {
        try {
            if (WebProjectUtil.isFontProject((IProject)this.project)) {
                String fontDir = FileUtil.appendPath((String)this.project.getLocation().toOSString(), (String)"shared/res");
                if (FontUtil.getFontPathList((String)fontDir, (String[])WebConstant.SUPPORT_FONT_EXTENSIONS).length <= 0 && !PackageUtil.continueToPackage(Messages.DIALOG_TITLE_FONT_FILE_DOES_NOT_EXIST, Messages.DIALOG_MSG_FONT_FILE_DOES_NOT_EXIST, "pref.package.always.font.file.does.not.exist")) {
                    this.monitor.setCanceled(true);
                    this.handleCancel();
                }
                packagingWebResources = this.generateFontResources(packagingWebResources);
            }
        }
        catch (ConfigurationException e) {
            throw new PackageException((Exception)((Object)e), e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new PackageException((Exception)e, e.getLocalizedMessage());
        }
        catch (BuildException e) {
            throw new PackageException((Exception)((Object)e), e.getLocalizedMessage());
        }
        return packagingWebResources;
    }

    private Collection<org.tizen.common.file.IResource> handleUIFWProject(Collection<org.tizen.common.file.IResource> packagingWebResources) throws PackageException {
        if ((ProjectUtil.isTizenWebUIFWProject((IProject)this.project) || ProjectUtil.isTizenCowhideProject((IProject)this.project)) && ProjectUtil.isCheckedUsingTargetLibrary((IProject)this.project)) {
            this.logger.debug("Generate ui framework resources.");
            try {
                packagingWebResources = this.generateUiFwResources(packagingWebResources);
            }
            catch (CoreException e) {
                throw new PackageException((Exception)((Object)e), e.getLocalizedMessage());
            }
        }
        return packagingWebResources;
    }

    private Collection<org.tizen.common.file.IResource> handleCompanionProject(Collection<org.tizen.common.file.IResource> packagingWebResources) throws PackageException, IOException, ConfigurationException {
        IProject companionProject = ProjectUtil.getCompanionWebProject((IProject)this.project);
        if (companionProject != null) {
            Collection companionResources = ResourceManager.getOriginResources((IProject)companionProject);
            for (org.tizen.common.file.IResource resource : companionResources) {
                if (!resource.getPath().startsWith(".trust-anchor")) continue;
                packagingWebResources.add((org.tizen.common.file.IResource)new PackageResource((FileHandler)new StandardFileHandler(companionProject.getLocation().toOSString()), resource.getPath(), resource.getPath()));
            }
            try {
                String companionWgtPath = null;
                String resourcePath = null;
                resourcePath = this.useSystemValueFlag == 1 && this.certsMap.get(this.project) != null && this.certsMap.get(this.project).equals(TRUE_VALUE) ? ".package/" + this.project.getName() + "/" + "config.xml" : "config.xml";
                companionWgtPath = this.generateCompanionInfo(this.project, ResourceUtil.getResource((String)resourcePath, (org.tizen.common.file.IResource[])packagingWebResources.toArray(new org.tizen.common.file.IResource[0])));
                if (companionWgtPath != null) {
                    String companionFullPath = FileUtil.appendPath((String)this.projectFullPath, (String)companionWgtPath);
                    org.tizen.common.file.IResource companionWgtResource = ResourceUtil.getResource((String)companionFullPath, (org.tizen.common.file.IResource[])packagingWebResources.toArray(new org.tizen.common.file.IResource[0]));
                    if (companionWgtResource != null) {
                        companionWgtResource.getFileHandler().removeFile(companionWgtPath);
                        packagingWebResources.remove(companionWgtResource);
                    }
                    FileUtil.copyTo((String)PackageUtil.getPackagePath((IProject)companionProject), (String)companionFullPath);
                    this.project.refreshLocal(2, null);
                    packagingWebResources.add((org.tizen.common.file.IResource)new PackageResource((FileHandler)new StandardFileHandler(this.projectFullPath), companionWgtPath, companionWgtPath));
                }
            }
            catch (IOException e) {
                throw new PackageException((Exception)e, e.getLocalizedMessage());
            }
            catch (CoreException e) {
                throw new PackageException((Exception)((Object)e), e.getLocalizedMessage());
            }
            catch (ConfigurationException e) {
                throw new PackageException((Exception)((Object)e), e.getLocalizedMessage());
            }
        }
        return packagingWebResources;
    }

    private Collection<org.tizen.common.file.IResource> handleResourcesUsingExtension(PackageProcessType mode, Collection<org.tizen.common.file.IResource> packagingWebResources) throws PackageException {
        List<IResourceHandler> handlerList;
        try {
            handlerList = this.getHandlerList();
        }
        catch (CoreException e) {
            throw new PackageException((Exception)((Object)e), e.getLocalizedMessage());
        }
        for (IResourceHandler rh : handlerList) {
            Collection tempResources;
            try {
                if (rh instanceof AbstractResourceHandler) {
                    ((AbstractResourceHandler)rh).setMonitor(this.monitor);
                }
                tempResources = rh.run(this.projectFullPath, packagingWebResources, mode);
                this.handleCancel();
            }
            catch (HandleException e) {
                throw new PackageException((Exception)((Object)e), e.getLocalizedMessage());
            }
            if (tempResources == null) continue;
            packagingWebResources = tempResources;
        }
        return packagingWebResources;
    }

    private List<IResourceHandler> getHandlerList() throws CoreException {
        String[] extPointIds = new String[]{"org.tizen.web.packager.ui.resourceHandlers", "org.tizen.web.packager.core.resourceHandlers"};
        ArrayList<IResourceHandler> resultList = new ArrayList<IResourceHandler>();
        String[] stringArray = extPointIds;
        int n = extPointIds.length;
        int n2 = 0;
        while (n2 < n) {
            String extPointId = stringArray[n2];
            IConfigurationElement[] ces = PluginUtil.getExtensionConfigurationElements((String)extPointId);
            if (ces != null) {
                IConfigurationElement[] iConfigurationElementArray = ces;
                int n3 = ces.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    if (ce.getAttribute("class") != null) {
                        IResourceHandler resourceHandler = (IResourceHandler)ce.createExecutableExtension("class");
                        resultList.add(resourceHandler);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return resultList;
    }

    private Collection<org.tizen.common.file.IResource> generateFontResources(Collection<org.tizen.common.file.IResource> packagingWebResources) throws BuildException {
        BuildResult br;
        org.tizen.common.file.IResource resource = ResourceUtil.getResource((String)"config.xml", (org.tizen.common.file.IResource[])packagingWebResources.toArray(new org.tizen.common.file.IResource[0]));
        if (resource == null) {
            this.logger.debug("config.xml does not exist.");
            return packagingWebResources;
        }
        String outputPath = FileUtil.appendPath((String)this.projectFullPath, (String)FileUtil.appendPath((String)".package", (String)"font-project"));
        FontProjectBuilder builder = new FontProjectBuilder(this.projectFullPath, outputPath);
        if (builder.canBuild(resource) && BuildResult.Status.SUCCESS.equals((Object)(br = builder.build(resource)).getResult())) {
            Collection outputs = br.getOutputs(resource);
            packagingWebResources.remove(resource);
            packagingWebResources.addAll(outputs);
        }
        return packagingWebResources;
    }

    private void setSubTask(String subTask) {
        if (this.monitor != null) {
            this.monitor.subTask(subTask);
        }
    }

    private String generateCompanionInfo(IProject project, org.tizen.common.file.IResource configResource) throws ConfigurationException, IOException {
        this.logger.debug("Generate companion informaion to config file.");
        String companionAppPathValue = null;
        if (configResource == null || !configResource.getPath().endsWith("config.xml")) {
            return companionAppPathValue;
        }
        InputStream is = null;
        UseSystemCertsType type = null;
        ITizenConfigurator mainConfig = null;
        try {
            is = configResource.getContents();
            ITizenConfigurator widgetConfig = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)project, (InputStream)is, (String)configResource.getPath());
            if (!configResource.getPath().equals("config.xml")) {
                mainConfig = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)project);
                TrustAnchor ta = null;
                if (mainConfig instanceof IMobileConfigurator && (ta = ((IMobileConfigurator)mainConfig).getTrustAnchor()) != null) {
                    type = ta.getUseSystemCerts();
                }
            }
            if (widgetConfig instanceof IMobileConfigurator) {
                IMobileConfigurator tizenConfig = (IMobileConfigurator)widgetConfig;
                List metaDatas = tizenConfig.getMetadatas();
                Metadata wearableAppTypeMeta = null;
                Metadata wearableAppLocationMeta = null;
                for (Metadata metaData : metaDatas) {
                    if ("WearableAppType".equals(metaData.getKey())) {
                        wearableAppTypeMeta = metaData;
                        if (wearableAppLocationMeta == null) continue;
                        break;
                    }
                    if (!"WearableAppLocation".equals(metaData.getKey()) || !metaData.getValue().endsWith("wgt")) continue;
                    wearableAppLocationMeta = metaData;
                    companionAppPathValue = wearableAppLocationMeta.getValue();
                    if (wearableAppTypeMeta != null) break;
                }
                if (wearableAppTypeMeta == null) {
                    wearableAppTypeMeta = new Metadata();
                    wearableAppTypeMeta.setKey("WearableAppType");
                    wearableAppTypeMeta.setValue("Linked");
                    tizenConfig.addElement((Object)wearableAppTypeMeta);
                }
                if (wearableAppLocationMeta == null) {
                    wearableAppLocationMeta = new Metadata();
                    wearableAppLocationMeta.setKey("WearableAppLocation");
                    IProject companionProject = ProjectUtil.getCompanionWebProject((IProject)project);
                    if (companionProject != null) {
                        companionAppPathValue = FileUtil.appendPath((String)"res", (String)PackageUtil.getPackageName((IProject)companionProject));
                        wearableAppLocationMeta.setValue(companionAppPathValue);
                        tizenConfig.addElement((Object)wearableAppLocationMeta);
                    }
                }
                if (!this.updateConfigurationEditor(project, (ITizenConfigurator)tizenConfig)) {
                    tizenConfig.doSave();
                }
                if (mainConfig != null) {
                    if (type != null) {
                        ((IMobileConfigurator)mainConfig).setTrustAnchorUseSystemCerts(type);
                    }
                    mainConfig.doSave();
                }
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{is});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{is});
        return companionAppPathValue;
    }

    private boolean updateConfigurationEditor(IProject project, ITizenConfigurator config) throws IOException, ConfigurationException {
        IEditorReference[] editorReferences = SWTUtil.getEditorReferences();
        if (editorReferences == null) {
            return false;
        }
        IEditorReference[] iEditorReferenceArray = editorReferences;
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationEditor configEditor;
            IEditorReference editorRef = iEditorReferenceArray[n2];
            if (editorRef.getId().equalsIgnoreCase("org.tizen.web.editor.configuration.ConfigurationEditor") && (configEditor = (ConfigurationEditor)editorRef.getEditor(true)) != null && project == configEditor.getProject()) {
                config.doSave();
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        configEditor.reloadPage(configEditor.tizenPageIndex);
                    }
                });
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Collection<org.tizen.common.file.IResource> compressResources(String path, Collection<org.tizen.common.file.IResource> resources) throws BuildException, CoreException {
        IdeBuildProcess bp = new IdeBuildProcess(this.monitor);
        bp.setTask(Messages.SUBTASK_OPTIMIZE_RESOURCES);
        bp.addBuilders(BuilderFactory.generateCompressBuilders((String)path, (String[])ProjectUtil.getExcludingOptimizeOptions((IProject)this.project)));
        DependencyInMemory bd = new DependencyInMemory();
        bp.addListener((IBuildListener)new BuildDependencyListener((IBuildDependency)bd));
        this.handleCancel();
        bp.build(resources.toArray(new org.tizen.common.file.IResource[0]));
        this.handleCancel();
        return BuildManager.getBuiltResources((IBuildDependency)bd, (org.tizen.common.file.IResource[])resources.toArray(new org.tizen.common.file.IResource[0]));
    }

    private Collection<org.tizen.common.file.IResource> getDeltaResources(Collection<org.tizen.common.file.IResource> deltaResources, Collection<org.tizen.common.file.IResource> packagableResources, boolean useBuiltResources) {
        HashSet<org.tizen.common.file.IResource> resources = new HashSet<org.tizen.common.file.IResource>();
        for (org.tizen.common.file.IResource resource : deltaResources) {
            if (!packagableResources.contains(resource)) continue;
            resources.add(resource);
        }
        if (useBuiltResources) {
            return BuildManager.getBuiltResources((IBuildDependency)BuildManager.getBuildDependency((String)this.project.getName()), (org.tizen.common.file.IResource[])resources.toArray(new org.tizen.common.file.IResource[0]));
        }
        return deltaResources;
    }

    private Collection<org.tizen.common.file.IResource> generatePackagableResources(Collection<org.tizen.common.file.IResource> originResources, boolean useBuiltResources) throws IOException, ConfigurationException {
        HashSet<org.tizen.common.file.IResource> packagingWebResources = new HashSet<org.tizen.common.file.IResource>();
        ITizenProject tproject = ProjectUtil.getTizenProject((IProject)this.project);
        TizenPackageInfoStore pkgStore = tproject.getTizenPkgInfoStore();
        List blackList = pkgStore.getBlackList();
        List excludeList = pkgStore.getExcludeList();
        List invisibleList = pkgStore.getInvisiblePkgRes();
        for (org.tizen.common.file.IResource originResource : originResources) {
            this.logger.debug("originResource:" + originResource.getPath());
            if (!this.canPackagingWebResources(originResource, blackList, excludeList, invisibleList)) continue;
            if (useBuiltResources) {
                HashSet builtResources = BuildManager.getBuiltResources((IBuildDependency)BuildManager.getBuildDependency((String)this.project.getName()), (org.tizen.common.file.IResource)originResource);
                if (builtResources == null) {
                    packagingWebResources.add(originResource);
                    continue;
                }
                packagingWebResources.addAll(builtResources);
                continue;
            }
            packagingWebResources.add(originResource);
        }
        if (this.useSystemValueFlag == 1 && this.certsMap.get(this.project) != null && this.certsMap.get(this.project).equals(TRUE_VALUE)) {
            org.tizen.common.file.IResource configResource = ResourceUtil.getResource((String)"config.xml", (org.tizen.common.file.IResource[])packagingWebResources.toArray(new org.tizen.common.file.IResource[0]));
            packagingWebResources.remove(configResource);
            String fileHandlerPath = this.project.getLocation().toOSString();
            StandardFileHandler fh = new StandardFileHandler(fileHandlerPath);
            ByteArrayOutputStream byteOut = null;
            PackageResource resource = null;
            InputStream is = null;
            try {
                is = configResource.getContents();
                ITizenConfigurator configurator = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)this.project, (InputStream)is);
                if (configurator instanceof IMobileConfigurator) {
                    ((IMobileConfigurator)configurator).setTrustAnchorUseSystemCerts(UseSystemCertsType.FALSE);
                }
                byteOut = new ByteArrayOutputStream();
                ConfiguratorFactory.marshalObject((IProject)this.project, (Widget)configurator.getWidget(), (OutputStream)byteOut);
                String path = ".package/" + this.project.getName().toString() + "/" + "config.xml";
                resource = new PackageResource((FileHandler)fh, path, "config.xml");
                resource.setContents(byteOut.toByteArray());
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{is, byteOut});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{is, byteOut});
            packagingWebResources.add((org.tizen.common.file.IResource)resource);
        }
        return packagingWebResources;
    }

    private Collection<org.tizen.common.file.IResource> generateUiFwResources(Collection<org.tizen.common.file.IResource> deltaResources) throws CoreException {
        HashSet<org.tizen.common.file.IResource> packagingWebResources = new HashSet<org.tizen.common.file.IResource>();
        if (deltaResources == null) {
            return packagingWebResources;
        }
        IBuildDependency buildDependency = BuildManager.getBuildDependency((String)this.project.getName());
        IdeBuildProcess bp = new IdeBuildProcess(this.monitor);
        bp.setTask(Messages.SUBTASK_APPLY_UI_FW_OPTION);
        bp.addBuilders(this.generateUiFwBuilders());
        IBuildDependency packageDependency = buildDependency;
        bp.addListener((IBuildListener)new BuildDependencyListener(packageDependency));
        for (org.tizen.common.file.IResource resource : deltaResources) {
            this.handleCancel();
            HashSet tempResources = null;
            try {
                bp.build(new org.tizen.common.file.IResource[]{resource});
                tempResources = BuildManager.getBuiltResources((IBuildDependency)packageDependency, (org.tizen.common.file.IResource)resource);
            }
            catch (BuildException e) {
                throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, e.getMessage()));
            }
            if (tempResources != null) {
                packagingWebResources.addAll(tempResources);
                continue;
            }
            packagingWebResources.add(resource);
        }
        return packagingWebResources;
    }

    private IBuilder[] generateUiFwBuilders() {
        ArrayList<UIFWBuilder> builders = new ArrayList<UIFWBuilder>();
        UIFWBuilder builder = null;
        String outputPath = FileUtil.appendPath((String)this.projectFullPath, (String)".package");
        outputPath = FileUtil.appendPath((String)outputPath, (String)"uifw");
        StandardFileHandler fh = new StandardFileHandler(outputPath);
        if (ProjectUtil.isTizenWebUIFWProject((IProject)this.project)) {
            builder = new UIFWBuilder(true, (FileHandler)fh);
        } else if (ProjectUtil.isTizenCowhideProject((IProject)this.project)) {
            builder = new CowhideBuilder(true, (FileHandler)fh);
        }
        if (builder != null) {
            builder.setUseMin(ProjectUtil.isCheckedUsingTargetLibraryMinVersion((IProject)this.project));
            builders.add(builder);
        }
        return builders.toArray(new IBuilder[0]);
    }

    public boolean canPackagingWebResources(org.tizen.common.file.IResource resource, List<PackageResourceInfo> blackList, List<PackageResourceInfo> excludeList, List<PackageResourceInfo> invisibleList) throws IOException {
        if (!this.filter.accept(resource.getFileHandler().getCurrentWorkingDirectory(), resource.getPath())) {
            return false;
        }
        if (this.contains(resource, blackList) && !this.contains(resource, excludeList)) {
            return false;
        }
        PackageResourceInfo pri = this.getPackageResourceInfo(resource, invisibleList);
        return pri == null || pri.isRequirement();
    }

    private HashSet<org.tizen.common.file.IResource> generateHybridWebResources(Collection<org.tizen.common.file.IResource> resources) throws PackageException, CoreException {
        org.tizen.common.file.IResource configResource;
        HashSet<org.tizen.common.file.IResource> hybridWebResources = new HashSet<org.tizen.common.file.IResource>();
        String webRelativeDest = null;
        for (org.tizen.common.file.IResource packagingResource : resources) {
            if (packagingResource == null) continue;
            PackageResource addingResource = null;
            webRelativeDest = FileUtil.appendPath((String)"res", (String)"wgt");
            if (packagingResource.getPath().startsWith(".trust-anchor")) {
                webRelativeDest = "res";
            }
            String destPath = FileUtil.appendPath((String)webRelativeDest, (String)packagingResource.getPath());
            if (packagingResource instanceof PackageResource) {
                destPath = FileUtil.appendPath((String)webRelativeDest, (String)((PackageResource)packagingResource).getDestination());
                ((PackageResource)packagingResource).setDestination(destPath);
                addingResource = packagingResource;
            } else {
                addingResource = new PackageResource(packagingResource.getFileHandler(), packagingResource.getPath(), destPath);
            }
            hybridWebResources.add((org.tizen.common.file.IResource)addingResource);
        }
        String configFile = "config.xml";
        if (this.useSystemValueFlag == 1 && this.certsMap.get(this.project) != null && this.certsMap.get(this.project).equals(TRUE_VALUE)) {
            configFile = ".package/" + this.project.getName() + "/" + "config.xml";
        }
        if ((configResource = ResourceUtil.getResource((String)configFile, (org.tizen.common.file.IResource[])hybridWebResources.toArray(new org.tizen.common.file.IResource[0]))) != null) {
            try {
                org.tizen.common.file.IResource resource = this.createCoreHybridConfigResource((FileHandler)new StandardFileHandler(String.valueOf(this.project.getLocation().toOSString()) + "/" + ".package"), configResource);
                if (resource != null) {
                    hybridWebResources.add(resource);
                }
            }
            catch (ConfigurationException e) {
                throw new PackageException((Exception)((Object)e), e.getLocalizedMessage());
            }
            catch (CoreException e) {
                throw new PackageException((Exception)((Object)e), e.getLocalizedMessage());
            }
            catch (IOException e) {
                throw new PackageException((Exception)e, e.getLocalizedMessage());
            }
        }
        return hybridWebResources;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private org.tizen.common.file.IResource createCoreHybridConfigResource(FileHandler fh, org.tizen.common.file.IResource configResource) throws ConfigurationException, IOException, CoreException {
        refProjects = ProjectUtil.getReferencedNativeCoreProjects((IProject)this.project);
        if (refProjects == null || refProjects.length <= 0) {
            return null;
        }
        byteOut = null;
        resource = null;
        is = null;
        try {
            is = configResource.getContents();
            configurator = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)this.project, (InputStream)is);
            var11_8 = refProjects;
            var10_9 = refProjects.length;
            var9_10 = 0;
            while (var9_10 < var10_9) {
                block8: {
                    block10: {
                        block9: {
                            refProject = var11_8[var9_10];
                            tProjectType = ProjectUtil.getTizenProjectType((IProject)refProject);
                            if (tProjectType == null || !tProjectType.isCoreProject()) break block8;
                            tnxs = ProjectUtil.getTizenNativeXmlStore((IProject)refProject);
                            if (tnxs == null) break block9;
                            privileges = tnxs.getPrivileges();
                            if (privileges == null) break block10;
                            var16_16 = privileges.iterator();
                            if (true) ** GOTO lbl30
                        }
                        IOUtil.tryClose((Object[])new Object[]{is, byteOut});
                        return null;
                        do {
                            if (this.existPrivilege(configurator, privilege = (String)var16_16.next())) continue;
                            configurator.createPrivilege(privilege);
lbl30:
                            // 3 sources

                        } while (var16_16.hasNext());
                    }
                    if ((features = tnxs.getFeatures()) != null) {
                        for (String feature : features) {
                            if (this.existFeature(configurator, feature)) continue;
                            configurator.setFeature(feature);
                        }
                    }
                }
                ++var9_10;
            }
            byteOut = new ByteArrayOutputStream();
            ConfiguratorFactory.marshalObject((IProject)this.project, (Widget)configurator.getWidget(), (OutputStream)byteOut);
            path = "config.xml";
            resource = new PackageResource(fh, path, path);
            resource.setContents(byteOut.toByteArray());
        }
        catch (Throwable var18_18) {
            IOUtil.tryClose((Object[])new Object[]{is, byteOut});
            throw var18_18;
        }
        IOUtil.tryClose((Object[])new Object[]{is, byteOut});
        return resource;
    }

    private boolean existFeature(ITizenConfigurator configurator, String value) {
        List features = configurator.getFeatures();
        for (Feature feature : features) {
            if (!value.equals(feature.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean existPrivilege(ITizenConfigurator configurator, String privilege) {
        List privileges = configurator.getPrivileges();
        for (Privilege pri : privileges) {
            if (!privilege.equals(pri.getName())) continue;
            return true;
        }
        return false;
    }

    private PackageResourceInfo getPackageResourceInfo(org.tizen.common.file.IResource resource, List<PackageResourceInfo> invisibleList) throws IOException {
        for (PackageResourceInfo pri : invisibleList) {
            String resPath = resource.getPath();
            if (resource instanceof LinkedResource) {
                resPath = ((LinkedResource)resource).getRealRelativePath();
            }
            FileHandler.Type type = (FileHandler.Type)resource.getFileHandler().get(resPath, FileHandler.Attribute.TYPE);
            int resourceType = -1;
            resourceType = FileHandler.Type.DIRECTORY.equals((Object)type) ? 2 : 1;
            if (!PackageConfigUtil.contains((PackageResourceInfo)pri, (String)FileUtil.appendPath((String)this.project.getName(), (String)resource.getPath()), (int)resourceType, (IProject)this.project)) continue;
            return pri;
        }
        return null;
    }

    private boolean contains(org.tizen.common.file.IResource resource, List<PackageResourceInfo> list) throws IOException {
        block4: for (PackageResourceInfo pri : list) {
            switch (pri.getResourceType()) {
                case 1: {
                    if (resource.getFileHandler().get(resource.getPath(), FileHandler.Attribute.TYPE) != FileHandler.Type.FILE || !pri.getName().equals(resource.getPath())) continue block4;
                    return true;
                }
                case 2: {
                    if (resource.getFileHandler().get(resource.getPath(), FileHandler.Attribute.TYPE) != FileHandler.Type.DIRECTORY || !resource.getPath().startsWith(pri.getName())) continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    public Collection<org.tizen.common.file.IResource> getPackagingResources(PackageProcessType type) throws PackageException {
        return this.getPackagingResources(type, null);
    }

    public Collection<org.tizen.common.file.IResource> getPackagingResources(PackageProcessType type, IProject mainProject) throws PackageException {
        this.logger.debug("Get packaging resources.");
        Collection<org.tizen.common.file.IResource> packagingResources = null;
        try {
            packagingResources = this.generatePackagingWebResources(type, mainProject);
            if (ProjectUtil.isHybridApp((IProject)this.project)) {
                this.logger.debug("Get native resources for making hybrid app.");
                packagingResources.addAll(this.getPackagingNativeResources(type));
            }
        }
        catch (CoreException e) {
            throw new PackageException((Exception)((Object)e), e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new PackageException((Exception)e, e.getLocalizedMessage());
        }
        catch (ConfigurationException e) {
            throw new PackageException((Exception)((Object)e), e.getLocalizedMessage());
        }
        return packagingResources;
    }

    private Collection<? extends org.tizen.common.file.IResource> getPackagingNativeResources(PackageProcessType type) throws CoreException, IOException, ConfigurationException, PackageException {
        IProject[] nativeProjects;
        HashSet<org.tizen.common.file.IResource> packagingResources = new HashSet<org.tizen.common.file.IResource>();
        IProject[] iProjectArray = nativeProjects = ProjectUtil.getReferencedNativeProjects((IProject)this.project);
        int n = nativeProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject nativeProject = iProjectArray[n2];
            nativeProject.refreshLocal(2, null);
            HashSet<org.tizen.common.file.IResource> nativeResources = PackageUtil.getNativeResources(type, (ITizenNativeProject)ProjectUtil.getTizenProject((IProject)nativeProject), (FileHandler)new StandardFileHandler(nativeProject.getLocation().toOSString()), EXCLUDE_NATIVE_RESOURCES);
            for (org.tizen.common.file.IResource nativeResource : nativeResources) {
                if (!nativeResource.getPath().startsWith(".trust-anchor")) continue;
                ((PackageResource)nativeResource).setDestination("res" + File.separator + nativeResource.getPath());
            }
            packagingResources.addAll(nativeResources);
            ++n2;
        }
        VirtualFileHandler fh = new VirtualFileHandler();
        fh.setCurrentWorkingDirectory(this.projectFullPath);
        org.tizen.common.file.IResource mergedManifestResource = this.getMergedManifestResource(this.project, (FileHandler)fh);
        if (mergedManifestResource != null) {
            packagingResources.add(mergedManifestResource);
        }
        return packagingResources;
    }

    private void modifyUseSystemCertsToFalse(IProject mainProject) throws CoreException, ConfigurationException, PackageException {
        if (mainProject == null) {
            this.checkUseSystemCertsValueForProject(this.project);
        } else {
            this.checkUseSystemCertsValueForProject(mainProject);
        }
    }

    private void checkUseSystemCertsValueForProject(IProject project) throws CoreException, ConfigurationException, PackageException {
        IProject[] webWidgetProjects;
        IProject companionProject;
        IProject[] refProjects = null;
        if (ProjectUtil.isHybridApp((IProject)project)) {
            refProjects = ProjectUtil.getReferencedNativeCoreProjects((IProject)project);
        }
        if (!this.sameUseSystemCertsValue(project, refProjects, companionProject = ProjectUtil.getCompanionWebProject((IProject)project), webWidgetProjects = ProjectUtil.getReferenceWebWidgetProject((IProject)project))) {
            this.useSystemValueFlag = 1;
        }
    }

    private boolean sameUseSystemCertsValue(IProject project, IProject[] refProjects, IProject companionProject, IProject[] webWidgetProjects) throws CoreException, ConfigurationException, PackageException {
        ITizenConfigurator companionConfig;
        int n;
        int n2;
        IProject[] iProjectArray;
        ITizenConfigurator mainConfig = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)project);
        TrustAnchor ta = null;
        if (mainConfig instanceof IMobileConfigurator && (ta = ((IMobileConfigurator)mainConfig).getTrustAnchor()) != null) {
            this.certsMap.put(project, ta.getUseSystemCerts().toString().toLowerCase());
        }
        if (refProjects != null) {
            iProjectArray = refProjects;
            n2 = refProjects.length;
            n = 0;
            while (n < n2) {
                IProject refProject = iProjectArray[n];
                ITizenNativeXMLStore rootStore = ProjectUtil.getTizenNativeXmlStore((IProject)refProject);
                String trustAnchorValue = rootStore.getUseSystemCertsOfTrustAnchor();
                if (trustAnchorValue != null) {
                    this.certsMap.put(refProject, trustAnchorValue);
                }
                ++n;
            }
        }
        if (companionProject != null && (companionConfig = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)companionProject)) instanceof IMobileConfigurator && (ta = ((IMobileConfigurator)companionConfig).getTrustAnchor()) != null) {
            this.certsMap.put(companionProject, ta.getUseSystemCerts().toString().toLowerCase());
        }
        if (webWidgetProjects != null && !ArrayUtil.isEmpty((Object[])webWidgetProjects)) {
            iProjectArray = webWidgetProjects;
            n2 = webWidgetProjects.length;
            n = 0;
            while (n < n2) {
                IProject webWidgetProject = iProjectArray[n];
                ITizenConfigurator webWidgetConfig = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)webWidgetProject);
                if (webWidgetConfig instanceof IMobileConfigurator && (ta = ((IMobileConfigurator)webWidgetConfig).getTrustAnchor()) != null) {
                    this.certsMap.put(webWidgetProject, ta.getUseSystemCerts().toString().toLowerCase());
                }
                ++n;
            }
        }
        if (this.certsMap.containsValue(TRUE_VALUE) && this.certsMap.containsValue(FALSE_VALUE)) {
            int result = DialogUtil.openQuestionDialog((String)Messages.TRUST_ANCHOR, (String)Messages.TRUST_ANCHOR_VALUE_CONFLICT);
            if (result == 128) {
                throw new PackageException(Messages.PACKAGE_CANCELED);
            }
            if (result == 64) {
                return false;
            }
        }
        return true;
    }

    private org.tizen.common.file.IResource getMergedManifestResource(IProject project, FileHandler fh) throws ConfigurationException, CoreException, IOException {
        org.tizen.common.file.IResource manifestResource = PackageUtil.makeNativeManifestFile(project, fh);
        return manifestResource;
    }

    public void setDeltaResources(Collection<org.tizen.common.file.IResource> deltaResources) {
        this.deltaFileResources.clear();
        for (org.tizen.common.file.IResource resource : deltaResources) {
            if (!this.canVisit(resource.getFileHandler().getCurrentWorkingDirectory(), resource.getPath())) continue;
            this.deltaFileResources.add(resource);
        }
    }

    public Collection<org.tizen.common.file.IResource> getRdsResources() {
        return this.getDeltaResources(this.getDeltaResources(), this.getDeltaResources(), false);
    }

    public Collection<? extends org.tizen.common.file.IResource> getUnitTestResources() throws IOException {
        org.tizen.common.file.IResource resource = ResourceUtil.convertResource((IResource)this.project.findMember("webUnitTest"));
        Collection unitTestResources = ResourceUtil.getChildren((org.tizen.common.file.IResource)resource, (boolean)true);
        return unitTestResources;
    }
}

