/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.util;

import org.w3c.css.parser.CssSelectors;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.Messages;

public class Warning
implements Comparable<Warning> {
    String sourceFile;
    int hashSource = 0;
    int level = 0;
    int line = 0;
    CssSelectors selector;
    String warningMessage;

    public Warning(String sourceFile, int line, String warningMessage, int level, String[] messages, ApplContext ac) {
        this.sourceFile = sourceFile;
        this.hashSource = sourceFile.hashCode() % 100;
        this.line = line;
        this.warningMessage = this.warn(warningMessage, messages, ac);
        this.level = this.getLevel(warningMessage, level, ac);
    }

    public Warning(String sourceFile, int line, String warningMessage, int level, ApplContext ac) {
        this(sourceFile, line, warningMessage, level, null, ac);
    }

    public Warning(CssProperty property, String warningMessage, int level, String message1, String message2, ApplContext ac, int i) {
        this.sourceFile = property.getSourceFile();
        if (this.sourceFile != null) {
            this.hashSource = this.sourceFile.hashCode() % 100;
        }
        this.warningMessage = this.warn(warningMessage, new String[]{message1, message2}, ac);
        this.level = this.getLevel(warningMessage, level, ac);
        this.line = property.getLine();
    }

    public Warning(CssProperty property, String warningMessage, int level, String[] messages, ApplContext ac) {
        this.sourceFile = property.getSourceFile();
        if (this.sourceFile != null) {
            this.hashSource = this.sourceFile.hashCode() % 100;
        }
        this.warningMessage = this.warn(warningMessage, messages, ac);
        this.level = this.getLevel(warningMessage, level, ac);
        this.line = property.getLine();
    }

    public Warning(CssProperty property, String warningMessage, int level, ApplContext ac) {
        this(property, warningMessage, level, new String[]{property.getPropertyName()}, ac);
        this.selector = property.getSelectors();
    }

    public Warning(CssProperty property, String warningMessage, int level, CssProperty property2, ApplContext ac) {
        this(property, warningMessage, level, new String[]{property.getPropertyName(), property2.getPropertyName()}, ac);
        this.selector = property.getSelectors();
    }

    @Override
    public int compareTo(Warning w) {
        int o;
        int wo = w.getInternalOrder();
        if (wo == (o = this.getInternalOrder())) {
            return 0;
        }
        if (o < wo) {
            return -1;
        }
        return 1;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public String getSourceFileEscaped() {
        return Messages.escapeString(this.sourceFile);
    }

    public int getLine() {
        return this.line;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public String getWarningMessageEscaped() {
        return Messages.escapeString(this.warningMessage);
    }

    public int getLevel() {
        return this.level;
    }

    public CssSelectors getContext() {
        return this.selector;
    }

    public int getInternalOrder() {
        return 100000 * this.hashSource + 10 * this.line + this.level;
    }

    public void dump() {
        System.err.println(this.getSourceFile());
        System.err.println(this.getLine());
        System.err.println(this.getWarningMessage());
        System.err.println(this.getLevel());
    }

    private String warn(String warning, String[] args, ApplContext ac) {
        String str = ac.getMsg().getWarningString(warning);
        if (str == null) {
            return "can't find the warning message for " + warning;
        }
        if (args != null) {
            StringBuilder sb = new StringBuilder();
            int idx = 0;
            String[] msg_parts = str.split("%s", -1);
            sb.append(msg_parts[0]);
            for (int i = 1; i < msg_parts.length; ++i) {
                if (idx < args.length) {
                    sb.append(args[idx++]);
                } else {
                    System.err.println("*** WARNING ISSUE: " + warning);
                    System.err.println("*** WARNING ISSUE: " + ac.getMsg().getWarningString(warning));
                    System.err.println("*** WARNING ISSUE: got " + args.length + " args entries");
                }
                sb.append(msg_parts[i]);
            }
            return sb.toString();
        }
        return str;
    }

    private int getLevel(String warning, int defaultLevel, ApplContext ac) {
        String str = ac.getMsg().getWarningLevelString(warning);
        if (str == null) {
            return defaultLevel;
        }
        try {
            int level = Integer.parseInt(str);
            if (level > 9 || level < 0) {
                return defaultLevel;
            }
            return level;
        }
        catch (Exception e) {
            return defaultLevel;
        }
    }
}

