/*
 * Decompiled with CFR 0.152.
 */
package json.outline.elements;

import java.util.LinkedList;
import java.util.List;
import json.outline.elements.JsonElement;
import json.outline.elements.JsonParent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class JsonArray
extends JsonElement
implements JsonParent {
    private static final String iconPath = "/icons/JsonArray.png";
    private String key;
    private List<JsonElement> jsonElements = new LinkedList<JsonElement>();

    public JsonArray(JsonParent parent) {
        super(parent);
    }

    public JsonArray(JsonParent parent, String key) {
        super(parent);
        this.key = key;
    }

    @Override
    public List<JsonElement> getChildren() {
        return this.jsonElements;
    }

    @Override
    public void removeFromParent() {
        this.getParent().removeEntry(this);
    }

    @Override
    public boolean hasChildren() {
        return !this.jsonElements.isEmpty();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public List<JsonElement> getJsonElements() {
        return this.jsonElements;
    }

    public void setJsonElements(List<JsonElement> jsonElements) {
        this.jsonElements = jsonElements;
    }

    @Override
    public void removeEntry(JsonElement jsonElement) {
        this.jsonElements.remove(jsonElement);
    }

    @Override
    public void addChild(JsonElement jsonElement) {
        this.jsonElements.add(jsonElement);
    }

    public String toString() {
        return this.key;
    }

    @Override
    public Image getImage() {
        return this.createMyImage(iconPath);
    }

    @Override
    public String getForegroundColor() {
        return null;
    }

    @Override
    public StyledString getStyledString() {
        StyledString styledString = new StyledString();
        StyledString.Styler style1 = StyledString.createColorRegistryStyler((String)"GREEN", (String)"WHITE");
        styledString.append(this.key, style1);
        return styledString;
    }
}

