/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.javascript;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dnd.IDragAndDropService;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.ui.text.JavaScriptSourceViewerConfiguration;
import org.eclipse.wst.jsdt.ui.text.JavaScriptTextTools;
import org.eclipse.wst.sse.ui.internal.ReadOnlyAwareDropTargetAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.web.editor.javascript.JavaScriptSourceViewerConfigurationForHyperlink;
import org.tizen.web.editor.javascript.decorator.JavascriptFileDecorator;
import org.tizen.web.jshint.handlers.JsValidationHandler;
import org.tizen.web.privilege.Activator;
import org.tizen.web.privilege.core.PrivilegeChecker;

public class JavaScriptEditor
extends CompilationUnitEditor {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String EDITOR_ID = "org.tizen.web.editor.javascript.JavascriptEditor";
    public static final String EDITOR_CONTEXT = "org.tizen.web.editor.javascript.JavascriptEditor.context";
    public static final String RULER_CONTEXT = "org.tizen.web.editor.javascript.JavascriptEditor.ruler";
    private final IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            JsValidationHandler.runValidation((IEditorPart)JavaScriptEditor.this);
        }
    };
    private Composite parent;
    private ReadOnlyAwareDropTargetAdapter fDropAdapter;

    public JavaScriptEditor() {
        org.tizen.web.jshint.Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.listener);
        this.setEditorContextMenuId(EDITOR_CONTEXT);
        this.setRulerContextMenuId(RULER_CONTEXT);
    }

    protected JavaScriptSourceViewerConfiguration createJavaSourceViewerConfiguration() {
        JavaScriptTextTools textTools = JavaScriptPlugin.getDefault().getJavaTextTools();
        return new JavaScriptSourceViewerConfigurationForHyperlink(textTools.getColorManager(), this.getPreferenceStore(), (ITextEditor)this, "___java_partitioning");
    }

    protected void setPreferenceStore(IPreferenceStore store) {
        super.setPreferenceStore(store);
        if (this.getSourceViewerConfiguration() instanceof JavaScriptSourceViewerConfiguration) {
            JavaScriptTextTools textTools = JavaScriptPlugin.getDefault().getJavaTextTools();
            this.setSourceViewerConfiguration((SourceViewerConfiguration)new JavaScriptSourceViewerConfigurationForHyperlink(textTools.getColorManager(), store, (ITextEditor)this, "___java_partitioning"));
        }
    }

    public void dispose() {
        org.tizen.web.jshint.Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.listener);
        this.fDropAdapter = null;
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        super.createPartControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.tizen.ide.web.javascript_editor_context");
    }

    protected void initializeDragAndDrop(ISourceViewer viewer) {
        super.initializeDragAndDrop(viewer);
        this.initializeDrop(viewer);
    }

    protected void initializeDrop(ISourceViewer viewer) {
        this.fDropAdapter = new ReadOnlyAwareDropTargetAdapter(true){
            private Point fSelection;

            public void dragOver(DropTargetEvent event) {
                event.feedback |= 8;
            }

            public void dragEnter(DropTargetEvent event) {
                super.dragEnter(event);
                this.fSelection = JavaScriptEditor.this.getViewer().getTextWidget().getSelection();
            }

            public void drop(DropTargetEvent event) {
                super.drop(event);
                this.fSelection = null;
            }

            protected boolean doDrop(Transfer transfer, DropTargetEvent event) {
                if (this.fSelection != null) {
                    event.x = this.fSelection.x;
                    event.y = this.fSelection.y;
                }
                return super.doDrop(transfer, event);
            }
        };
        this.fDropAdapter.setTargetEditor((IEditorPart)this);
        this.fDropAdapter.setTargetIDs(new String[]{EDITOR_ID});
        this.fDropAdapter.setTextViewer((ITextViewer)viewer);
        IDragAndDropService dndService = (IDragAndDropService)this.getSite().getService(IDragAndDropService.class);
        dndService.addMergedDropTarget((Control)this.getSourceViewer().getTextWidget(), 3, this.fDropAdapter.getTransfers(), (DropTargetListener)this.fDropAdapter);
    }

    public void setFocus() {
        this.parent.setFocus();
        super.setFocus();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        boolean reconcile = org.tizen.web.jshint.Activator.getDefault().getPreferenceStore().getBoolean("org.tizen.web.jshint.preference.JsValidationPreferencePage.reconcile");
        if (reconcile) {
            JsValidationHandler.runValidation((IEditorPart)this);
        }
        reconcile = Activator.getDefault().getPreferenceStore().getBoolean("org.tizen.web.privilege.preference.PrivilegePreferencePage.reconcile");
        boolean build = Activator.getDefault().getPreferenceStore().getBoolean("org.tizen.web.privilege.preference.PrivilegePreferencePage.build");
        if (build && ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding()) {
            return;
        }
        if (reconcile) {
            PrivilegeChecker privilegeChecker = PrivilegeChecker.getInstance();
            privilegeChecker.runValidation((IEditorPart)this);
        }
    }

    protected void setTitleImage(Image titleImage) {
        if (JavascriptFileDecorator.JAVASCRIPT_FILE_ICON_IMAGE != null) {
            IEditorInput editorInput = this.getEditorInput();
            IFile file = null;
            if (editorInput instanceof IFileEditorInput) {
                file = ((IFileEditorInput)editorInput).getFile();
            }
            if (file != null && file.exists()) {
                try {
                    int markerSeverity = file.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2);
                    switch (markerSeverity) {
                        case 1: {
                            super.setTitleImage(JavascriptFileDecorator.JAVASCRIPT_FILE_ICON_WARNING_IMAGE);
                            break;
                        }
                        case 2: {
                            super.setTitleImage(JavascriptFileDecorator.JAVASCRIPT_FILE_ICON_ERROR_IMAGE);
                            break;
                        }
                        default: {
                            super.setTitleImage(JavascriptFileDecorator.JAVASCRIPT_FILE_ICON_IMAGE);
                            break;
                        }
                    }
                }
                catch (CoreException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            } else {
                super.setTitleImage(titleImage);
            }
        } else {
            super.setTitleImage(titleImage);
        }
    }
}

