/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.privilege.support;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import org.tizen.common.ui.widget.ITextValidator;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.ValidationUtil;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.widl.model.PrivilegeWrapper;

public class PrivilegeNameTextValidator
implements ITextValidator {
    private Collection<String> knownPrivileges = new HashSet<String>();
    private Collection<String> addedPrivileges;

    public PrivilegeNameTextValidator(ITizenConfigurator configurator) {
        for (PrivilegeWrapper privilegeWrapper : configurator.getKnownPrivileges()) {
            this.knownPrivileges.add(privilegeWrapper.getName());
        }
        this.addedPrivileges = new HashSet<String>();
        for (PrivilegeWrapper privilegeWrapper : configurator.getUsedPrivileges()) {
            this.addedPrivileges.add(privilegeWrapper.getName());
        }
    }

    public boolean validate(String privilegeName) {
        if (privilegeName.isEmpty()) {
            return false;
        }
        String errorMsg = this.getErrorMessage(privilegeName);
        return StringUtil.isEmpty((CharSequence)errorMsg);
    }

    public String getErrorMessage(String privilegeName) {
        if (privilegeName.isEmpty()) {
            return "";
        }
        try {
            new URI(privilegeName);
        }
        catch (URISyntaxException uRISyntaxException) {
            return Messages.AddPrivilegeDialog_PrivilegeNameTextInvalid;
        }
        if (!ValidationUtil.checkForIRI((String)privilegeName)) {
            return Messages.AddPrivilegeDialog_PrivilegeNameTextInvalid;
        }
        if (this.knownPrivileges.contains(privilegeName)) {
            return Messages.AddPrivilegeDialog_PrivilegeNameTextConflict;
        }
        if (this.addedPrivileges.contains(privilegeName)) {
            return Messages.AddPrivilegeDialog_PrivilegeNameTextPredefined;
        }
        if (!ValidationUtil.checkForPrivilege((String)privilegeName)) {
            return MessageFormat.format(Messages.Validator_InvalidPrivilegeName, privilegeName);
        }
        return null;
    }
}

