/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.html.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.html.core.internal.document.ElementStyleImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HTMLEditorUtil {
    public static List<ElementStyleImpl> getElementsByGivenName(IDOMDocument document, String tagName) {
        ArrayList<ElementStyleImpl> elements = new ArrayList<ElementStyleImpl>();
        if (tagName == null) {
            return elements;
        }
        NodeList childNodes = document.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node item = childNodes.item(i);
            if (item instanceof ElementStyleImpl) {
                HTMLEditorUtil.getElementsByGivenName(item, elements, tagName);
            }
            ++i;
        }
        return elements;
    }

    private static List<ElementStyleImpl> getElementsByGivenName(Node node, List<ElementStyleImpl> elements, String tagName) {
        NodeList currentItemChildNodes;
        if (tagName.equalsIgnoreCase(node.getNodeName())) {
            elements.add((ElementStyleImpl)node);
        }
        if ((currentItemChildNodes = node.getChildNodes()) != null) {
            int i = 0;
            while (i < currentItemChildNodes.getLength()) {
                Node item = currentItemChildNodes.item(i);
                if (item instanceof ElementStyleImpl) {
                    HTMLEditorUtil.getElementsByGivenName(item, elements, tagName);
                }
                ++i;
            }
        }
        return elements;
    }

    public static String leftTrim(String s) {
        int i = 0;
        while (i < s.length() && Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        return s.substring(i);
    }

    public static String rightTrim(String s) {
        int i = s.length() - 1;
        while (i >= 0 && Character.isWhitespace(s.charAt(i))) {
            --i;
        }
        return s.substring(0, i + 1);
    }
}

