/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.unittest.wizards.provider;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.web.zimlaunch.util.jsconsole.JsLogConsoleFactory;

public class MethodTreeViewerLabelProvider
extends LabelProvider {
    public static Logger logger = LoggerFactory.getLogger(JsLogConsoleFactory.class);

    public String getText(Object element) {
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            StringBuilder label = new StringBuilder(member.getElementName());
            if (member instanceof IFunction) {
                IFunction function = (IFunction)member;
                try {
                    String[] parameterNames = function.getParameterNames();
                    label.append("(");
                    int i = 0;
                    while (i < parameterNames.length) {
                        label.append(parameterNames[i]);
                        if (i < parameterNames.length - 2) {
                            label.append(", ");
                        }
                        ++i;
                    }
                    label.append(")");
                }
                catch (JavaScriptModelException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            return label.toString();
        }
        return null;
    }
}

