/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.util.jsconsole;

import java.io.File;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.TextConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ui.view.console.ConsoleManager2;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.StringUtil;

public class JsLogDocumentListener
implements IDocumentListener {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConsoleManager2 consoleManager;
    private IProject project;
    private static Pattern logPattern = Pattern.compile("(.*?\\S)(\\s*\\(\\s*)(\\d+)(\\s*\\) :.*\\s*)");

    public JsLogDocumentListener(ConsoleManager2 consoleManager) {
        this.consoleManager = consoleManager;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void setProject(IProject project) {
        if (project != null) {
            this.project = project;
        }
    }

    public void documentChanged(DocumentEvent event) {
        this.logger.trace("Changed message: {}", (Object)event.getText());
        if (this.project != null) {
            String[] changedMessages;
            String[] stringArray = changedMessages = StringUtil.split((String)event.getText(), (String)"\n");
            int n = changedMessages.length;
            int n2 = 0;
            while (n2 < n) {
                String changedMessage = stringArray[n2];
                this.addHyperLink(this.project, event.getDocument(), changedMessage);
                ++n2;
            }
        }
    }

    private void addHyperLink(IProject project, IDocument document, String message) {
        if (document.getLength() == 0 && document.getNumberOfLines() == 0) {
            this.logger.debug("Console's character count: {}", (Object)document.getLength());
            this.logger.debug("Console's line count: {}", (Object)document.getNumberOfLines());
            return;
        }
        Object[] messages = StringUtil.split((String)message, (Pattern)logPattern);
        if (ArrayUtil.isEmpty((Object[])messages) || messages.length != 4) {
            this.logger.debug("Could not split message");
            return;
        }
        Object logSrc = messages[0];
        Object bracketString = messages[1];
        Object logLine = messages[2];
        try {
            IFile srcFile = project.getFile((String)logSrc);
            File file = new File(srcFile.getLocationURI());
            FileLink hyperlink = new FileLink(srcFile, "org.tizen.web.editor.javascript.JavascriptEditor", -1, (int)file.length(), Integer.parseInt((String)logLine));
            int line = this.computeNumberOfLines(document, message);
            if (line < 0) {
                this.logger.debug("Could not find matched string");
                return;
            }
            int offset = document.getLineOffset(line) + ((String)logSrc).length() + ((String)bracketString).length();
            this.logger.trace("link line: {}, offset: {}", (Object)line, (Object)offset);
            ((TextConsole)this.consoleManager.getConsole()).addHyperlink((IHyperlink)hyperlink, offset, ((String)logLine).length());
        }
        catch (BadLocationException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private int computeNumberOfLines(IDocument doc, String msg) throws BadLocationException {
        int line = -1;
        int i = 0;
        while (i < doc.getNumberOfLines()) {
            String lineMsg = doc.get(doc.getLineOffset(i), doc.getLineLength(i));
            if (lineMsg.contains(msg)) {
                line = i;
            }
            ++i;
        }
        return line;
    }
}

