/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.javascript.hyperlink;

import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.text.JavaWordFinder;
import org.tizen.web.editor.javascript.JavaScriptEditorConstants;
import org.tizen.web.editor.javascript.hyperlink.StringLiteralHyperLink;
import org.tizen.web.editor.javascript.hyperlink.StringLiteralHyperLinkOpenInformation;

public class StringLiteralHyperlinkDetector
extends AbstractHyperlinkDetector
implements JavaScriptEditorConstants {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (region == null || !(textEditor instanceof JavaEditor)) {
            return null;
        }
        int offset = region.getOffset();
        IJavaScriptElement input = EditorUtility.getEditorInputJavaElement((IEditorPart)textEditor, (boolean)false);
        if (input == null) {
            return null;
        }
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        IRegion wordRegion = JavaWordFinder.findWord((IDocument)document, (int)offset);
        if (wordRegion == null) {
            return null;
        }
        StringLiteralHyperLinkOpenInformation linkInformation = null;
        JavaScriptUnit ast = JavaScriptPlugin.getDefault().getASTProvider().getAST(input, ASTProvider.WAIT_NO, null);
        if (ast != null) {
            HyperlinkCandidateVisitor visitor;
            block7: {
                int start = wordRegion.getOffset();
                int end = start + wordRegion.getLength();
                visitor = new HyperlinkCandidateVisitor(start, end);
                try {
                    ast.accept((ASTVisitor)visitor);
                }
                catch (HyperlinkCandidateVisitor.HyperlinkCandidateFoundException e) {
                    linkInformation = e.getStringLiteralHyperLinkOpenInformation();
                    if (linkInformation.getType() != JavaScriptEditorConstants.AdvanceStringLiteralHyperlinkType.NONE) break block7;
                    return null;
                }
            }
            if (visitor.fFoundCandidate) {
                return new IHyperlink[]{new StringLiteralHyperLink(textEditor, wordRegion, linkInformation, ((IFileEditorInput)textEditor.getEditorInput()).getFile())};
            }
        }
        return null;
    }

    private static class HyperlinkCandidateVisitor
    extends ASTVisitor {
        protected boolean fFoundCandidate = false;
        private int fStartOffset;
        private int fEndOffset;
        private JavaScriptEditorConstants.AdvanceStringLiteralHyperlinkType type;

        protected HyperlinkCandidateVisitor(int start, int end) {
            this.fStartOffset = start;
            this.fEndOffset = end;
        }

        public void preVisit(ASTNode node) {
            switch (node.getNodeType()) {
                case 45: {
                    this.isCandidate(node);
                }
            }
        }

        private void isCandidate(ASTNode n) {
            if (!this.fFoundCandidate) {
                int start = n.getStartPosition();
                int end = start + n.getLength();
                ASTNode parent = n.getParent();
                if (parent != null && parent instanceof FunctionInvocation) {
                    boolean validLinkPosition = this.isValidLinkPosition(parent);
                    if (validLinkPosition && start == this.fStartOffset - 1 && end == this.fEndOffset + 1) {
                        this.fFoundCandidate = true;
                        throw new HyperlinkCandidateFoundException(this.type, ((StringLiteral)n).getLiteralValue());
                    }
                    if (validLinkPosition && n instanceof StringLiteral) {
                        String escapedValue = ((StringLiteral)n).getEscapedValue();
                        if (escapedValue != null && (escapedValue.startsWith("'") || escapedValue.startsWith("\""))) {
                            escapedValue = escapedValue.substring(1, escapedValue.length() - 1);
                        }
                        if (escapedValue != null && (escapedValue.startsWith("#") || escapedValue.startsWith(".")) && start == this.fStartOffset - 2 && end == this.fEndOffset + 1) {
                            this.fFoundCandidate = true;
                            throw new HyperlinkCandidateFoundException(this.type, ((StringLiteral)n).getLiteralValue());
                        }
                    }
                }
            }
        }

        private boolean isValidLinkPosition(ASTNode parent) {
            boolean isValid = false;
            List arguments = ((FunctionInvocation)parent).arguments();
            if (arguments != null && arguments.size() > 0) {
                int i = 0;
                while (i < arguments.size()) {
                    SimpleName simpleName;
                    ASTNode argument = (ASTNode)arguments.get(i);
                    int startPosition = argument.getStartPosition();
                    int length = argument.getLength();
                    if (this.fStartOffset - 1 >= startPosition && this.fEndOffset + 1 <= startPosition + length && i == 0 && (simpleName = ((FunctionInvocation)parent).getName()) != null) {
                        String identifier = simpleName.getIdentifier();
                        if (identifier != null && identifier.equals("getElementById")) {
                            isValid = true;
                            this.type = JavaScriptEditorConstants.AdvanceStringLiteralHyperlinkType.ID;
                        } else if (identifier != null && identifier.equals("getElementsByName")) {
                            isValid = true;
                            this.type = JavaScriptEditorConstants.AdvanceStringLiteralHyperlinkType.NAME;
                        } else if (identifier != null && identifier.equals("getElementsByTagName")) {
                            isValid = true;
                            this.type = JavaScriptEditorConstants.AdvanceStringLiteralHyperlinkType.TAG;
                        } else if (identifier != null && (identifier.equals("querySelector") || identifier.equals("$"))) {
                            isValid = true;
                            this.type = JavaScriptEditorConstants.AdvanceStringLiteralHyperlinkType.QUERY_SELECTOR;
                        } else {
                            this.type = JavaScriptEditorConstants.AdvanceStringLiteralHyperlinkType.NONE;
                        }
                    }
                    ++i;
                }
            }
            return isValid;
        }

        private static class HyperlinkCandidateFoundException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;
            private StringLiteralHyperLinkOpenInformation linkInformation = null;

            HyperlinkCandidateFoundException(JavaScriptEditorConstants.AdvanceStringLiteralHyperlinkType type, String linkText) {
                this.linkInformation = new StringLiteralHyperLinkOpenInformation(type, linkText);
            }

            public StringLiteralHyperLinkOpenInformation getStringLiteralHyperLinkOpenInformation() {
                return this.linkInformation;
            }
        }
    }
}

