/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.dynamicbox.support;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.tizen.web.config.schema.model.AppWidget;
import org.tizen.web.config.schema.model.DataBoolean;
import org.tizen.web.editor.configuration.IMobileConfigurator;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.tizen.dynamicbox.support.AddDynamicBoxPage;

public class AddDynamicBoxWizard
extends Wizard {
    private IProject project;
    private ITizenConfigurator configurator;
    private AppWidget dynamicbox;
    private AddDynamicBoxPage page;

    public AddDynamicBoxWizard(ITizenConfigurator configurator) {
        this.configurator = configurator;
        this.project = configurator.getProject();
        this.dynamicbox = null;
        this.setWindowTitle(Messages.AddDynamicBoxWizard_Title);
    }

    public AddDynamicBoxWizard(ITizenConfigurator configurator, AppWidget dynamicbox) {
        this.configurator = configurator;
        this.project = configurator.getProject();
        this.dynamicbox = dynamicbox;
        this.setWindowTitle(Messages.AddDynamicBoxWizard_Title);
    }

    public void addPages() {
        this.page = this.dynamicbox == null ? new AddDynamicBoxPage(Messages.AddDynamicBoxWizard_Title, this.configurator) : new AddDynamicBoxPage(Messages.AddDynamicBoxWizard_Title, this.configurator, this.dynamicbox);
        this.page.setTitle(MessageFormat.format(Messages.AddDynamicBoxWizard_PageTitle, this.project.getName()));
        this.page.setDescription(Messages.AddDynamicBoxWizard_PageDescription);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        AppWidget dynamicbox = this.page.getDynamicBox();
        if (dynamicbox != null) {
            if (this.dynamicbox == null) {
                this.configurator.addElement(dynamicbox);
            } else {
                this.configurator.removeElement(this.dynamicbox);
                this.configurator.addElement(dynamicbox);
            }
            if (dynamicbox.getPrimary() == DataBoolean.TRUE && this.configurator instanceof IMobileConfigurator) {
                for (AppWidget configDynamicBox : ((IMobileConfigurator)this.configurator).getDynamicBoxes()) {
                    if (configDynamicBox == dynamicbox) continue;
                    configDynamicBox.setPrimary(DataBoolean.FALSE);
                }
            }
        }
        return true;
    }
}

