/*
 * Decompiled with CFR 0.152.
 */
package json.text;

import java.util.ArrayList;
import json.editors.JsonTextEditor;
import json.text.JsonReconcilerParserException;
import json.util.JsonCharUtility;
import json.util.reader.JsonDocReader;
import json.util.reader.JsonReader;
import json.util.reader.JsonReaderException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.swt.widgets.Display;

public class JsonReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private JsonTextEditor textEditor;
    private IDocument fDocument;
    private JsonReader parser;
    protected final ArrayList<Position> fPositions = new ArrayList();

    public void reconcile(IRegion partition) {
        this.initialReconcile();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.initialReconcile();
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }

    public void initialReconcile() {
        this.parser = new JsonDocReader(this.fDocument);
        this.parse();
    }

    public void parse() {
        block5: {
            this.fPositions.clear();
            try {
                char current = this.parser.getNextClean();
                if (current == '{') {
                    this.doJsonObject("", this.parser.getPosition());
                    break block5;
                }
                if (current == '[') {
                    this.doJsonArray("", this.parser.getPosition());
                    break block5;
                }
                throw new JsonReconcilerParserException();
            }
            catch (Exception exception) {}
        }
        if (this.textEditor != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    JsonReconcilingStrategy.this.textEditor.updateFoldingStructure(JsonReconcilingStrategy.this.fPositions);
                }
            });
        }
    }

    private void doJsonObject(String key, int startPos) throws JsonReaderException, JsonReconcilerParserException, BadLocationException, BadPositionCategoryException {
        char ch;
        Position position = new Position(startPos);
        this.fPositions.add(position);
        do {
            if ((ch = this.parser.getNextClean()) == '}') {
                this.parser.getNextClean();
                break;
            }
            if (ch != '\"') {
                throw new JsonReconcilerParserException();
            }
            int start = this.parser.getPosition();
            String attributeKey = this.doJsonKey();
            ch = this.parser.getNextClean();
            if (ch != ':') {
                throw new JsonReconcilerParserException();
            }
            ch = this.parser.getNextClean();
            if (ch == '{') {
                this.doJsonObject(attributeKey, start);
            } else if (ch == '[') {
                this.doJsonArray(attributeKey, start);
            } else if (ch == 'n') {
                this.doJsonNull(attributeKey, start);
            } else if (ch == '\"') {
                this.doJsonValue(attributeKey, start);
            } else if (ch == 't') {
                this.doJsonTrueValue(attributeKey, start);
            } else if (ch == 'f') {
                this.doJsonFalseValue(attributeKey, start);
            } else if (Character.isDigit(ch) || ch == '-') {
                this.doJsonNumber(attributeKey, start);
            } else {
                throw new JsonReconcilerParserException();
            }
            ch = this.parser.getCurrent();
            if (ch == ',') continue;
            if (ch == '}') {
                position.setLength(this.parser.getPosition() - startPos);
                this.parser.getNextClean();
                break;
            }
            throw new JsonReconcilerParserException();
        } while (ch != '\uffff');
    }

    private void doJsonArray(String key, int startPos) throws JsonReaderException, JsonReconcilerParserException, BadLocationException, BadPositionCategoryException {
        char ch;
        Position position = new Position(startPos);
        this.fPositions.add(position);
        do {
            ch = this.parser.getNextClean();
            int start = this.parser.getPosition();
            if (ch == '{') {
                this.doJsonObject("", start);
            } else if (ch == '[') {
                this.doJsonArray("", start);
            } else if (ch == 'n') {
                this.doJsonNull("", start);
            } else if (ch == '\"') {
                this.doJsonValue("", start);
            } else if (ch == 't') {
                this.doJsonTrueValue("", start);
            } else if (ch == 'f') {
                this.doJsonFalseValue("", start);
            } else if (Character.isDigit(ch) || ch == '-') {
                this.doJsonNumber("", start);
            } else {
                if (ch == ']') {
                    position.setLength(this.parser.getPosition() - startPos);
                    this.parser.getNextClean();
                    break;
                }
                throw new JsonReconcilerParserException();
            }
            ch = this.parser.getCurrent();
            if (ch == ',') continue;
            if (ch == ']') {
                position.setLength(this.parser.getPosition() - startPos);
                this.parser.getNextClean();
                break;
            }
            throw new JsonReconcilerParserException();
        } while (ch != '\uffff');
    }

    private void doJsonTrueValue(String key, int start) throws JsonReaderException, JsonReconcilerParserException {
        char ch = this.parser.getNextChar();
        if (ch != 'r') {
            throw new JsonReconcilerParserException();
        }
        ch = this.parser.getNextChar();
        if (ch != 'u') {
            throw new JsonReconcilerParserException();
        }
        ch = this.parser.getNextChar();
        if (ch != 'e') {
            throw new JsonReconcilerParserException();
        }
        ch = this.parser.getNextClean();
        if (JsonCharUtility.isNotClosed(ch)) {
            throw new JsonReconcilerParserException();
        }
    }

    private void doJsonFalseValue(String key, int start) throws JsonReaderException, JsonReconcilerParserException {
        char ch = this.parser.getNextChar();
        if (ch != 'a') {
            throw new JsonReconcilerParserException();
        }
        ch = this.parser.getNextChar();
        if (ch != 'l') {
            throw new JsonReconcilerParserException();
        }
        ch = this.parser.getNextChar();
        if (ch != 's') {
            throw new JsonReconcilerParserException();
        }
        ch = this.parser.getNextChar();
        if (ch != 'e') {
            throw new JsonReconcilerParserException();
        }
        ch = this.parser.getNextClean();
        if (JsonCharUtility.isNotClosed(ch)) {
            throw new JsonReconcilerParserException();
        }
    }

    private void doJsonNull(String key, int start) throws JsonReaderException, JsonReconcilerParserException {
        char ch = this.parser.getNextChar();
        if (ch != 'u') {
            throw new JsonReconcilerParserException();
        }
        ch = this.parser.getNextChar();
        if (ch != 'l') {
            throw new JsonReconcilerParserException();
        }
        ch = this.parser.getNextChar();
        if (ch != 'l') {
            throw new JsonReconcilerParserException();
        }
        ch = this.parser.getNextClean();
        if (JsonCharUtility.isNotClosed(ch)) {
            throw new JsonReconcilerParserException();
        }
    }

    private void doJsonValue(String key, int start) throws JsonReaderException, JsonReconcilerParserException {
        char ch;
        do {
            if ((ch = this.parser.getNextChar()) != '\"' || this.parser.getPrevious() == '\\') continue;
            ch = this.parser.getNextClean();
            break;
        } while (ch != '\uffff');
    }

    private void doJsonNumber(String key, int start) throws JsonReaderException, JsonReconcilerParserException {
        char ch;
        boolean decimalPointSet = false;
        do {
            if (Character.isDigit(ch = this.parser.getNextChar())) continue;
            if (!decimalPointSet && ch == '.') {
                decimalPointSet = true;
                continue;
            }
            if (JsonCharUtility.isClosed(ch)) break;
            if (JsonCharUtility.isNotWhiteSpace(ch)) {
                throw new JsonReconcilerParserException();
            }
            ch = this.parser.getNextClean();
            if (!JsonCharUtility.isNotClosed(ch)) break;
            throw new JsonReconcilerParserException();
        } while (ch != '\uffff');
    }

    private String doJsonKey() throws JsonReaderException, JsonReconcilerParserException {
        char ch;
        StringBuilder keyBuilder = new StringBuilder();
        do {
            if ((ch = this.parser.getNextChar()) == '\uffff') {
                throw new JsonReconcilerParserException();
            }
            if (ch == '\"' && this.parser.getPrevious() != '\\') break;
            keyBuilder.append(ch);
        } while (ch != '\uffff');
        return keyBuilder.toString();
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public JsonTextEditor getTextEditor() {
        return this.textEditor;
    }

    public void setTextEditor(JsonTextEditor textEditor) {
        this.textEditor = textEditor;
    }
}

