/*
 * Decompiled with CFR 0.152.
 */
package org.eclipselabs.jsdt.jquery.api;

import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipselabs.jsdt.jquery.api.JQueryApiPlugin;
import org.eclipselabs.jsdt.jquery.api.Version;

public class SimpleVersion
implements Version {
    private final int major;
    private final int minor;

    SimpleVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    private int getMajor() {
        return this.major;
    }

    private int getMinor() {
        return this.minor;
    }

    @Override
    public int compareTo(Version other) {
        if (other instanceof SimpleVersion) {
            SimpleVersion otherVersion = (SimpleVersion)other;
            int majorDiff = this.major - otherVersion.major;
            if (majorDiff != 0) {
                return majorDiff;
            }
            return this.minor - otherVersion.minor;
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return String.valueOf(this.getMajor()) + "." + this.getMinor();
    }

    public static boolean isVersionString(String s) {
        return s != null && s.length() >= 3 && (s.charAt(0) == '1' || s.charAt(0) == '2') && s.charAt(1) == '.';
    }

    public static Version fromString(String s) {
        Version version;
        String versionString = s;
        if (versionString.length() > 3) {
            versionString = versionString.substring(0, 3);
        }
        if ((version = JQueryApiPlugin.ALL_VERSIONS_MAP.get(versionString)) == null) {
            throw new AssertionFailedException("not version found for: " + s);
        }
        return version;
    }
}

