// RUN: %clang_cc1 -analyze -analyzer-checker=core,osx.cocoa.RetainCount -fblocks -verify %s
// RUN: %clang_cc1 -analyze -analyzer-checker=core,osx.cocoa.RetainCount -fblocks -analyzer-output=plist-multi-file -analyzer-config path-diagnostics-alternate=false %s -o %t
// RUN: FileCheck --input-file=%t %s
@class NSString;
typedef long NSInteger;
typedef unsigned char BOOL;
@interface NSObject {}
+(id)alloc;
-(id)init;
-(id)autorelease;
-(id)copy;
-(id)retain;
@end
@interface NSNumber : NSObject
+ (NSNumber *)numberWithInteger:(NSInteger)value __attribute__((availability(ios,introduced=2.0)));
@end
NSInteger *inoutIntegerValueGlobal;
NSInteger *inoutIntegerValueGlobal2;
NSString *traitNameGlobal;
static BOOL cond;

static inline void reallyPerformAction(void (^integerHandler)(NSInteger *inoutIntegerValue, NSString *traitName)) {
  integerHandler(inoutIntegerValueGlobal, traitNameGlobal); // expected-warning {{Potential leak of an object}}
  integerHandler(inoutIntegerValueGlobal2,traitNameGlobal);
}

static inline BOOL performAction(NSNumber *(^action)(NSNumber *traitValue)) {
  __attribute__((__blocks__(byref))) BOOL didFindTrait = 0;
  reallyPerformAction(^(NSInteger *inoutIntegerValue,NSString *traitName) {

    if (cond) {

      NSNumber *traitValue = @(*inoutIntegerValue);

      NSNumber *newTraitValue = action(traitValue);

      if (traitValue != newTraitValue) {
        *inoutIntegerValue = newTraitValue ? *inoutIntegerValue : *inoutIntegerValue;
      }
      didFindTrait = 1;
    }

  });
  return didFindTrait;
}

void runTest() {
  __attribute__((__blocks__(byref))) NSNumber *builtinResult = ((NSNumber *)0);
  BOOL wasBuiltinTrait = performAction(^(NSNumber *traitValue) {
    builtinResult = [traitValue retain];

    return traitValue;
  });
  if (wasBuiltinTrait) {
    [builtinResult autorelease];
    return;
  } else {
    return;
  }
}

// CHECK: <key>diagnostics</key>
// CHECK: <array>
// CHECK:  <dict>
// CHECK:   <key>path</key>
// CHECK:   <array>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>control</string>
// CHECK:     <key>edges</key>
// CHECK:      <array>
// CHECK:       <dict>
// CHECK:        <key>start</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>48</integer>
// CHECK:           <key>col</key><integer>3</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>48</integer>
// CHECK:           <key>col</key><integer>15</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:        <key>end</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>49</integer>
// CHECK:           <key>col</key><integer>26</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>49</integer>
// CHECK:           <key>col</key><integer>38</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:       </dict>
// CHECK:      </array>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>event</string>
// CHECK:     <key>location</key>
// CHECK:     <dict>
// CHECK:      <key>line</key><integer>49</integer>
// CHECK:      <key>col</key><integer>26</integer>
// CHECK:      <key>file</key><integer>0</integer>
// CHECK:     </dict>
// CHECK:     <key>ranges</key>
// CHECK:     <array>
// CHECK:       <array>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>49</integer>
// CHECK:         <key>col</key><integer>26</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>53</integer>
// CHECK:         <key>col</key><integer>4</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:       </array>
// CHECK:     </array>
// CHECK:     <key>depth</key><integer>0</integer>
// CHECK:     <key>extended_message</key>
// CHECK:     <string>Calling &apos;performAction&apos;</string>
// CHECK:     <key>message</key>
// CHECK:     <string>Calling &apos;performAction&apos;</string>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>event</string>
// CHECK:     <key>location</key>
// CHECK:     <dict>
// CHECK:      <key>line</key><integer>27</integer>
// CHECK:      <key>col</key><integer>1</integer>
// CHECK:      <key>file</key><integer>0</integer>
// CHECK:     </dict>
// CHECK:     <key>depth</key><integer>1</integer>
// CHECK:     <key>extended_message</key>
// CHECK:     <string>Entered call from &apos;runTest&apos;</string>
// CHECK:     <key>message</key>
// CHECK:     <string>Entered call from &apos;runTest&apos;</string>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>control</string>
// CHECK:     <key>edges</key>
// CHECK:      <array>
// CHECK:       <dict>
// CHECK:        <key>start</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>27</integer>
// CHECK:           <key>col</key><integer>1</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>27</integer>
// CHECK:           <key>col</key><integer>6</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:        <key>end</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>28</integer>
// CHECK:           <key>col</key><integer>3</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>28</integer>
// CHECK:           <key>col</key><integer>15</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:       </dict>
// CHECK:      </array>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>control</string>
// CHECK:     <key>edges</key>
// CHECK:      <array>
// CHECK:       <dict>
// CHECK:        <key>start</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>28</integer>
// CHECK:           <key>col</key><integer>3</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>28</integer>
// CHECK:           <key>col</key><integer>15</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:        <key>end</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>29</integer>
// CHECK:           <key>col</key><integer>3</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>29</integer>
// CHECK:           <key>col</key><integer>21</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:       </dict>
// CHECK:      </array>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>event</string>
// CHECK:     <key>location</key>
// CHECK:     <dict>
// CHECK:      <key>line</key><integer>29</integer>
// CHECK:      <key>col</key><integer>3</integer>
// CHECK:      <key>file</key><integer>0</integer>
// CHECK:     </dict>
// CHECK:     <key>ranges</key>
// CHECK:     <array>
// CHECK:       <array>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>29</integer>
// CHECK:         <key>col</key><integer>3</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>43</integer>
// CHECK:         <key>col</key><integer>4</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:       </array>
// CHECK:     </array>
// CHECK:     <key>depth</key><integer>1</integer>
// CHECK:     <key>extended_message</key>
// CHECK:     <string>Calling &apos;reallyPerformAction&apos;</string>
// CHECK:     <key>message</key>
// CHECK:     <string>Calling &apos;reallyPerformAction&apos;</string>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>event</string>
// CHECK:     <key>location</key>
// CHECK:     <dict>
// CHECK:      <key>line</key><integer>22</integer>
// CHECK:      <key>col</key><integer>1</integer>
// CHECK:      <key>file</key><integer>0</integer>
// CHECK:     </dict>
// CHECK:     <key>depth</key><integer>2</integer>
// CHECK:     <key>extended_message</key>
// CHECK:     <string>Entered call from &apos;performAction&apos;</string>
// CHECK:     <key>message</key>
// CHECK:     <string>Entered call from &apos;performAction&apos;</string>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>control</string>
// CHECK:     <key>edges</key>
// CHECK:      <array>
// CHECK:       <dict>
// CHECK:        <key>start</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>22</integer>
// CHECK:           <key>col</key><integer>1</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>22</integer>
// CHECK:           <key>col</key><integer>6</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:        <key>end</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>23</integer>
// CHECK:           <key>col</key><integer>3</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>23</integer>
// CHECK:           <key>col</key><integer>16</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:       </dict>
// CHECK:      </array>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>event</string>
// CHECK:     <key>location</key>
// CHECK:     <dict>
// CHECK:      <key>line</key><integer>23</integer>
// CHECK:      <key>col</key><integer>3</integer>
// CHECK:      <key>file</key><integer>0</integer>
// CHECK:     </dict>
// CHECK:     <key>ranges</key>
// CHECK:     <array>
// CHECK:       <array>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>23</integer>
// CHECK:         <key>col</key><integer>3</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>23</integer>
// CHECK:         <key>col</key><integer>58</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:       </array>
// CHECK:     </array>
// CHECK:     <key>depth</key><integer>2</integer>
// CHECK:     <key>extended_message</key>
// CHECK:     <string>Calling anonymous block</string>
// CHECK:     <key>message</key>
// CHECK:     <string>Calling anonymous block</string>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>event</string>
// CHECK:     <key>location</key>
// CHECK:     <dict>
// CHECK:      <key>line</key><integer>29</integer>
// CHECK:      <key>col</key><integer>23</integer>
// CHECK:      <key>file</key><integer>0</integer>
// CHECK:     </dict>
// CHECK:     <key>depth</key><integer>3</integer>
// CHECK:     <key>extended_message</key>
// CHECK:     <string>Entered call from &apos;reallyPerformAction&apos;</string>
// CHECK:     <key>message</key>
// CHECK:     <string>Entered call from &apos;reallyPerformAction&apos;</string>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>control</string>
// CHECK:     <key>edges</key>
// CHECK:      <array>
// CHECK:       <dict>
// CHECK:        <key>start</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>29</integer>
// CHECK:           <key>col</key><integer>23</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>29</integer>
// CHECK:           <key>col</key><integer>23</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:        <key>end</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>31</integer>
// CHECK:           <key>col</key><integer>5</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>31</integer>
// CHECK:           <key>col</key><integer>6</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:       </dict>
// CHECK:      </array>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>control</string>
// CHECK:     <key>edges</key>
// CHECK:      <array>
// CHECK:       <dict>
// CHECK:        <key>start</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>31</integer>
// CHECK:           <key>col</key><integer>5</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>31</integer>
// CHECK:           <key>col</key><integer>6</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:        <key>end</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>31</integer>
// CHECK:           <key>col</key><integer>9</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>31</integer>
// CHECK:           <key>col</key><integer>12</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:       </dict>
// CHECK:      </array>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>event</string>
// CHECK:     <key>location</key>
// CHECK:     <dict>
// CHECK:      <key>line</key><integer>31</integer>
// CHECK:      <key>col</key><integer>9</integer>
// CHECK:      <key>file</key><integer>0</integer>
// CHECK:     </dict>
// CHECK:     <key>ranges</key>
// CHECK:     <array>
// CHECK:       <array>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>31</integer>
// CHECK:         <key>col</key><integer>9</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>31</integer>
// CHECK:         <key>col</key><integer>12</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:       </array>
// CHECK:     </array>
// CHECK:     <key>depth</key><integer>3</integer>
// CHECK:     <key>extended_message</key>
// CHECK:     <string>Assuming &apos;cond&apos; is not equal to 0</string>
// CHECK:     <key>message</key>
// CHECK:     <string>Assuming &apos;cond&apos; is not equal to 0</string>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>control</string>
// CHECK:     <key>edges</key>
// CHECK:      <array>
// CHECK:       <dict>
// CHECK:        <key>start</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>31</integer>
// CHECK:           <key>col</key><integer>9</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>31</integer>
// CHECK:           <key>col</key><integer>12</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:        <key>end</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>33</integer>
// CHECK:           <key>col</key><integer>7</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>33</integer>
// CHECK:           <key>col</key><integer>14</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:       </dict>
// CHECK:      </array>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>control</string>
// CHECK:     <key>edges</key>
// CHECK:      <array>
// CHECK:       <dict>
// CHECK:        <key>start</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>33</integer>
// CHECK:           <key>col</key><integer>7</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>33</integer>
// CHECK:           <key>col</key><integer>14</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:        <key>end</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>33</integer>
// CHECK:           <key>col</key><integer>30</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>33</integer>
// CHECK:           <key>col</key><integer>30</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:       </dict>
// CHECK:      </array>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>event</string>
// CHECK:     <key>location</key>
// CHECK:     <dict>
// CHECK:      <key>line</key><integer>33</integer>
// CHECK:      <key>col</key><integer>30</integer>
// CHECK:      <key>file</key><integer>0</integer>
// CHECK:     </dict>
// CHECK:     <key>ranges</key>
// CHECK:     <array>
// CHECK:       <array>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>33</integer>
// CHECK:         <key>col</key><integer>30</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>33</integer>
// CHECK:         <key>col</key><integer>50</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:       </array>
// CHECK:     </array>
// CHECK:     <key>depth</key><integer>3</integer>
// CHECK:     <key>extended_message</key>
// CHECK:     <string>NSNumber boxed expression produces an object with a +0 retain count</string>
// CHECK:     <key>message</key>
// CHECK:     <string>NSNumber boxed expression produces an object with a +0 retain count</string>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>control</string>
// CHECK:     <key>edges</key>
// CHECK:      <array>
// CHECK:       <dict>
// CHECK:        <key>start</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>33</integer>
// CHECK:           <key>col</key><integer>30</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>33</integer>
// CHECK:           <key>col</key><integer>30</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:        <key>end</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>35</integer>
// CHECK:           <key>col</key><integer>33</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>35</integer>
// CHECK:           <key>col</key><integer>38</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:       </dict>
// CHECK:      </array>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>event</string>
// CHECK:     <key>location</key>
// CHECK:     <dict>
// CHECK:      <key>line</key><integer>35</integer>
// CHECK:      <key>col</key><integer>33</integer>
// CHECK:      <key>file</key><integer>0</integer>
// CHECK:     </dict>
// CHECK:     <key>ranges</key>
// CHECK:     <array>
// CHECK:       <array>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>35</integer>
// CHECK:         <key>col</key><integer>33</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>35</integer>
// CHECK:         <key>col</key><integer>50</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:       </array>
// CHECK:     </array>
// CHECK:     <key>depth</key><integer>3</integer>
// CHECK:     <key>extended_message</key>
// CHECK:     <string>Calling anonymous block</string>
// CHECK:     <key>message</key>
// CHECK:     <string>Calling anonymous block</string>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>event</string>
// CHECK:     <key>location</key>
// CHECK:     <dict>
// CHECK:      <key>line</key><integer>49</integer>
// CHECK:      <key>col</key><integer>40</integer>
// CHECK:      <key>file</key><integer>0</integer>
// CHECK:     </dict>
// CHECK:     <key>depth</key><integer>4</integer>
// CHECK:     <key>extended_message</key>
// CHECK:     <string>Entered call</string>
// CHECK:     <key>message</key>
// CHECK:     <string>Entered call</string>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>control</string>
// CHECK:     <key>edges</key>
// CHECK:      <array>
// CHECK:       <dict>
// CHECK:        <key>start</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>49</integer>
// CHECK:           <key>col</key><integer>40</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>49</integer>
// CHECK:           <key>col</key><integer>40</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:        <key>end</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>50</integer>
// CHECK:           <key>col</key><integer>5</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>50</integer>
// CHECK:           <key>col</key><integer>17</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:       </dict>
// CHECK:      </array>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>control</string>
// CHECK:     <key>edges</key>
// CHECK:      <array>
// CHECK:       <dict>
// CHECK:        <key>start</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>50</integer>
// CHECK:           <key>col</key><integer>5</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>50</integer>
// CHECK:           <key>col</key><integer>17</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:        <key>end</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>50</integer>
// CHECK:           <key>col</key><integer>21</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>50</integer>
// CHECK:           <key>col</key><integer>21</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:       </dict>
// CHECK:      </array>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>event</string>
// CHECK:     <key>location</key>
// CHECK:     <dict>
// CHECK:      <key>line</key><integer>50</integer>
// CHECK:      <key>col</key><integer>21</integer>
// CHECK:      <key>file</key><integer>0</integer>
// CHECK:     </dict>
// CHECK:     <key>ranges</key>
// CHECK:     <array>
// CHECK:       <array>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>50</integer>
// CHECK:         <key>col</key><integer>21</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>50</integer>
// CHECK:         <key>col</key><integer>39</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:       </array>
// CHECK:       <array>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>50</integer>
// CHECK:         <key>col</key><integer>22</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>50</integer>
// CHECK:         <key>col</key><integer>31</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:       </array>
// CHECK:     </array>
// CHECK:     <key>depth</key><integer>4</integer>
// CHECK:     <key>extended_message</key>
// CHECK:     <string>Reference count incremented. The object now has a +1 retain count</string>
// CHECK:     <key>message</key>
// CHECK:     <string>Reference count incremented. The object now has a +1 retain count</string>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>event</string>
// CHECK:     <key>location</key>
// CHECK:     <dict>
// CHECK:      <key>line</key><integer>35</integer>
// CHECK:      <key>col</key><integer>33</integer>
// CHECK:      <key>file</key><integer>0</integer>
// CHECK:     </dict>
// CHECK:     <key>ranges</key>
// CHECK:     <array>
// CHECK:       <array>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>35</integer>
// CHECK:         <key>col</key><integer>33</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>35</integer>
// CHECK:         <key>col</key><integer>50</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:       </array>
// CHECK:     </array>
// CHECK:     <key>depth</key><integer>3</integer>
// CHECK:     <key>extended_message</key>
// CHECK:     <string>Returning to caller</string>
// CHECK:     <key>message</key>
// CHECK:     <string>Returning to caller</string>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>control</string>
// CHECK:     <key>edges</key>
// CHECK:      <array>
// CHECK:       <dict>
// CHECK:        <key>start</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>35</integer>
// CHECK:           <key>col</key><integer>33</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>35</integer>
// CHECK:           <key>col</key><integer>38</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:        <key>end</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>37</integer>
// CHECK:           <key>col</key><integer>7</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>37</integer>
// CHECK:           <key>col</key><integer>8</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:       </dict>
// CHECK:      </array>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>control</string>
// CHECK:     <key>edges</key>
// CHECK:      <array>
// CHECK:       <dict>
// CHECK:        <key>start</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>37</integer>
// CHECK:           <key>col</key><integer>7</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>37</integer>
// CHECK:           <key>col</key><integer>8</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:        <key>end</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>40</integer>
// CHECK:           <key>col</key><integer>7</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>40</integer>
// CHECK:           <key>col</key><integer>18</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:       </dict>
// CHECK:      </array>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>event</string>
// CHECK:     <key>location</key>
// CHECK:     <dict>
// CHECK:      <key>line</key><integer>23</integer>
// CHECK:      <key>col</key><integer>3</integer>
// CHECK:      <key>file</key><integer>0</integer>
// CHECK:     </dict>
// CHECK:     <key>ranges</key>
// CHECK:     <array>
// CHECK:       <array>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>23</integer>
// CHECK:         <key>col</key><integer>3</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>23</integer>
// CHECK:         <key>col</key><integer>58</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:       </array>
// CHECK:     </array>
// CHECK:     <key>depth</key><integer>2</integer>
// CHECK:     <key>extended_message</key>
// CHECK:     <string>Returning to caller</string>
// CHECK:     <key>message</key>
// CHECK:     <string>Returning to caller</string>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>control</string>
// CHECK:     <key>edges</key>
// CHECK:      <array>
// CHECK:       <dict>
// CHECK:        <key>start</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>23</integer>
// CHECK:           <key>col</key><integer>3</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>23</integer>
// CHECK:           <key>col</key><integer>16</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:        <key>end</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>24</integer>
// CHECK:           <key>col</key><integer>3</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>24</integer>
// CHECK:           <key>col</key><integer>16</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:       </dict>
// CHECK:      </array>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>event</string>
// CHECK:     <key>location</key>
// CHECK:     <dict>
// CHECK:      <key>line</key><integer>24</integer>
// CHECK:      <key>col</key><integer>3</integer>
// CHECK:      <key>file</key><integer>0</integer>
// CHECK:     </dict>
// CHECK:     <key>ranges</key>
// CHECK:     <array>
// CHECK:       <array>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>24</integer>
// CHECK:         <key>col</key><integer>3</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>24</integer>
// CHECK:         <key>col</key><integer>58</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:       </array>
// CHECK:     </array>
// CHECK:     <key>depth</key><integer>2</integer>
// CHECK:     <key>extended_message</key>
// CHECK:     <string>Calling anonymous block</string>
// CHECK:     <key>message</key>
// CHECK:     <string>Calling anonymous block</string>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>event</string>
// CHECK:     <key>location</key>
// CHECK:     <dict>
// CHECK:      <key>line</key><integer>29</integer>
// CHECK:      <key>col</key><integer>23</integer>
// CHECK:      <key>file</key><integer>0</integer>
// CHECK:     </dict>
// CHECK:     <key>depth</key><integer>3</integer>
// CHECK:     <key>extended_message</key>
// CHECK:     <string>Entered call from &apos;reallyPerformAction&apos;</string>
// CHECK:     <key>message</key>
// CHECK:     <string>Entered call from &apos;reallyPerformAction&apos;</string>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>control</string>
// CHECK:     <key>edges</key>
// CHECK:      <array>
// CHECK:       <dict>
// CHECK:        <key>start</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>29</integer>
// CHECK:           <key>col</key><integer>23</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>29</integer>
// CHECK:           <key>col</key><integer>23</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:        <key>end</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>31</integer>
// CHECK:           <key>col</key><integer>5</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>31</integer>
// CHECK:           <key>col</key><integer>6</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:       </dict>
// CHECK:      </array>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>control</string>
// CHECK:     <key>edges</key>
// CHECK:      <array>
// CHECK:       <dict>
// CHECK:        <key>start</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>31</integer>
// CHECK:           <key>col</key><integer>5</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>31</integer>
// CHECK:           <key>col</key><integer>6</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:        <key>end</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>31</integer>
// CHECK:           <key>col</key><integer>9</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>31</integer>
// CHECK:           <key>col</key><integer>12</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:       </dict>
// CHECK:      </array>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>event</string>
// CHECK:     <key>location</key>
// CHECK:     <dict>
// CHECK:      <key>line</key><integer>31</integer>
// CHECK:      <key>col</key><integer>9</integer>
// CHECK:      <key>file</key><integer>0</integer>
// CHECK:     </dict>
// CHECK:     <key>ranges</key>
// CHECK:     <array>
// CHECK:       <array>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>31</integer>
// CHECK:         <key>col</key><integer>9</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>31</integer>
// CHECK:         <key>col</key><integer>12</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:       </array>
// CHECK:     </array>
// CHECK:     <key>depth</key><integer>3</integer>
// CHECK:     <key>extended_message</key>
// CHECK:     <string>Assuming &apos;cond&apos; is not equal to 0</string>
// CHECK:     <key>message</key>
// CHECK:     <string>Assuming &apos;cond&apos; is not equal to 0</string>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>control</string>
// CHECK:     <key>edges</key>
// CHECK:      <array>
// CHECK:       <dict>
// CHECK:        <key>start</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>31</integer>
// CHECK:           <key>col</key><integer>9</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>31</integer>
// CHECK:           <key>col</key><integer>12</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:        <key>end</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>33</integer>
// CHECK:           <key>col</key><integer>7</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>33</integer>
// CHECK:           <key>col</key><integer>14</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:       </dict>
// CHECK:      </array>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>control</string>
// CHECK:     <key>edges</key>
// CHECK:      <array>
// CHECK:       <dict>
// CHECK:        <key>start</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>33</integer>
// CHECK:           <key>col</key><integer>7</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>33</integer>
// CHECK:           <key>col</key><integer>14</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:        <key>end</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>35</integer>
// CHECK:           <key>col</key><integer>33</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>35</integer>
// CHECK:           <key>col</key><integer>38</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:       </dict>
// CHECK:      </array>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>event</string>
// CHECK:     <key>location</key>
// CHECK:     <dict>
// CHECK:      <key>line</key><integer>35</integer>
// CHECK:      <key>col</key><integer>33</integer>
// CHECK:      <key>file</key><integer>0</integer>
// CHECK:     </dict>
// CHECK:     <key>ranges</key>
// CHECK:     <array>
// CHECK:       <array>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>35</integer>
// CHECK:         <key>col</key><integer>33</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>35</integer>
// CHECK:         <key>col</key><integer>50</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:       </array>
// CHECK:     </array>
// CHECK:     <key>depth</key><integer>3</integer>
// CHECK:     <key>extended_message</key>
// CHECK:     <string>Calling anonymous block</string>
// CHECK:     <key>message</key>
// CHECK:     <string>Calling anonymous block</string>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>event</string>
// CHECK:     <key>location</key>
// CHECK:     <dict>
// CHECK:      <key>line</key><integer>49</integer>
// CHECK:      <key>col</key><integer>40</integer>
// CHECK:      <key>file</key><integer>0</integer>
// CHECK:     </dict>
// CHECK:     <key>depth</key><integer>4</integer>
// CHECK:     <key>extended_message</key>
// CHECK:     <string>Entered call</string>
// CHECK:     <key>message</key>
// CHECK:     <string>Entered call</string>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>control</string>
// CHECK:     <key>edges</key>
// CHECK:      <array>
// CHECK:       <dict>
// CHECK:        <key>start</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>49</integer>
// CHECK:           <key>col</key><integer>40</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>49</integer>
// CHECK:           <key>col</key><integer>40</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:        <key>end</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>50</integer>
// CHECK:           <key>col</key><integer>5</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>50</integer>
// CHECK:           <key>col</key><integer>17</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:       </dict>
// CHECK:      </array>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>control</string>
// CHECK:     <key>edges</key>
// CHECK:      <array>
// CHECK:       <dict>
// CHECK:        <key>start</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>50</integer>
// CHECK:           <key>col</key><integer>5</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>50</integer>
// CHECK:           <key>col</key><integer>17</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:        <key>end</key>
// CHECK:         <array>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>52</integer>
// CHECK:           <key>col</key><integer>5</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:          <dict>
// CHECK:           <key>line</key><integer>52</integer>
// CHECK:           <key>col</key><integer>10</integer>
// CHECK:           <key>file</key><integer>0</integer>
// CHECK:          </dict>
// CHECK:         </array>
// CHECK:       </dict>
// CHECK:      </array>
// CHECK:    </dict>
// CHECK:    <dict>
// CHECK:     <key>kind</key><string>event</string>
// CHECK:     <key>location</key>
// CHECK:     <dict>
// CHECK:      <key>line</key><integer>52</integer>
// CHECK:      <key>col</key><integer>5</integer>
// CHECK:      <key>file</key><integer>0</integer>
// CHECK:     </dict>
// CHECK:     <key>ranges</key>
// CHECK:     <array>
// CHECK:       <array>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>52</integer>
// CHECK:         <key>col</key><integer>5</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:        <dict>
// CHECK:         <key>line</key><integer>52</integer>
// CHECK:         <key>col</key><integer>21</integer>
// CHECK:         <key>file</key><integer>0</integer>
// CHECK:        </dict>
// CHECK:       </array>
// CHECK:     </array>
// CHECK:     <key>depth</key><integer>4</integer>
// CHECK:     <key>extended_message</key>
// CHECK:     <string>Object leaked: allocated object is not referenced later in this execution path and has a retain count of +1</string>
// CHECK:     <key>message</key>
// CHECK:     <string>Object leaked: allocated object is not referenced later in this execution path and has a retain count of +1</string>
// CHECK:    </dict>
// CHECK:   </array>
// CHECK:   <key>description</key><string>Potential leak of an object</string>
// CHECK:   <key>category</key><string>Memory (Core Foundation/Objective-C)</string>
// CHECK:   <key>type</key><string>Leak</string>
// CHECK:  <key>location</key>
// CHECK:  <dict>
// CHECK:   <key>line</key><integer>52</integer>
// CHECK:   <key>col</key><integer>5</integer>
// CHECK:   <key>file</key><integer>0</integer>
// CHECK:  </dict>
// CHECK:  </dict>
// CHECK: </array>
// CHECK:</dict>
// CHECK:</plist>
