/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tizen.ecp.utils.LogUtil;

public class ECPProperty {
    private static Logger logger = LogUtil.getECPLogger(ECPProperty.class).getLogger();
    private Properties ecpProperties;
    private String ecpPropertiesFilePath;

    public ECPProperty(String ecpPropertiesFilePath) {
        if (this.ecpProperties == null) {
            this.ecpProperties = new Properties();
        }
        this.ecpPropertiesFilePath = ecpPropertiesFilePath;
        this.getProperty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPropertyFile(String path) {
        File f = new File(path);
        try {
            f.createNewFile();
        }
        catch (IOException e2) {
            this.ecpProperties = null;
            return;
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(f);
        }
        catch (IOException e2) {
            this.ecpProperties = null;
            return;
        }
        BufferedWriter out = null;
        out = new BufferedWriter(writer);
        try {
            out.write("window.x=100\n");
            out.write("window.y=100\n");
            out.write("window.width=706\n");
            out.write("window.height=580\n");
            out.write("view.last=event injector\n");
        }
        catch (IOException e1) {
            this.ecpProperties = null;
            return;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                this.ecpProperties = null;
                return;
            }
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            this.ecpProperties = null;
            return;
        }
        try {
            this.ecpProperties.load(inputStream);
        }
        catch (IOException e) {
            this.ecpProperties = null;
        }
        try {
            inputStream.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    private void getProperty() {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(this.ecpPropertiesFilePath);
        }
        catch (FileNotFoundException e2) {
            logger.log(Level.WARNING, e2.getMessage());
            this.createPropertyFile(this.ecpPropertiesFilePath);
        }
        if (inputStream != null) {
            try {
                this.ecpProperties.load(inputStream);
            }
            catch (IOException e) {
                this.ecpProperties = null;
            }
            try {
                inputStream.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage());
            }
        }
    }

    public int getPropertyInt(String key) {
        return Integer.parseInt(this.ecpProperties.getProperty(key));
    }

    public String getPropertyString(String key) {
        return this.ecpProperties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.ecpProperties.put(key, value);
    }

    public void setProperty(String key, int value) {
        this.setProperty(key, Integer.toString(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeProperty() {
        File file = new File(this.ecpPropertiesFilePath);
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    return;
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Fail to create EmulatorControlPanel properties file.", e);
                return;
            }
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            this.ecpProperties.store(fos, "possible log.level values: error, warn, debug, trace");
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            try {
                if (null != fos) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static interface ECPProperties {
        public static final String WINDOW_X = "window.x";
        public static final String WINDOW_Y = "window.y";
        public static final String WINDOW_WIDTH = "window.width";
        public static final String WINDOW_HEIGHT = "window.height";
        public static final String VIEW_LAST = "view.last";
    }
}

