/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.cli;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.kohsuke.args4j.spi.SubCommand;
import org.kohsuke.args4j.spi.SubCommands;
import org.tizen.cli.monitor.KeyCodeCLI;
import org.tizen.cli.monitor.TizenEmulatorHMP;
import org.tizen.cli.monitor.TizenEmulatorHelp;
import org.tizen.cli.monitor.TizenEmulatorQMP;
import org.tizen.cli.monitor.hds.HDSCLI;
import org.tizen.cli.monitor.hds.HDSMountCLI;
import org.tizen.cli.monitor.hds.HDSStatusCLI;
import org.tizen.cli.monitor.hds.HDSUmountCLI;
import org.tizen.cli.utils.EmulatorDevice;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.DynamicLoader;
import org.tizen.ecp.ECPInfo;
import org.tizen.ecp.ecpinfo.xml.CliTypes;

public class CLIManager {
    private List<EmulatorDevice> devices = new ArrayList<EmulatorDevice>();
    private EmulatorDevice device = null;
    private static CLIManager instance = new CLIManager();
    private HashMap<String, Class<?>> classMap = new HashMap();
    private HashMap<Class<?>, Object> instanceMap = new HashMap();
    private boolean sessionMode = false;

    public CLIManager() {
        this.classMap.put("org.tizen.cli.monitor.TizenEmulatorHelp", TizenEmulatorHelp.class);
        this.classMap.put("org.tizen.cli.monitor.TizenEmulatorHMP", TizenEmulatorHMP.class);
        this.classMap.put("org.tizen.cli.monitor.TizenEmulatorQMP", TizenEmulatorQMP.class);
        this.classMap.put("org.tizen.cli.monitor.KeyCodeCLI", KeyCodeCLI.class);
        this.classMap.put("org.tizen.cli.monitor.hds.HDSCLI", HDSCLI.class);
        this.classMap.put("org.tizen.cli.monitor.hds.HDSMountCLI", HDSMountCLI.class);
        this.classMap.put("org.tizen.cli.monitor.hds.HDSUmountCLI", HDSUmountCLI.class);
        this.classMap.put("org.tizen.cli.monitor.hds.HDSStatusCLI", HDSStatusCLI.class);
        this.instanceMap.put(TizenEmulatorHelp.class, new TizenEmulatorHelp());
        this.instanceMap.put(TizenEmulatorHMP.class, new TizenEmulatorHMP());
        this.instanceMap.put(TizenEmulatorQMP.class, new TizenEmulatorQMP());
        this.instanceMap.put(KeyCodeCLI.class, new KeyCodeCLI());
        this.instanceMap.put(HDSCLI.class, new HDSCLI());
        this.instanceMap.put(HDSMountCLI.class, new HDSMountCLI());
        this.instanceMap.put(HDSUmountCLI.class, new HDSUmountCLI());
        this.instanceMap.put(HDSStatusCLI.class, new HDSStatusCLI());
    }

    public static CLIManager getInstance() {
        return instance;
    }

    public void addInfo(String vmname, int port) {
        EmulatorDevice dev = new EmulatorDevice(vmname, port);
        this.devices.add(dev);
    }

    public List<EmulatorDevice> getDevices() {
        return this.devices;
    }

    public void setSelectedDevice(EmulatorDevice device) {
        this.device = device;
    }

    public EmulatorDevice getSelectedDevice() {
        return this.device;
    }

    public void setSessionMode(boolean session) {
        this.sessionMode = session;
    }

    public boolean getSessionMode() {
        return this.sessionMode;
    }

    public CliTypes.Device findDevice(String device) {
        List deviceList = ECPInfo.getInstance().getCLIInfo();
        if (deviceList == null) {
            return null;
        }
        for (CliTypes.Device d : deviceList) {
            String name = d.getName();
            if (name == null || name.isEmpty() || !name.equals(device)) continue;
            return d;
        }
        if ("hds".equals(device)) {
            CliTypes.Device hdsDevice = new CliTypes.Device();
            hdsDevice.setName("org.tizen.cli.monitor.hds.HDSCLI");
            hdsDevice.setImpl(HDSCLI.class.getName());
            return hdsDevice;
        }
        return null;
    }

    public void loadClass() {
        List devices = ECPInfo.getInstance().getCLIInfo();
        if (devices == null) {
            return;
        }
        for (CliTypes.Device dev : devices) {
            Class dClass;
            try {
                dClass = DynamicLoader.dynamicLoadClass((String)ECPInfo.getInstance().getJarPath(), (String)dev.getImpl());
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            if (dClass == null) continue;
            this.classMap.put(dev.getImpl(), dClass);
            for (Field f : dClass.getDeclaredFields()) {
                SubCommands scmds = f.getAnnotation(SubCommands.class);
                if (scmds == null) continue;
                for (SubCommand scmd : scmds.value()) {
                    if (scmd == null) continue;
                    try {
                        dClass = DynamicLoader.dynamicLoadClass((String)ECPInfo.getInstance().getJarPath(), (String)scmd.impl().getCanonicalName());
                    }
                    catch (ClassNotFoundException e) {
                        continue;
                    }
                    this.classMap.put(scmd.impl().getCanonicalName(), dClass);
                }
            }
        }
    }

    public Class<?> getClass(String className) {
        OutputUtil.debug("CLIManager - getClass requested : " + className);
        return this.classMap.get(className);
    }

    public Object instantiate(Class<?> loadClass) throws InstantiationException, IllegalAccessException {
        Object object = null;
        if (this.instanceMap.containsKey(loadClass)) {
            OutputUtil.debug("instanceMap has the key : " + loadClass.getCanonicalName());
            return this.instanceMap.get(loadClass);
        }
        object = loadClass.newInstance();
        this.instanceMap.put(loadClass, object);
        return object;
    }

    public Object getInstantiateClass(String className) throws InstantiationException, IllegalAccessException {
        return this.instantiate(this.getClass(className));
    }

    public Collection<Object> getClassInstances() {
        return this.instanceMap.values();
    }
}

