/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.cli.monitor;

import java.util.logging.Logger;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.CLIManager;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.ecpinfo.xml.CliTypes;
import org.tizen.ecp.resources.StringResources;
import org.tizen.ecp.utils.LogUtil;

public class TizenEmulatorHelp
extends AbstractEmulatorCLI {
    private static Logger logger = LogUtil.getECPLogger(TizenEmulatorHelp.class).getLogger();
    @Argument(index=0)
    String target;

    @Override
    public int execute() {
        CliTypes.Device device = null;
        if (this.target == null) {
            OutputUtil.println(this.help);
        } else {
            device = CLIManager.getInstance().findDevice(this.target);
            if (device != null) {
                try {
                    Class<?> dp = CLIManager.getInstance().getClass(device.getImpl());
                    if (dp == null) {
                        OutputUtil.printError("Failed to load class.", this.target);
                        this.target = null;
                        return 22;
                    }
                    AbstractEmulatorCLI handler = (AbstractEmulatorCLI)CLIManager.getInstance().instantiate(dp);
                    if (handler == null) {
                        OutputUtil.printError("Not a CLI supported class.");
                        this.target = null;
                        return 22;
                    }
                    handler.printHelp();
                }
                catch (IllegalAccessException e) {
                    OutputUtil.printError("Device is not specified correctly. Check plugin.xml.", e);
                    logger.severe("IllegalAccessException: " + e.getMessage());
                }
                catch (InstantiationException e) {
                    OutputUtil.printError("Device is not specified correctly. Check plugin.xml.", e);
                    logger.severe("InstantiationException: " + e.getMessage());
                }
                catch (ClassCastException e) {
                    OutputUtil.printError("Device is not specified correctly. Check plugin.xml.", e);
                    logger.severe("ClassCastException: " + e.getMessage());
                }
            } else if ("hmp".equals(this.target)) {
                OutputUtil.printDeviceUsage("hmp");
            } else if ("qmp".equals(this.target)) {
                OutputUtil.printDeviceUsage("qmp");
            } else if ("keycode".equals(this.target)) {
                OutputUtil.println(OutputUtil.getDeviceUsage("keycode") + "<number> [period|press|release] " + "[--target <VM name | serial>]" + StringResources.NEW_LINE + StringResources.NEW_LINE + "Command arguments :\n" + OutputUtil.getFormatList("'number' is keycode key value") + OutputUtil.getFormatList("'period' is integer period between press and release. unit is 'ms'") + OutputUtil.getFormatList("'press' and 'release' are string"));
            } else if ("hds".equals(this.target)) {
                OutputUtil.println(OutputUtil.getDeviceUsage("hds") + "Supported commands are :\n" + OutputUtil.getFormatList("mount <host path> <guest path>") + OutputUtil.getFormatList("unmount") + OutputUtil.getFormatList("status") + "Command arguments :\n" + OutputUtil.getFormatList("'host path' is a directory which will be mounted in your PC.") + OutputUtil.getFormatList("'guest path' is a directory in emulator."));
            } else {
                OutputUtil.printError("Not supported commands.");
                this.target = null;
                return 25;
            }
        }
        this.target = null;
        return 0;
    }
}

