/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.category;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.tizen.ecp.category.ECPListItem;
import org.tizen.ecp.resources.ImageResources;
import org.tizen.ecp.resources.PatchImageResources;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.ViewMgr;

public class ECPListCtrl {
    private static Logger logger = LogUtil.getECPLogger(ECPListCtrl.class).getLogger();
    private static ECPListCtrl instance = new ECPListCtrl();
    private ArrayList<ECPListItem> m_rootitems = new ArrayList();
    private ArrayList<ECPListItem> m_listitems = new ArrayList();
    private Composite m_comp;
    private Composite m_parent;
    private ECPListItem m_selectedItem;
    public Image m_imgArrowOpened = ImageResources.LIST_ARROW_OPEN.getImage();
    public Image m_imgArrowClosed = ImageResources.LIST_ARROW_CLOSE.getImage();
    public Image m_rootImgArrowOpened = ImageResources.LIST_B_ARROW_OPEN.getImage();
    public Image m_rootImgArrowClosed = ImageResources.LIST_B_ARROW_CLOSE.getImage();
    public ControlAdapter m_controlAdapter = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            ECPListCtrl.this.OnResized(e);
        }
    };

    public static ECPListCtrl getInstance() {
        return instance;
    }

    public Composite getComposite() {
        return this.m_comp;
    }

    public ECPListItem getItem(int index) {
        if (index > this.m_listitems.size() - 1) {
            return null;
        }
        return this.m_listitems.get(index);
    }

    public ArrayList<ECPListItem> getRootItem() {
        return this.m_rootitems;
    }

    public int getRootIndex(ECPListItem item) {
        for (int i = 0; i < this.m_rootitems.size(); ++i) {
            if (!((Object)((Object)this.m_rootitems.get(i))).equals((Object)item)) continue;
            return i;
        }
        return -1;
    }

    public ECPListItem getItem(String name) {
        if (name == null) {
            return null;
        }
        for (ECPListItem root : this.m_rootitems) {
            if (!name.equals(root.getText())) continue;
            return root;
        }
        for (ECPListItem item : this.m_listitems) {
            if (!name.equals(item.getText())) continue;
            return item;
        }
        return null;
    }

    public void setSelect(String device) {
        ECPListItem item = this.getItem(device);
        if (item == null) {
            logger.warning("cannot find ECPListItem from " + device);
            return;
        }
        if (this.m_selectedItem != null) {
            this.m_selectedItem.setSelection(false);
            this.OnItemStateChanged(this.m_selectedItem);
        }
        item.setSelection(true);
        this.OnItemStateChanged(item);
        this.m_selectedItem = item;
    }

    public ArrayList<ECPListItem> getItems() {
        return this.m_listitems;
    }

    public void create(Composite parent, int top, int left) {
        this.m_parent = parent;
        this.m_comp = new Composite(parent, 0);
        this.m_comp.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, top);
        data.left = new FormAttachment(0, left);
        data.right = new FormAttachment(100, -left);
        data.bottom = new FormAttachment(100, 0);
        this.m_comp.setLayoutData((Object)data);
        this.m_comp.addControlListener((ControlListener)this.m_controlAdapter);
    }

    public void create(Composite parent) {
        this.create(parent, 0, 0);
    }

    int getItemCount() {
        return this.m_listitems.size();
    }

    public int getListHeight() {
        int height = 3 + this.m_listitems.size() * 25;
        return height;
    }

    public ECPListItem makeItem(String text, String display, int top, Image icon) {
        ECPListItem item = new ECPListItem(this, text, 524288);
        item.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        if (this.m_listitems.size() > 0) {
            ECPListItem bottom_item = this.m_listitems.get(this.m_listitems.size() - 1);
            data.top = new FormAttachment((Control)bottom_item, 1);
        } else {
            data.top = new FormAttachment((Control)this.m_comp, top);
        }
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.height = 24;
        item.setLayoutData(data);
        item.setText(text);
        if (display != null) {
            item.setDisplayText(display);
        }
        item.setIcon(icon);
        item.setPos(0, top);
        item.setHeight(24);
        return item;
    }

    void PatchImage() {
    }

    public ECPListItem insertItem(ECPListItem parent, final String text, String display, Image icon, final String shortcut) {
        ECPListItem item;
        int width = this.m_parent.getSize().x;
        int top = 1;
        if (parent == null) {
            if (this.m_rootitems.size() > 0) {
                ECPListItem lastSiblingItem = this.m_rootitems.get(this.m_rootitems.size() - 1);
                Point bottom_pos = lastSiblingItem.getBottomPos();
                top = bottom_pos.y + 1;
            }
            item = this.makeItem(text, display, top, icon);
            this.m_rootitems.add(item);
        } else {
            Point bottom_pos = parent.getBottomPos();
            top = bottom_pos.y + 1;
            item = this.makeItem(text, display, top, icon);
            Image img_nml = PatchImageResources.getUnselectedList(width, 24);
            Image img_selected = PatchImageResources.getSelectedList(width, 24);
            item.setImages(img_nml, img_selected);
            parent.insertChild(item);
        }
        item.setIndex(this.m_listitems.size());
        this.m_listitems.add(item);
        this.m_comp.layout();
        if (shortcut != null && !shortcut.isEmpty()) {
            item.setToolTipText("ALT + " + shortcut.toUpperCase());
            Display dp = Display.getDefault();
            dp.addFilter(1, new Listener(){

                public void handleEvent(Event e) {
                    if ((e.stateMask & 0x10000) == 65536 && e.keyCode == shortcut.toLowerCase().codePointAt(0)) {
                        ECPListCtrl.this.setSelect(text);
                    }
                }
            });
        }
        return item;
    }

    public void layoutItems() {
        FormData data = new FormData();
        for (int i = 0; i < this.m_rootitems.size(); ++i) {
            if (i > 0) {
                ECPListItem bottom_item = this.m_listitems.get(this.m_listitems.size() - 1);
                System.out.println(bottom_item.m_text + "..." + bottom_item.getBounds().y);
                data.top = new FormAttachment((Control)bottom_item, 1);
            } else {
                data.top = new FormAttachment(0, 1);
            }
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.height = 24;
            ECPListItem item = this.m_rootitems.get(i);
            item.setLayoutData(data);
        }
    }

    private void OnResized(ControlEvent e) {
        this.PatchImage();
    }

    public void OnItemStateChanged(ECPListItem item) {
        if (((Object)((Object)item)).equals((Object)this.m_selectedItem) && !item.hasChild()) {
            return;
        }
        if (item.isSelected()) {
            if (this.m_selectedItem != null) {
                this.m_selectedItem.setSelection(false);
            }
            this.m_selectedItem = item;
        }
        this.m_selectedItem.setSelection(true);
        this.m_selectedItem.setFocus();
        boolean hasChild = item.hasChild();
        boolean isExpanded = item.isExpanded();
        if (hasChild) {
            if (isExpanded) {
                item.Expand();
            } else {
                item.Collapse();
            }
            this.m_comp.layout();
        }
        ViewMgr.getInstance().setActivate(item.getText());
    }
}

