/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.widgets;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.views.ECPLeftView;

public class CustomListItem
extends Canvas {
    private int mouse = 0;
    private boolean hit = false;
    private boolean isSelected = false;
    private String text;
    private int textPositionX;
    private int textPositionY;
    private static Color colorTextNormal;
    private static Color colorTextSelected;
    private Image img_nml;
    private Image img_selected;
    private static Font font;

    public CustomListItem(ECPLeftView listView, Composite parent, int style) {
        super(parent, 0x20000000 | style);
        colorTextNormal = ColorResources.TEXT_NORMAL.getColor();
        colorTextSelected = ColorResources.TEXT_SELECT.getColor();
        font = new Font((Device)Display.getCurrent(), "Verdana", 12, 0);
        this.text = null;
        this.textPositionX = 30;
        this.textPositionY = 2;
        this.setBackgroundImage(this.img_nml);
        this.setFont(font);
        this.setForeground(colorTextNormal);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                switch (CustomListItem.this.mouse) {
                    case 2: {
                        e.gc.setForeground(colorTextSelected);
                        e.gc.drawImage(CustomListItem.this.img_selected, 0, 0);
                        e.gc.drawText(CustomListItem.this.text, CustomListItem.this.textPositionX, CustomListItem.this.textPositionY, true);
                        e.gc.setFont(font);
                        CustomListItem.this.isSelected = true;
                        break;
                    }
                    case 3: {
                        if (CustomListItem.this.text != null) {
                            e.gc.drawText(CustomListItem.this.text, CustomListItem.this.textPositionX, CustomListItem.this.textPositionY, true);
                            e.gc.setFont(font);
                            e.gc.setForeground(colorTextSelected);
                            e.gc.drawImage(CustomListItem.this.img_selected, 0, 0);
                        }
                    }
                    default: {
                        if (!CustomListItem.this.isSelected) {
                            e.gc.setForeground(colorTextNormal);
                            e.gc.drawImage(CustomListItem.this.img_nml, 0, 0);
                        } else {
                            e.gc.setForeground(colorTextSelected);
                            e.gc.drawImage(CustomListItem.this.img_selected, 0, 0);
                        }
                        e.gc.drawText(CustomListItem.this.text, CustomListItem.this.textPositionX, CustomListItem.this.textPositionY, true);
                        e.gc.setFont(font);
                    }
                }
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (!CustomListItem.this.hit) {
                    return;
                }
                CustomListItem.this.mouse = 2;
                if (e.x < 0 || e.y < 0 || e.x > CustomListItem.this.getBounds().width || e.y > CustomListItem.this.getBounds().height) {
                    CustomListItem.this.mouse = 0;
                }
                CustomListItem.this.redraw();
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                CustomListItem.this.mouse = 1;
                CustomListItem.this.redraw();
            }

            public void mouseExit(MouseEvent e) {
                CustomListItem.this.mouse = 0;
                CustomListItem.this.redraw();
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CustomListItem.this.hit = true;
                CustomListItem.this.mouse = 2;
                CustomListItem.this.redraw();
            }

            public void mouseUp(MouseEvent e) {
                CustomListItem.this.hit = false;
                if (e.x < 0 || e.y < 0 || e.x > CustomListItem.this.getBounds().width || e.y > CustomListItem.this.getBounds().height) {
                    CustomListItem.this.mouse = 0;
                    CustomListItem.this.isSelected = false;
                } else {
                    CustomListItem.this.isSelected = true;
                    CustomListItem.this.mouse = 3;
                    CustomListItem.this.notifyListeners(13, new Event());
                }
                CustomListItem.this.redraw();
            }
        });
    }

    public void setText(String textValue) {
        if (textValue == null || textValue.isEmpty()) {
            return;
        }
        GC gc = new GC((Drawable)this);
        gc.drawString(textValue, 10, 10);
        gc.dispose();
        this.text = textValue;
    }

    public String getText() {
        return this.text;
    }

    public boolean getSelection() {
        return this.isSelected;
    }

    public void setSelection(boolean select) {
        this.isSelected = select;
        this.redraw();
    }

    public void setImages(Image normal, Image selected) {
        this.img_nml = normal;
        this.img_selected = selected;
        this.redraw();
    }
}

