/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.utils;

import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.tizen.ecp.utils.LogUtil;

public class JsonUtil {
    public static final String CMD_HUMAN_MONITOR = "human-monitor-command";
    public static final String CMD_EXECUTE = "execute";
    public static final String CMD_ARGS = "arguments";
    public static final String CMD_LINE = "command-line";
    private static Logger logger = LogUtil.getECPLogger(JsonUtil.class).getLogger();
    private static JSONParser parser = new JSONParser();

    public static JSONObject decodeObject(String message) throws ParseException {
        if (null == message) {
            System.out.println("decodeObject - message string is null.");
            return null;
        }
        JSONParser parser = new JSONParser();
        Object obj = parser.parse(message);
        if (obj instanceof JSONObject) {
            return (JSONObject)obj;
        }
        return null;
    }

    public static JSONArray decodeArray(String message) {
        JSONArray obj = null;
        if (null == message) {
            System.out.println("decodeArray - message string is null.");
            return obj;
        }
        try {
            obj = (JSONArray)parser.parse(message);
        }
        catch (ParseException e) {
            logger.info("position: " + e.getPosition());
            logger.info(e.toString());
        }
        return obj;
    }

    public static String decodeString(String message) throws ParseException {
        if (null == message) {
            System.out.println("decodeArray - message string is null.");
            return null;
        }
        JSONObject obj = JsonUtil.decodeObject(message);
        if (null == obj) {
            return null;
        }
        return obj.toJSONString();
    }

    public static String encodeString(String key, String value) {
        if (null == value) {
            return null;
        }
        JSONObject obj = new JSONObject();
        obj.put((Object)key, (Object)value);
        return obj.toJSONString().trim();
    }

    public static String encodeString(String key1, String value1, String key2, String value2) {
        JSONObject obj = new JSONObject();
        obj.put((Object)key1, (Object)value1);
        obj.put((Object)key2, (Object)value2);
        return obj.toJSONString().trim();
    }

    public static String encodeString(String key1, String value1, String key2, JSONObject objs) {
        JSONObject obj = new JSONObject();
        obj.put((Object)key1, (Object)value1);
        obj.put((Object)key2, (Object)objs);
        return obj.toJSONString().trim();
    }

    public static String encodeMonitorString(String key1, String value1, String key2, JSONObject objs, String type) {
        JSONObject obj = new JSONObject();
        obj.put((Object)key1, (Object)value1);
        obj.put((Object)key2, (Object)objs);
        obj.put((Object)"type", (Object)type);
        return obj.toJSONString().trim();
    }

    public static String encodeMonitorString(String jsonString, String type) throws ParseException {
        JSONObject obj = JsonUtil.decodeObject(jsonString);
        if (obj == null) {
            return null;
        }
        obj.put((Object)"type", (Object)type);
        return obj.toJSONString().trim();
    }

    public static JSONObject encodeObject(String key, String value) {
        JSONObject obj = new JSONObject();
        obj.put((Object)key, (Object)value);
        return obj;
    }

    public static boolean messageComplete(String msg) {
        int braceCount = 0;
        for (int i = 0; i < msg.length(); ++i) {
            char value = msg.charAt(i);
            if (value == '{') {
                ++braceCount;
                continue;
            }
            if (value != '}') continue;
            --braceCount;
        }
        if (braceCount == 0) {
            logger.info("message complete: return true");
            return true;
        }
        return false;
    }

    public static boolean messageComplete(byte[] msg) {
        int braceCount = 0;
        int openBrace = 0;
        if (msg == null) {
            return false;
        }
        for (int i = 0; i < msg.length; ++i) {
            if (msg[i] == 123) {
                ++braceCount;
                ++openBrace;
                continue;
            }
            if (msg[i] != 125) continue;
            --braceCount;
        }
        if (braceCount == 0 && openBrace != 0) {
            logger.info("message complete: return true");
            return true;
        }
        return false;
    }
}

