/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.cli.monitor.hds;

import com.google.protobuf.GeneratedMessage;
import java.io.File;
import java.util.logging.Logger;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.LogUtil;

public class HDSMountCLI
extends AbstractEmulatorCLI {
    private static Logger logger = LogUtil.getECPLogger(HDSMountCLI.class).getLogger();
    @Argument(index=0, required=true)
    String hostPath;
    @Argument(index=1, required=true)
    String guestPath;

    public HDSMountCLI() {
        this.messageType = "hds";
    }

    @Override
    public int execute() {
        if (this.hostPath == null || this.hostPath.isEmpty() || this.guestPath == null || this.guestPath.isEmpty()) {
            OutputUtil.printHelpError("path is not specified.", this.help);
            return 25;
        }
        File file = new File(this.hostPath);
        if (!file.exists()) {
            OutputUtil.printHelpError("Wrong path : '" + this.hostPath + "'. The path does not exist", this.help);
            return 25;
        }
        if (!file.isDirectory()) {
            OutputUtil.printHelpError("Wrong path : '" + this.hostPath + "'. The path is not a directory.", this.help);
            return 25;
        }
        String msg = this.hostPath + "\n" + this.guestPath + "\n";
        MessageSender.getInstance().sendDeviceReq("hds", 100, 1, msg);
        this.startRunning();
        return 0;
    }

    @Override
    public void OnEventProcPB(String eventname, GeneratedMessage param) {
        Ecs.DeviceNtf ntf;
        if (param instanceof Ecs.DeviceNtf && 100 == (ntf = (Ecs.DeviceNtf)param).getGroup()) {
            int action = ntf.getAction();
            logger.info("HDSMountCLI action: " + action);
            if (action == 1) {
                OutputUtil.printOK();
                MessageSender.getInstance().sendDeviceReq("hds", 15, 99);
            } else if (action == 2) {
                this.returnValue = 128;
                OutputUtil.printFail();
            } else {
                logger.info("HDSMountCLI unknown action notification: " + action);
                this.returnValue = 128;
                OutputUtil.printFail();
            }
            this.stopRunning();
        }
    }
}

