#!/bin/sh

uname=$(uname)

PCs=$(find . -name '*.pc')
for pc in ${PCs}; do
    echo "${pc}"

    case "$uname" in
    Darwin*)
        LIBDIR=$(cd $(dirname "${pc}")/../..; pwd -P)
        sed -i "" '/^prefix=/c\
prefix='"${LIBDIR}"'
' ${pc}
    ;;
    *)
        LIBDIR=$(readlink -f $(dirname "${pc}")/../..)
        sed -i "/^prefix=/!b;c\prefix=${LIBDIR}" ${pc}
    ;;
    esac
done
