/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.tizen.emulator.skin.EmulatorFingers;
import org.tizen.emulator.skin.EmulatorSkin;
import org.tizen.emulator.skin.EmulatorSkinMain;
import org.tizen.emulator.skin.comm.ICommunicator;
import org.tizen.emulator.skin.comm.sock.data.KeyEventData;
import org.tizen.emulator.skin.comm.sock.data.MouseEventData;
import org.tizen.emulator.skin.comm.sock.data.StartData;
import org.tizen.emulator.skin.config.EmulatorConfig;
import org.tizen.emulator.skin.dbi.OptionType;
import org.tizen.emulator.skin.exception.ScreenShotException;
import org.tizen.emulator.skin.image.ImageRegistry;
import org.tizen.emulator.skin.info.SkinInformation;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.screenshot.ShmScreenShotWindow;
import org.tizen.emulator.skin.util.SkinUtil;
import org.tizen.emulator.skin.util.SwtUtil;

public class EmulatorShmSkin
extends EmulatorSkin {
    public static final String JNI_LIBRARY_FILE = "shared";
    public static final int DISPLAY_COLOR_DEPTH = 24;
    protected static int pressingX = -1;
    protected static int pressingY = -1;
    protected static int pressingOriginX = -1;
    protected static int pressingOriginY = -1;
    private static Logger logger = SkinLogger.getSkinLogger(EmulatorShmSkin.class).getLogger();
    private PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
    private BufferPainter bufferPainter;
    private Image imageCover;
    private int maxTouchPoint;
    private EmulatorFingers finger;
    private int multiTouchKey;
    private int multiTouchKeySub;

    public native int shmget(int var1, int var2);

    public native int shmdt();

    public native int getPixels(int[] var1);

    public EmulatorShmSkin(EmulatorConfig config, SkinInformation skinInfo, boolean isOnTop) {
        super(config, skinInfo, 0, isOnTop);
        this.maxTouchPoint = config.getArgInt("input.touch.maxpoint");
    }

    @Override
    protected void skinFinalize() {
        this.bufferPainter.stopRequest();
        this.finger.cleanupMultiTouchState();
        super.skinFinalize();
    }

    @Override
    public StartData initSkin() {
        this.initLayout();
        this.finger = new EmulatorFingers(this.maxTouchPoint, this.currentState, this.communicator, this.palette);
        this.multiTouchKey = SwtUtil.isMacPlatform() ? 0x400000 : 262144;
        this.multiTouchKeySub = 131072;
        this.initDisplay();
        int width = this.getEmulatorSkinState().getCurrentResolutionWidth();
        int height = this.getEmulatorSkinState().getCurrentResolutionHeight();
        int scale = this.getEmulatorSkinState().getCurrentScale();
        short rotation = this.getEmulatorSkinState().getCurrentRotationId();
        boolean isBlankGuide = true;
        OptionType option = this.config.getDbiContents().getOption();
        if (option != null) {
            isBlankGuide = option.getBlankGuide() == null ? true : option.getBlankGuide().isVisible();
        }
        StartData startData = new StartData(0L, width, height, scale, rotation, isBlankGuide);
        logger.info("" + startData);
        return startData;
    }

    private void initDisplay() {
        int shmkey = this.config.getArgInt("vm.baseport") + 2;
        logger.info("shmkey = " + shmkey);
        int result = this.shmget(shmkey, this.currentState.getCurrentResolutionWidth() * this.currentState.getCurrentResolutionHeight() * 4);
        logger.info("shmget native function returned " + result);
        if (result == 1) {
            logger.severe("Failed to get identifier of the shared memory segment.");
            SkinUtil.openMessage(this.shell, null, "Cannot launch this VM.\nFailed to get identifier of the shared memory segment.", 1, this.config);
            EmulatorSkinMain.terminateImmediately(-1);
        } else if (result == 2) {
            logger.severe("Failed to attach the shared memory segment.");
            SkinUtil.openMessage(this.shell, null, "Cannot launch this VM.\nFailed to attach the shared memory segment.", 1, this.config);
            EmulatorSkinMain.terminateImmediately(-1);
        }
        this.bufferPainter = new BufferPainter(this.palette, this.currentState.getCurrentResolutionWidth(), this.currentState.getCurrentResolutionHeight());
        this.lcdCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int screen_width = EmulatorShmSkin.this.lcdCanvas.getSize().x;
                int screen_height = EmulatorShmSkin.this.lcdCanvas.getSize().y;
                if (EmulatorShmSkin.this.imageCover != null) {
                    logger.info("draw cover image");
                    EmulatorShmSkin.this.drawImage(e.gc, EmulatorShmSkin.this.imageCover, screen_width, screen_height);
                    EmulatorShmSkin.this.imageCover = null;
                    return;
                }
                if (!EmulatorShmSkin.this.isOnInterpolation) {
                    e.gc.setInterpolation(0);
                } else {
                    e.gc.setInterpolation(2);
                }
                switch (EmulatorShmSkin.this.currentState.getCurrentRotationId()) {
                    case 1: {
                        e.gc.setTransform(EmulatorShmSkin.this.displayTransform);
                        e.gc.drawImage(EmulatorShmSkin.this.bufferPainter.imageFramebuffer, 0, 0, EmulatorShmSkin.this.bufferPainter.widthFB, EmulatorShmSkin.this.bufferPainter.heightFB, 0, 0, screen_height, screen_width);
                        e.gc.setTransform(null);
                        break;
                    }
                    case 2: {
                        e.gc.setTransform(EmulatorShmSkin.this.displayTransform);
                        e.gc.drawImage(EmulatorShmSkin.this.bufferPainter.imageFramebuffer, 0, 0, EmulatorShmSkin.this.bufferPainter.widthFB, EmulatorShmSkin.this.bufferPainter.heightFB, 0, 0, screen_width, screen_height);
                        e.gc.setTransform(null);
                        break;
                    }
                    case 3: {
                        e.gc.setTransform(EmulatorShmSkin.this.displayTransform);
                        e.gc.drawImage(EmulatorShmSkin.this.bufferPainter.imageFramebuffer, 0, 0, EmulatorShmSkin.this.bufferPainter.widthFB, EmulatorShmSkin.this.bufferPainter.heightFB, 0, 0, screen_height, screen_width);
                        e.gc.setTransform(null);
                        break;
                    }
                    default: {
                        e.gc.drawImage(EmulatorShmSkin.this.bufferPainter.imageFramebuffer, 0, 0, EmulatorShmSkin.this.bufferPainter.widthFB, EmulatorShmSkin.this.bufferPainter.heightFB, 0, 0, screen_width, screen_height);
                    }
                }
                if (EmulatorShmSkin.this.finger != null && EmulatorShmSkin.this.finger.getMultiTouchEnable() != 0) {
                    EmulatorShmSkin.this.finger.drawFingerPoints(e.gc);
                }
            }
        });
        this.bufferPainter.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDisplay() {
        this.bufferPainter.getPixelsFromSharedMemory();
        BufferPainter bufferPainter = this.bufferPainter;
        synchronized (bufferPainter) {
            this.bufferPainter.notify();
        }
    }

    @Override
    public void setSuitableTransform() {
        super.setSuitableTransform();
        if (this.finger != null) {
            this.finger.rearrangeFingerPoints(this.currentState.getCurrentResolutionWidth(), this.currentState.getCurrentResolutionHeight(), this.currentState.getCurrentScale(), this.currentState.getCurrentRotationId());
        }
    }

    @Override
    public void setCoverImage(final Image image) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                EmulatorShmSkin.this.imageCover = image;
                EmulatorShmSkin.this.lcdCanvas.redraw();
            }
        });
    }

    private void drawImage(GC gc, Image imageSrc, int widthDst, int heightDst) {
        int widthSrc = imageSrc.getImageData().width;
        int heightSrc = imageSrc.getImageData().height;
        int margin_w = widthDst - widthSrc;
        int margin_h = heightDst - heightSrc;
        int margin = Math.min(margin_w, margin_h);
        int widthScaledImage = widthSrc;
        int heightScaledImage = heightSrc;
        if (margin < 0) {
            widthScaledImage += margin;
            heightScaledImage += margin;
        }
        gc.drawImage(imageSrc, 0, 0, widthSrc, heightSrc, (widthDst - widthScaledImage) / 2, (heightDst - heightScaledImage) / 2, widthScaledImage, heightScaledImage);
    }

    @Override
    public void displayOn() {
        super.displayOn();
    }

    @Override
    public void displayOff() {
        super.displayOff();
    }

    @Override
    protected void mouseMoveDelivery(MouseEvent e, int eventType) {
        int[] geometry = SkinUtil.convertMouseGeometry(e.x, e.y, this.currentState.getCurrentResolutionWidth(), this.currentState.getCurrentResolutionHeight(), this.currentState.getCurrentScale(), this.currentState.getCurrentRotationId());
        if (this.finger.getMultiTouchEnable() == 1) {
            this.finger.maruFingerProcessing1(eventType, e.x, e.y, geometry[0], geometry[1]);
            this.lcdCanvas.redraw();
            return;
        }
        if (this.finger.getMultiTouchEnable() == 2) {
            this.finger.maruFingerProcessing2(eventType, e.x, e.y, geometry[0], geometry[1]);
            this.lcdCanvas.redraw();
            return;
        }
        MouseEventData mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), eventType, e.x, e.y, geometry[0], geometry[1], 0);
        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
    }

    @Override
    protected void mouseUpDelivery(MouseEvent e) {
        int[] geometry = SkinUtil.convertMouseGeometry(e.x, e.y, this.currentState.getCurrentResolutionWidth(), this.currentState.getCurrentResolutionHeight(), this.currentState.getCurrentScale(), this.currentState.getCurrentRotationId());
        logger.info("mouseUp in display x:" + geometry[0] + " y:" + geometry[1]);
        pressingY = -1;
        pressingX = -1;
        pressingOriginY = -1;
        pressingOriginX = -1;
        if (this.finger.getMultiTouchEnable() == 1) {
            logger.info("maruFingerProcessing 1");
            this.finger.maruFingerProcessing1(ICommunicator.MouseEventType.RELEASE.value(), e.x, e.y, geometry[0], geometry[1]);
            this.lcdCanvas.redraw();
            return;
        }
        if (this.finger.getMultiTouchEnable() == 2) {
            logger.info("maruFingerProcessing 2");
            this.finger.maruFingerProcessing2(ICommunicator.MouseEventType.RELEASE.value(), e.x, e.y, geometry[0], geometry[1]);
            this.lcdCanvas.redraw();
            return;
        }
        MouseEventData mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.RELEASE.value(), e.x, e.y, geometry[0], geometry[1], 0);
        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
    }

    @Override
    protected void mouseDownDelivery(MouseEvent e) {
        int[] geometry = SkinUtil.convertMouseGeometry(e.x, e.y, this.currentState.getCurrentResolutionWidth(), this.currentState.getCurrentResolutionHeight(), this.currentState.getCurrentScale(), this.currentState.getCurrentRotationId());
        logger.info("mouseDown in display x:" + geometry[0] + " y:" + geometry[1]);
        pressingX = geometry[0];
        pressingY = geometry[1];
        pressingOriginX = e.x;
        pressingOriginY = e.y;
        if (this.finger.getMultiTouchEnable() == 1) {
            logger.info("maruFingerProcessing 1");
            this.finger.maruFingerProcessing1(ICommunicator.MouseEventType.PRESS.value(), e.x, e.y, geometry[0], geometry[1]);
            this.lcdCanvas.redraw();
            return;
        }
        if (this.finger.getMultiTouchEnable() == 2) {
            logger.info("maruFingerProcessing 2");
            this.finger.maruFingerProcessing2(ICommunicator.MouseEventType.PRESS.value(), e.x, e.y, geometry[0], geometry[1]);
            this.lcdCanvas.redraw();
            return;
        }
        MouseEventData mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), e.x, e.y, geometry[0], geometry[1], 0);
        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
    }

    @Override
    protected void keyReleasedDelivery(int keyCode, int stateMask, int keyLocation, boolean remove) {
        if (this.finger.getMaxTouchPoint() > 1 && (keyCode == this.multiTouchKeySub || keyCode == this.multiTouchKey)) {
            int tempStateMask = stateMask & 0xFFF7FFFF;
            if (tempStateMask == (this.multiTouchKeySub | this.multiTouchKey)) {
                this.finger.setMultiTouchEnable(1);
                logger.info("enable multi-touch = mode 1");
            } else {
                this.finger.clearFingerSlot(false);
                this.updateDisplay();
                logger.info("disable multi-touch");
            }
        }
        KeyEventData keyEventData = new KeyEventData(ICommunicator.KeyEventType.RELEASED.value(), keyCode, stateMask, keyLocation);
        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_KEYBOARD_KEY_EVENT, keyEventData, false);
        if (remove) {
            this.removePressedKeyFromList(keyEventData);
        }
    }

    @Override
    protected void keyPressedDelivery(int keyCode, int stateMask, int keyLocation, boolean add) {
        if (this.finger.getMaxTouchPoint() > 1) {
            int tempStateMask = stateMask & 0xFFF7FFFF;
            if (keyCode == this.multiTouchKeySub && (tempStateMask & this.multiTouchKey) != 0 || keyCode == this.multiTouchKey && (tempStateMask & this.multiTouchKeySub) != 0) {
                this.finger.setMultiTouchEnable(2);
                if (pressingX != -1 && pressingY != -1 && pressingOriginX != -1 && pressingOriginY != -1) {
                    this.finger.addFingerPoint(pressingOriginX, pressingOriginY, pressingX, pressingY);
                    pressingY = -1;
                    pressingX = -1;
                    pressingOriginY = -1;
                    pressingOriginX = -1;
                }
                logger.info("enable multi-touch = mode 2");
            } else if (keyCode == this.multiTouchKeySub || keyCode == this.multiTouchKey) {
                this.finger.setMultiTouchEnable(1);
                if (pressingX != -1 && pressingY != -1 && pressingOriginX != -1 && pressingOriginY != -1) {
                    this.finger.addFingerPoint(pressingOriginX, pressingOriginY, pressingX, pressingY);
                    pressingY = -1;
                    pressingX = -1;
                    pressingOriginY = -1;
                    pressingOriginX = -1;
                }
                logger.info("enable multi-touch = mode 1");
            }
        }
        KeyEventData keyEventData = new KeyEventData(ICommunicator.KeyEventType.PRESSED.value(), keyCode, stateMask, keyLocation);
        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_KEYBOARD_KEY_EVENT, keyEventData, false);
        if (add) {
            this.addPressedKeyToList(keyEventData);
        }
    }

    @Override
    protected void openScreenShotWindow() {
        if (this.screenShotDialog != null) {
            logger.info("screenshot window was already opened");
            return;
        }
        this.screenShotDialog = new ShmScreenShotWindow(this, this.config, this.palette, this.imageRegistry.getIcon(ImageRegistry.IconName.SCREENSHOT));
        try {
            this.screenShotDialog.open();
        }
        catch (ScreenShotException ex) {
            this.screenShotDialog = null;
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            SkinUtil.openMessage(this.shell, null, "Fail to create a screen shot.", 1, this.config);
        }
        catch (Exception ex) {
            this.screenShotDialog = null;
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            SkinUtil.openMessage(this.shell, null, "ScreenShot is not ready.\nPlease wait until the emulator is completely boot up.", 8, this.config);
        }
    }

    static {
        try {
            System.loadLibrary(JNI_LIBRARY_FILE);
        }
        catch (UnsatisfiedLinkError e) {
            logger.severe("Failed to load a shared file.\n" + e);
            Shell temp = new Shell(Display.getDefault());
            MessageBox messageBox = new MessageBox(temp, 1);
            messageBox.setText("Emulator");
            messageBox.setMessage("Failed to load a JNI library file from " + System.getProperty("java.library.path") + ".\n\n" + e);
            messageBox.open();
            temp.dispose();
            EmulatorSkinMain.terminateImmediately(-1);
        }
    }

    class BufferPainter
    extends Thread {
        private Display display = Display.getDefault();
        private int widthFB;
        private int heightFB;
        private int sizeFramebuffer;
        private int[] arrayFramebuffer;
        private ImageData dataFramebuffer;
        private Image imageFramebuffer;
        private volatile boolean stopRequest;
        private Runnable runnable;
        private int intervalWait;

        public BufferPainter(PaletteData paletteDisplay, int widthFB, int heightFB) {
            this.widthFB = widthFB;
            this.heightFB = heightFB;
            this.sizeFramebuffer = widthFB * heightFB;
            this.arrayFramebuffer = new int[this.sizeFramebuffer];
            this.dataFramebuffer = new ImageData(widthFB, heightFB, 24, paletteDisplay);
            this.imageFramebuffer = new Image((Device)Display.getDefault(), this.dataFramebuffer);
            this.setName("BufferPainter");
            this.setDaemon(true);
            this.setWaitIntervalTime(0);
            this.runnable = new Runnable(){

                @Override
                public void run() {
                    if (!EmulatorShmSkin.this.lcdCanvas.isDisposed()) {
                        EmulatorShmSkin.this.lcdCanvas.redraw();
                    }
                }
            };
        }

        public synchronized void setWaitIntervalTime(int ms) {
            this.intervalWait = ms;
        }

        public synchronized int getWaitIntervalTime() {
            return this.intervalWait;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.stopRequest = false;
            while (!this.stopRequest) {
                BufferPainter bufferPainter = this;
                synchronized (bufferPainter) {
                    try {
                        this.wait(this.intervalWait);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        break;
                    }
                }
                if (this.stopRequest) break;
                if (this.display.isDisposed()) continue;
                this.display.asyncExec(this.runnable);
            }
            logger.info("PollFBThread is stopped");
            int result = EmulatorShmSkin.this.shmdt();
            logger.info("shmdt native function returned " + result);
        }

        public void getPixelsFromSharedMemory() {
            EmulatorShmSkin.this.getPixels(this.arrayFramebuffer);
            EmulatorShmSkin.this.communicator.sendToQEMU(ICommunicator.SendCommand.RESPONSE_DRAW_FRAME, null, true);
            this.dataFramebuffer.setPixels(0, 0, this.sizeFramebuffer, this.arrayFramebuffer, 0);
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    BufferPainter.this.imageFramebuffer.dispose();
                    BufferPainter.this.imageFramebuffer = new Image((Device)BufferPainter.this.display, BufferPainter.this.dataFramebuffer);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopRequest() {
            this.stopRequest = true;
            BufferPainter bufferPainter = EmulatorShmSkin.this.bufferPainter;
            synchronized (bufferPainter) {
                EmulatorShmSkin.this.bufferPainter.notify();
            }
        }
    }
}

