/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.tizen.emulator.skin.EmulatorSdlSkin;
import org.tizen.emulator.skin.EmulatorShmSkin;
import org.tizen.emulator.skin.EmulatorShutdownhook;
import org.tizen.emulator.skin.EmulatorSkin;
import org.tizen.emulator.skin.comm.sock.SocketCommunicator;
import org.tizen.emulator.skin.comm.sock.data.StartData;
import org.tizen.emulator.skin.config.EmulatorConfig;
import org.tizen.emulator.skin.dbi.EmulatorUI;
import org.tizen.emulator.skin.dbi.RotationType;
import org.tizen.emulator.skin.dbi.RotationsType;
import org.tizen.emulator.skin.exception.JaxbException;
import org.tizen.emulator.skin.image.ImageRegistry;
import org.tizen.emulator.skin.info.SkinInformation;
import org.tizen.emulator.skin.layout.rotation.SkinRotations;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.util.CocoaUtil;
import org.tizen.emulator.skin.util.IOUtil;
import org.tizen.emulator.skin.util.JaxbUtil;
import org.tizen.emulator.skin.util.SkinUtil;
import org.tizen.emulator.skin.util.StringUtil;
import org.tizen.emulator.skin.util.SwtUtil;

public class EmulatorSkinMain {
    public static final String SKINS_FOLDER = "skins";
    public static final String DEFAULT_SKIN_FOLDER = "mobile-general-3btn";
    public static final String SKIN_INFO_FILE_NAME = "info.ini";
    public static final String SKIN_PROPERTIES_FILE_NAME = ".skin.properties";
    public static final String CONFIG_PROPERTIES_FILE_NAME = ".skinconfig.properties";
    public static final String DBI_FILE_NAME = "default.dbi";
    private static Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String simpleMsg;
        if (SwtUtil.isMacPlatform()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Emulator");
            Display display = Display.getDefault();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    new CocoaUtil().removeTopMenuItems();
                }
            });
        }
        if ((simpleMsg = EmulatorSkinMain.getSimpleMsg(args)) != null) {
            Shell temp = new Shell(Display.getDefault());
            MessageBox messageBox = new MessageBox(temp, 1);
            messageBox.setText("Emulator");
            messageBox.setMessage(simpleMsg);
            messageBox.open();
            temp.dispose();
            return;
        }
        SocketCommunicator communicator = null;
        try {
            String vmPath = EmulatorSkinMain.getVmPath(args);
            if (StringUtil.isEmpty(vmPath)) {
                throw new IllegalArgumentException("vm.path in arguments is null.");
            }
            SkinLogger.init(SkinLogger.SkinLogLevel.DEBUG, vmPath);
            logger = SkinLogger.getSkinLogger(EmulatorSkinMain.class).getLogger();
            logger.info("!!! Start Emualtor Skin !!!");
            logger.info("java.version : " + System.getProperty("java.version"));
            logger.info("java vendor : " + System.getProperty("java.vendor"));
            logger.info("vm version : " + System.getProperty("java.vm.version"));
            logger.info("vm vendor : " + System.getProperty("java.vm.vendor"));
            logger.info("vm name : " + System.getProperty("java.vm.name"));
            logger.info("os name : " + System.getProperty("os.name"));
            logger.info("os arch : " + System.getProperty("os.arch"));
            logger.info("os version : " + System.getProperty("os.version"));
            logger.info("swt platform : " + SWT.getPlatform());
            logger.info("swt version : " + SWT.getVersion());
            logger.info("working directory : " + System.getProperty("user.dir"));
            Map<String, String> argsMap = EmulatorSkinMain.parseArgs(args);
            EmulatorConfig.validateArgs(argsMap);
            String argSkinPath = argsMap.get("skin.path");
            String skinPath = ".." + File.separator + SKINS_FOLDER + File.separator + DEFAULT_SKIN_FOLDER;
            if (argSkinPath == null || !new File(argSkinPath).isDirectory()) {
                logger.info("Emulator uses default skin path (" + skinPath + ") instead of invalid skin path (" + argSkinPath + ").");
            } else {
                skinPath = argSkinPath;
            }
            String skinInfoFilePath = skinPath + File.separator + SKIN_INFO_FILE_NAME;
            Properties skinInfoProperties = SkinUtil.loadProperties(skinInfoFilePath, false);
            if (null == skinInfoProperties) {
                logger.severe("Fail to load skin information file.");
                Shell temp = new Shell(Display.getDefault());
                MessageBox messageBox = new MessageBox(temp, 1);
                messageBox.setText("Emulator");
                messageBox.setMessage("Fail to load \"info.ini\" file\nCheck if the file is corrupted or missing from the following path.\n" + skinPath);
                messageBox.open();
                temp.dispose();
                EmulatorSkinMain.terminateImmediately(-1);
            }
            String skinInfoResolutionW = skinInfoProperties.getProperty("resolution.width");
            String skinInfoResolutionH = skinInfoProperties.getProperty("resolution.height");
            logger.info("skin ini : skin.name=" + skinInfoProperties.getProperty("skin.name"));
            logger.info("skin ini : resolution.width=" + skinInfoResolutionW);
            logger.info("skin ini : resolution.height=" + skinInfoResolutionH);
            logger.info("skin ini : manager.priority=" + skinInfoProperties.getProperty("manager.priority"));
            String skinPropFilePath = vmPath + File.separator + SKIN_PROPERTIES_FILE_NAME;
            Properties skinProperties = SkinUtil.loadProperties(skinPropFilePath, true);
            if (null == skinProperties) {
                logger.severe("Fail to load skin properties file.");
            }
            String configPropFilePath = vmPath + File.separator + CONFIG_PROPERTIES_FILE_NAME;
            Properties configProperties = SkinUtil.loadProperties(configPropFilePath, false);
            EmulatorConfig.validateSkinConfigProperties(configProperties);
            EmulatorSkinMain.initLog(argsMap, configProperties);
            EmulatorConfig.validateSkinProperties(skinProperties);
            boolean isGeneralSkin = false;
            if (skinInfoResolutionW.equalsIgnoreCase("all") || skinInfoResolutionH.equalsIgnoreCase("all")) {
                isGeneralSkin = true;
            }
            SkinInformation skinInfo = new SkinInformation(skinInfoProperties.getProperty("skin.name"), skinPath, isGeneralSkin);
            EmulatorUI dbiContents = EmulatorSkinMain.loadXMLForSkin(skinPath);
            if (null == dbiContents) {
                logger.severe("Fail to load dbi file.");
                Shell temp = new Shell(Display.getDefault());
                MessageBox messageBox = new MessageBox(temp, 1);
                messageBox.setText("Emulator");
                messageBox.setMessage("Fail to load \"default.dbi\" file\nCheck if the file is corrupted or missing from the following path.\n" + skinPath);
                messageBox.open();
                temp.dispose();
                EmulatorSkinMain.terminateImmediately(-1);
            }
            logger.info("dbi version : " + dbiContents.getDbiVersion());
            EmulatorConfig config = new EmulatorConfig(argsMap, dbiContents, skinProperties, skinPropFilePath, configProperties);
            ImageRegistry.getInstance().initialize(config, skinPath);
            boolean isOnTop = Boolean.parseBoolean(config.getSkinProperty("window.ontop", Boolean.FALSE.toString()));
            EmulatorSkin skin = null;
            if (config.getArgBoolean("display.shm")) {
                logger.info("maru_shm");
                skin = new EmulatorShmSkin(config, skinInfo, isOnTop);
            } else {
                logger.info("maru_sdl");
                skin = new EmulatorSdlSkin(config, skinInfo, isOnTop);
            }
            skin.isOnInterpolation = Boolean.parseBoolean(config.getSkinProperty("window.interpolation", Boolean.TRUE.toString()));
            int uid = config.getArgInt("uid");
            communicator = new SocketCommunicator(config, uid, skin);
            skin.setCommunicator(communicator);
            StartData startData = skin.initSkin();
            communicator.setInitialData(startData);
            Socket commSocket = communicator.getSocket();
            if (null != commSocket) {
                Runtime.getRuntime().addShutdownHook(new EmulatorShutdownhook(communicator));
                Thread communicatorThread = new Thread((Runnable)communicator, "communicator");
                communicatorThread.start();
                skin.open();
            } else {
                logger.severe("CommSocket is null.");
            }
        }
        catch (Throwable e) {
            if (null != logger) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                logger.warning("Shutdown skin process !!!");
            } else {
                e.printStackTrace();
                System.out.println("Shutdown skin process !!!");
            }
            Shell temp = new Shell(Display.getDefault());
            MessageBox messageBox = new MessageBox(temp, 1);
            messageBox.setText("Emulator");
            messageBox.setMessage(e.getMessage());
            messageBox.open();
            temp.dispose();
            if (null != communicator) {
                communicator.terminate();
            } else {
                EmulatorSkinMain.terminateImmediately(-1);
            }
        }
        finally {
            ImageRegistry.getInstance().dispose();
            Display.getDefault().close();
            SkinLogger.end();
        }
    }

    private static void initLog(Map<String, String> argsMap, Properties properties) {
        SkinLogger.SkinLogLevel[] values;
        String argLogLevel = argsMap.get("log.level");
        String configPropertyLogLevel = null;
        if (null != properties) {
            configPropertyLogLevel = (String)properties.get("log.level");
        }
        String logLevel = "";
        logLevel = !StringUtil.isEmpty(argLogLevel) ? argLogLevel : (!StringUtil.isEmpty(configPropertyLogLevel) ? configPropertyLogLevel : EmulatorConfig.DEFAULT_LOG_LEVEL.value());
        SkinLogger.SkinLogLevel skinLogLevel = EmulatorConfig.DEFAULT_LOG_LEVEL;
        for (SkinLogger.SkinLogLevel level : values = SkinLogger.SkinLogLevel.values()) {
            if (!level.value().equalsIgnoreCase(logLevel)) continue;
            skinLogLevel = level;
            break;
        }
        SkinLogger.setLevel(skinLogLevel.level());
    }

    private static String getSimpleMsg(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            String[] split = arg.split("=");
            if (1 >= split.length || !"simple.msg".equals(split[0].trim())) continue;
            return split[1].trim();
        }
        return null;
    }

    private static String getVmPath(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            String[] split = arg.split("=");
            if (1 >= split.length || !"vm.path".equals(split[0].trim())) continue;
            return split[1].trim();
        }
        return null;
    }

    private static Map<String, String> parseArgs(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            logger.info("arg[" + i + "] " + arg);
            String[] split = arg.split("=");
            if (1 < split.length) {
                String argKey = split[0].trim();
                String argValue = split[1].trim();
                map.put(argKey, argValue);
                continue;
            }
            logger.info("sinlge argv:" + arg);
        }
        logger.info("================= argsMap =====================");
        logger.info(((Object)map).toString());
        logger.info("===============================================");
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static EmulatorUI loadXMLForSkin(String skinPath) {
        EmulatorUI emulatorUI;
        FileInputStream fis;
        block8: {
            String dbiPath = skinPath + File.separator + DBI_FILE_NAME;
            logger.info("load dbi file from " + dbiPath);
            fis = null;
            emulatorUI = null;
            try {
                fis = new FileInputStream(dbiPath);
                logger.info("============ dbi contents ============");
                byte[] bytes = IOUtil.getBytes(fis);
                logger.info(new String(bytes, "UTF-8"));
                logger.info("=======================================");
                emulatorUI = JaxbUtil.unmarshal(bytes, EmulatorUI.class);
                RotationsType rotations = emulatorUI.getRotations();
                if (rotations != null) {
                    List<RotationType> rotationList = rotations.getRotation();
                    for (RotationType rotation : rotationList) {
                        SkinRotations.put(rotation);
                    }
                    break block8;
                }
                logger.severe("Fail to loading rotations element from XML");
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                IOUtil.close(fis);
            }
            catch (JaxbException e2) {
                logger.log(Level.SEVERE, e2.getMessage(), e2);
                {
                    catch (Throwable throwable) {
                        IOUtil.close(fis);
                        throw throwable;
                    }
                }
                IOUtil.close(fis);
            }
        }
        IOUtil.close(fis);
        return emulatorUI;
    }

    public static void terminateImmediately(int exit) {
        if (logger != null) {
            logger.info("shutdown immediately! exit value : " + exit);
        }
        System.exit(exit);
    }
}

