/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.comm.sock.data;

import java.io.IOException;
import org.tizen.emulator.skin.comm.sock.data.AbstractSendData;

public class StartData
extends AbstractSendData {
    private long displayHandleId;
    private int displayWidth;
    private int displayHeight;
    private int scale;
    private short rotation;
    private boolean isBlankGuide;

    public StartData(long displayHandleId, int displayWidth, int displayHeight, int scale, short rotation, boolean isBlankGuide) {
        this.displayHandleId = displayHandleId;
        this.displayWidth = displayWidth;
        this.displayHeight = displayHeight;
        this.scale = scale;
        this.rotation = rotation;
        this.isBlankGuide = isBlankGuide;
    }

    @Override
    protected void write() throws IOException {
        this.writeLong(this.displayHandleId);
        this.writeInt(this.displayWidth);
        this.writeInt(this.displayHeight);
        this.writeInt(this.scale);
        this.writeShort(this.rotation);
        if (this.isBlankGuide) {
            this.writeShort(1);
        } else {
            this.writeShort(0);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("StartData [displayHandleId=");
        builder.append(this.displayHandleId);
        builder.append(", display size " + this.displayWidth + "x" + this.displayHeight);
        builder.append(", scale=");
        builder.append(this.scale);
        builder.append(", rotation=");
        builder.append(this.rotation);
        builder.append(", blank guide=");
        builder.append(this.isBlankGuide);
        builder.append("]");
        return builder.toString();
    }
}

