/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.tizen.emulator.skin.dbi.EmulatorUI;
import org.tizen.emulator.skin.exception.ConfigException;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.util.IOUtil;
import org.tizen.emulator.skin.util.SkinUtil;
import org.tizen.emulator.skin.util.StringUtil;

public class EmulatorConfig {
    public static final String INVALID_OPTION_MESSAGE = "An invalid option have caused the error.\n";
    public static final int DEFAULT_WINDOW_SCALE = 50;
    public static final int MIN_SCALE_FACTOR = 25;
    public static final int MAX_SCALE_FACTOR = 200;
    public static final int DEFAULT_WINDOW_X = 50;
    public static final int DEFAULT_WINDOW_Y = 50;
    public static final SkinLogger.SkinLogLevel DEFAULT_LOG_LEVEL = SkinLogger.SkinLogLevel.DEBUG;
    private static Logger logger = SkinLogger.getSkinLogger(EmulatorConfig.class).getLogger();
    private Map<String, String> args;
    private EmulatorUI dbiContents;
    private Properties skinProperties;
    private Properties configProperties;
    private String skinPropertiesFilePath;

    public EmulatorConfig(Map<String, String> args, EmulatorUI dbiContents, Properties skinProperties, String skinPropertiesFilePath, Properties configProperties) {
        this.args = args;
        this.dbiContents = dbiContents;
        this.skinProperties = skinProperties;
        this.skinPropertiesFilePath = skinPropertiesFilePath;
        this.configProperties = configProperties;
        if (null == configProperties) {
            this.configProperties = new Properties();
        }
        String strVersion = this.loadSDKVersion();
        logger.info("SDK version : " + strVersion);
        this.setSkinProperty("sdk.version-name", strVersion);
    }

    private String loadSDKVersion() {
        String strVersion = "Undefined";
        String filePath = SkinUtil.getSdkVersionFilePath();
        Properties properties = SkinUtil.loadProperties(filePath, false);
        if (properties != null) {
            strVersion = (String)properties.get("TIZEN_SDK_VERSION");
            if (StringUtil.isEmpty(strVersion)) {
                strVersion = "Undefined";
            }
        } else {
            logger.warning("cannot read version from " + filePath);
        }
        return strVersion;
    }

    public static void validateArgs(Map<String, String> args) throws ConfigException {
        String msg;
        if (null == args) {
            String msg2 = INVALID_OPTION_MESSAGE;
            throw new ConfigException(msg2);
        }
        String value = null;
        value = args.get("uid");
        if (value != null) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                String msg3 = "An invalid option have caused the error.\nThe 'uid' argument is not numeric.\n: " + value;
                throw new ConfigException(msg3);
            }
        }
        if ((value = args.get("vm.skinport")) != null) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                String msg4 = "An invalid option have caused the error.\nThe 'vm.skinport' argument is not numeric.\n: " + value;
                throw new ConfigException(msg4);
            }
        } else {
            String msg5 = "An invalid option have caused the error.\nThe 'vm.skinport' is required argument.";
            throw new ConfigException(msg5);
        }
        value = args.get("resolution");
        if (value != null) {
            String[] splitted = value.split("x");
            if (splitted.length == 2) {
                args.put("width", splitted[0]);
                args.put("height", splitted[1]);
            } else {
                String msg6 = "An invalid option have caused the error.\nThe 'resolution' argument is invalid.\n: " + value;
                throw new ConfigException(msg6);
            }
        }
        if ((value = args.get("width")) != null) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                String msg7 = "An invalid option have caused the error.\nThe 'width' argument is not numeric.\n: " + value;
                throw new ConfigException(msg7);
            }
        } else {
            msg = "An invalid option have caused the error.\nThe 'width' is required argument.";
            throw new ConfigException(msg);
        }
        value = args.get("height");
        if (value != null) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                String msg8 = "An invalid option have caused the error.\nThe 'height' argument is not numeric.\n: " + value;
                throw new ConfigException(msg8);
            }
        } else {
            msg = "An invalid option have caused the error.\nThe 'height' is required argument.";
            throw new ConfigException(msg);
        }
    }

    public static void validateSkinProperties(Properties skinProperties) throws ConfigException {
        String msg;
        if (null == skinProperties || 0 == skinProperties.size()) {
            return;
        }
        if (skinProperties.containsKey("window.x")) {
            String window_x = skinProperties.getProperty("window.x");
            try {
                Integer.parseInt(window_x);
            }
            catch (NumberFormatException e) {
                msg = "window.x in .skin.properties is not numeric : " + window_x;
                logger.warning(msg);
                skinProperties.remove("window.x");
            }
        }
        if (skinProperties.containsKey("window.y")) {
            String window_y = skinProperties.getProperty("window.y");
            try {
                Integer.parseInt(window_y);
            }
            catch (NumberFormatException e) {
                msg = "window.y in .skin.properties is not numeric. : " + window_y;
                logger.warning(msg);
                skinProperties.remove("window.y");
            }
        }
        if (skinProperties.containsKey("window.rotate")) {
            String rotation = skinProperties.getProperty("window.rotate");
            try {
                Integer.parseInt(rotation);
            }
            catch (NumberFormatException e) {
                msg = "window.rotate in .skin.properties is not numeric. : " + rotation;
                logger.warning(msg);
                skinProperties.remove("window.rotate");
            }
        }
        if (skinProperties.containsKey("window.scale")) {
            String scale = skinProperties.getProperty("window.scale");
            try {
                Integer.parseInt(scale);
            }
            catch (NumberFormatException e) {
                msg = "window.scale in .skin.properties is not numeric. : " + scale;
                logger.warning(msg);
                skinProperties.remove("window.scale");
            }
        }
        if (skinProperties.containsKey("window.keywindow.position")) {
            String position = skinProperties.getProperty("window.keywindow.position");
            try {
                Integer.parseInt(position);
            }
            catch (NumberFormatException e) {
                msg = "window.keywindow.position in .skin.properties is not numeric. : " + position;
                logger.warning(msg);
                skinProperties.remove("window.keywindow.position");
            }
        }
    }

    public static void validateSkinConfigProperties(Properties skinConfigProperties) throws ConfigException {
        if (null == skinConfigProperties || 0 == skinConfigProperties.size()) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSkinProperties() {
        File file = new File(this.skinPropertiesFilePath);
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    return;
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Fail to create skin properties file.", e);
                return;
            }
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            this.skinProperties.store(fos, "Automatically generated by emulator skin.");
        }
        catch (IOException e) {
            try {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fos);
                throw throwable;
            }
            IOUtil.close(fos);
        }
        IOUtil.close(fos);
    }

    public EmulatorUI getDbiContents() {
        return this.dbiContents;
    }

    public String getArg(String argKey) {
        return this.args.get(argKey);
    }

    public String getArg(String argKey, String defaultValue) {
        String arg = this.args.get(argKey);
        if (StringUtil.isEmpty(arg)) {
            return defaultValue;
        }
        return arg;
    }

    public int getArgInt(String argKey) {
        String arg = this.args.get(argKey);
        if (StringUtil.isEmpty(arg)) {
            return 0;
        }
        return Integer.parseInt(arg);
    }

    public int getArgInt(String argKey, int defaultValue) {
        String arg = this.args.get(argKey);
        if (StringUtil.isEmpty(arg)) {
            return defaultValue;
        }
        return Integer.parseInt(arg);
    }

    public boolean getArgBoolean(String argKey) {
        String arg = this.args.get(argKey);
        return Boolean.parseBoolean(arg);
    }

    public boolean getArgBoolean(String argKey, boolean defaultValue) {
        String arg = this.args.get(argKey);
        if (StringUtil.isEmpty(arg)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(arg);
    }

    public int getValidResolutionWidth() {
        int storedValue = this.getArgInt("width", 1);
        if (storedValue > 0) {
            return storedValue;
        }
        return 1;
    }

    public int getValidResolutionHeight() {
        int storedValue = this.getArgInt("height", 1);
        if (storedValue > 0) {
            return storedValue;
        }
        return 1;
    }

    private void setProperty(Properties properties, String key, String value) {
        properties.put(key, value);
    }

    private void setProperty(Properties properties, String key, int value) {
        properties.put(key, Integer.toString(value));
    }

    private String getProperty(Properties properties, String key) {
        return properties.getProperty(key);
    }

    private String getProperty(Properties properties, String key, String defaultValue) {
        String property = properties.getProperty(key);
        if (StringUtil.isEmpty(property)) {
            return defaultValue;
        }
        return property;
    }

    private int getPropertyInt(Properties properties, String key) {
        return Integer.parseInt(properties.getProperty(key));
    }

    private int getPropertyInt(Properties properties, String key, int defaultValue) {
        String property = properties.getProperty(key);
        if (StringUtil.isEmpty(property)) {
            return defaultValue;
        }
        return Integer.parseInt(property);
    }

    private short getPropertyShort(Properties properties, String key) {
        return Short.parseShort(properties.getProperty(key));
    }

    private short getPropertyShort(Properties properties, String key, short defaultValue) {
        String property = properties.getProperty(key);
        if (StringUtil.isEmpty(property)) {
            return defaultValue;
        }
        return Short.parseShort(property);
    }

    public String getSkinProperty(String key) {
        return this.getProperty(this.skinProperties, key);
    }

    public String getSkinProperty(String key, String defaultValue) {
        return this.getProperty(this.skinProperties, key, defaultValue);
    }

    public int getSkinPropertyInt(String key) {
        return this.getPropertyInt(this.skinProperties, key);
    }

    public int getSkinPropertyInt(String key, int defaultValue) {
        return this.getPropertyInt(this.skinProperties, key, defaultValue);
    }

    public short getSkinPropertyShort(String key) {
        return this.getPropertyShort(this.skinProperties, key);
    }

    public short getSkinPropertyShort(String key, short defaultValue) {
        return this.getPropertyShort(this.skinProperties, key, defaultValue);
    }

    public void setSkinProperty(String key, String value) {
        this.setProperty(this.skinProperties, key, value);
    }

    public void setSkinProperty(String key, int value) {
        this.setProperty(this.skinProperties, key, value);
    }

    public int getValidWindowX() {
        int vmIndex = this.getArgInt("vm.baseport") % 100;
        int storedValue = this.getSkinPropertyInt("window.x", 50 + vmIndex);
        Rectangle monitorBound = Display.getDefault().getBounds();
        logger.info("current display size : " + monitorBound);
        int xx = 0;
        if (storedValue < monitorBound.x) {
            xx = monitorBound.x;
            logger.info("WINDOW_X = " + storedValue + " -> " + xx);
        } else if (storedValue > monitorBound.x + monitorBound.width - 30) {
            xx = monitorBound.x + monitorBound.width - 100;
            logger.info("WINDOW_X = " + storedValue + " -> " + xx);
        } else {
            xx = storedValue;
            logger.info("WINDOW_X = " + xx);
        }
        return xx;
    }

    public int getValidWindowY() {
        int vmIndex = this.getArgInt("vm.baseport") % 100;
        int storedValue = this.getSkinPropertyInt("window.y", 50 + vmIndex);
        Rectangle monitorBound = Display.getDefault().getBounds();
        logger.info("current display size : " + monitorBound);
        int yy = 0;
        if (storedValue < monitorBound.y) {
            yy = monitorBound.y;
            logger.info("WINDOW_Y = " + storedValue + " -> " + yy);
        } else if (storedValue > monitorBound.y + monitorBound.height - 30) {
            yy = monitorBound.y + monitorBound.height - 100;
            logger.info("WINDOW_Y = " + storedValue + " -> " + yy);
        } else {
            yy = storedValue;
            logger.info("WINDOW_Y = " + yy);
        }
        return yy;
    }

    public int getValidScale() {
        int storedScale = this.getSkinPropertyInt("window.scale", 50);
        if (storedScale >= 25 && storedScale <= 200) {
            return storedScale;
        }
        return 50;
    }

    public String getConfigProperty(String key) {
        return this.getProperty(this.configProperties, key);
    }

    public String getConfigProperty(String key, String defaultValue) {
        return this.getProperty(this.configProperties, key, defaultValue);
    }

    public int getConfigPropertyInt(String key, int defaultValue) {
        return this.getPropertyInt(this.configProperties, key, defaultValue);
    }

    public static interface SkinInfoConstants {
        public static final String SDK_VERSION_NAME = "sdk.version-name";
        public static final String SKIN_NAME = "skin.name";
        public static final String RESOLUTION_WIDTH = "resolution.width";
        public static final String RESOLUTION_HEIGHT = "resolution.height";
        public static final String MANAGER_PRIORITY = "manager.priority";
    }

    public static interface ConfigPropertiesConstants {
        public static final String HEART_BEAT_IGNORE = "hb.ignore";
        public static final String LOG_LEVEL = "log.level";
    }

    public static interface SkinPropertiesConstants {
        public static final String WINDOW_X = "window.x";
        public static final String WINDOW_Y = "window.y";
        public static final String WINDOW_ROTATION = "window.rotate";
        public static final String WINDOW_SCALE = "window.scale";
        public static final String WINDOW_ONTOP = "window.ontop";
        public static final String WINDOW_INTERPOLATION = "window.interpolation";
        public static final String KEYWINDOW_POSITION = "window.keywindow.position";
    }

    public static interface ArgsConstants {
        public static final String SIMPLE_MESSAGE = "simple.msg";
        public static final String UID = "uid";
        public static final String RESOLUTION = "resolution";
        public static final String RESOLUTION_WIDTH = "width";
        public static final String RESOLUTION_HEIGHT = "height";
        public static final String HEART_BEAT_IGNORE = "hb.ignore";
        public static final String LOG_LEVEL = "log.level";
        public static final String VM_PATH = "vm.path";
        public static final String VM_SKIN_PORT = "vm.skinport";
        public static final String VM_BASE_PORT = "vm.baseport";
        public static final String SKIN_PATH = "skin.path";
        public static final String DISPLAY_SHM = "display.shm";
        public static final String INPUT_MOUSE = "input.mouse";
        public static final String INPUT_TOUCHSCREEN = "input.touch";
        public static final String INPUT_TOUCH_MAXPOINT = "input.touch.maxpoint";
        public static final String PROXY_ADDR = "proxy.addr";
        public static final String PROXY_PORT = "proxy.port";
    }
}

