/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.custom;

import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class CustomButton
extends Canvas {
    private int mouse = 0;
    private boolean hit = false;
    private Image[] imageButton = new Image[3];
    private int width;
    private int height;
    private String text;
    private int textPositionX;
    private int textPositionY;
    private static Color white;
    private static Color gray;

    public CustomButton(Composite parent, int style, Image imageNormal, Image imageHover, Image imagePushed) {
        super(parent, style);
        this.imageButton[0] = imageNormal;
        this.imageButton[1] = imageHover;
        this.imageButton[2] = imagePushed;
        this.width = imageNormal.getImageData().width;
        this.height = imageNormal.getImageData().height;
        this.text = null;
        this.textPositionX = this.width / 2;
        this.textPositionY = this.height / 2;
        white = Display.getCurrent().getSystemColor(1);
        gray = Display.getCurrent().getSystemColor(15);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                switch (CustomButton.this.mouse) {
                    case 0: {
                        if (CustomButton.this.imageButton[0] != null) {
                            e.gc.drawImage(CustomButton.this.imageButton[0], 0, 0);
                        }
                        if (CustomButton.this.text == null) break;
                        e.gc.setForeground(white);
                        e.gc.drawText(CustomButton.this.text, CustomButton.this.textPositionX, CustomButton.this.textPositionY, true);
                        break;
                    }
                    case 1: {
                        if (CustomButton.this.imageButton[1] != null) {
                            e.gc.drawImage(CustomButton.this.imageButton[1], 0, 0);
                        }
                        if (CustomButton.this.text == null) break;
                        e.gc.setForeground(white);
                        e.gc.drawText(CustomButton.this.text, CustomButton.this.textPositionX, CustomButton.this.textPositionY, true);
                        break;
                    }
                    case 2: {
                        if (CustomButton.this.imageButton[2] != null) {
                            e.gc.drawImage(CustomButton.this.imageButton[2], 0, 0);
                        }
                        if (CustomButton.this.text == null) break;
                        e.gc.setForeground(gray);
                        e.gc.drawText(CustomButton.this.text, CustomButton.this.textPositionX, CustomButton.this.textPositionY, true);
                        break;
                    }
                }
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (!CustomButton.this.hit) {
                    return;
                }
                CustomButton.this.mouse = 2;
                if (e.x < 0 || e.y < 0 || e.x > CustomButton.this.getBounds().width || e.y > CustomButton.this.getBounds().height) {
                    CustomButton.this.mouse = 0;
                }
                CustomButton.this.redraw();
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                CustomButton.this.mouse = 1;
                CustomButton.this.redraw();
            }

            public void mouseExit(MouseEvent e) {
                CustomButton.this.mouse = 0;
                CustomButton.this.redraw();
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CustomButton.this.hit = true;
                CustomButton.this.mouse = 2;
                CustomButton.this.redraw();
            }

            public void mouseUp(MouseEvent e) {
                CustomButton.this.hit = false;
                CustomButton.this.mouse = 1;
                if (e.x < 0 || e.y < 0 || e.x > CustomButton.this.getBounds().width || e.y > CustomButton.this.getBounds().height) {
                    CustomButton.this.mouse = 0;
                }
                CustomButton.this.redraw();
                if (CustomButton.this.mouse == 1) {
                    CustomButton.this.notifyListeners(13, new Event());
                }
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.character == ' ') {
                    Event event = new Event();
                    CustomButton.this.notifyListeners(13, event);
                }
            }
        });
    }

    public void setText(String textValue) {
        Point textSize;
        if (textValue == null || textValue.isEmpty()) {
            return;
        }
        GC gc = new GC((Drawable)this);
        Point originalSize = textSize = gc.textExtent(textValue);
        while (textSize.x >= this.width - 10) {
            textValue = textValue.substring(0, textValue.length() - 1);
            textSize = gc.textExtent(textValue);
        }
        if (originalSize.x != textSize.x) {
            textValue = textValue.substring(0, textValue.length() - 1);
            textValue = textValue + "..";
            textSize = gc.textExtent(textValue);
        }
        gc.dispose();
        this.text = textValue;
        this.textPositionX -= textSize.x / 2;
        if (this.textPositionX < 0) {
            this.textPositionX = 0;
        }
        this.textPositionY -= textSize.y / 2;
        if (this.textPositionY < 0) {
            this.textPositionY = 0;
        }
    }

    public String getText() {
        return this.text;
    }

    public Point getImageSize() {
        return new Point(this.imageButton[0].getImageData().width, this.imageButton[0].getImageData().height);
    }
}

