/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.custom;

import java.util.logging.Logger;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.emulator.skin.log.SkinLogger;

public class SkinWindow {
    protected Logger logger = SkinLogger.getSkinLogger(SkinWindow.class).getLogger();
    protected Shell shell;
    protected Shell parent;
    private int dockPosition;

    public SkinWindow(Shell parent, int dockPosition) {
        this.parent = parent;
        this.dockPosition = dockPosition;
    }

    public Shell getShell() {
        return this.shell;
    }

    public void open(int dockValue) {
        if (this.shell.isDisposed()) {
            return;
        }
        this.dock(dockValue, true, true);
        this.shell.open();
    }

    public void dock(int dockValue, boolean correction, boolean enableLogger) {
        if (this.shell.isDisposed()) {
            return;
        }
        int x = 0;
        int y = 0;
        Rectangle monitorBounds = Display.getDefault().getBounds();
        Rectangle parentBounds = this.parent.getBounds();
        Rectangle childBounds = this.shell.getBounds();
        if (enableLogger) {
            this.logger.info("host monitor display bounds : " + monitorBounds);
            this.logger.info("current parent shell bounds : " + parentBounds);
            this.logger.info("current child shell bounds : " + childBounds);
        }
        this.dockPosition = dockValue;
        if (this.dockPosition == 0) {
            this.logger.info("undock");
            return;
        }
        if (this.dockPosition == 131200) {
            x = parentBounds.x + parentBounds.width;
            y = parentBounds.y;
        } else if (this.dockPosition == 132096) {
            x = parentBounds.x + parentBounds.width;
            y = parentBounds.y + parentBounds.height - childBounds.height;
        } else if (this.dockPosition == 0x1004000) {
            x = parentBounds.x - childBounds.width;
            y = parentBounds.y + parentBounds.height / 2 - childBounds.height / 2;
        } else if (this.dockPosition == 16512) {
            x = parentBounds.x - childBounds.width;
            y = parentBounds.y;
        } else if (this.dockPosition == 17408) {
            x = parentBounds.x - childBounds.width;
            y = parentBounds.y + parentBounds.height - childBounds.height;
        } else {
            x = parentBounds.x + parentBounds.width;
            y = parentBounds.y + parentBounds.height / 2 - childBounds.height / 2;
        }
        if (correction) {
            int shift = monitorBounds.x + monitorBounds.width - (x + childBounds.width);
            if (shift < 0) {
                x += shift;
                this.parent.setLocation(parentBounds.x + shift, parentBounds.y);
            }
            if ((shift = monitorBounds.x - x) > 0) {
                x += shift;
                this.parent.setLocation(parentBounds.x + shift, parentBounds.y);
            }
        }
        this.shell.setLocation(x, y);
    }

    public void redock(boolean correction, boolean enableLogger) {
        this.dock(this.getDockPosition(), correction, enableLogger);
    }

    public int getDockPosition() {
        return this.dockPosition;
    }
}

