/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.dialog;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.emulator.skin.dialog.SkinDialog;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.util.IOUtil;
import org.tizen.emulator.skin.util.StringUtil;

public class LicenseDialog
extends SkinDialog {
    public static final String LICENSE_FILE_PATH = "../license/Open_Source_Announcement.txt";
    private Logger logger = SkinLogger.getSkinLogger(LicenseDialog.class).getLogger();

    public LicenseDialog(Shell parent, String title) {
        super(parent, 68720, title);
    }

    @Override
    protected Composite createArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Text text = new Text(composite, 2818);
        GridData gridData = new GridData(4, 4, true, true);
        text.setLayoutData((Object)gridData);
        text.setEditable(false);
        text.setBackground(this.shell.getDisplay().getSystemColor(1));
        String license = StringUtil.nvl(this.getLicense());
        text.setText(license);
        return composite;
    }

    @Override
    protected void setShellSize() {
        this.shell.setSize(647, 400);
    }

    @Override
    protected void createButtons(Composite parent) {
        super.createButtons(parent);
        Button okButton = this.createButton(parent, "        OK        ");
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 131072;
        okButton.setLayoutData((Object)gd);
        okButton.setFocus();
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseDialog.this.shell.close();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLicense() {
        FileInputStream fis = null;
        String string = "";
        try {
            fis = new FileInputStream(LICENSE_FILE_PATH);
            try {
                byte[] bytes = IOUtil.getBytes(fis);
                string = new String(bytes, "UTF-8");
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                string = "File control error.";
            }
        }
        catch (FileNotFoundException e) {
            try {
                string = "There is no license info.";
            }
            catch (Throwable throwable) {
                IOUtil.close(fis);
                throw throwable;
            }
            IOUtil.close(fis);
        }
        IOUtil.close(fis);
        return string;
    }

    @Override
    protected void close() {
        this.logger.info("close the license dialog");
    }
}

