/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.image;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.util.IOUtil;

public class GeneralKeyWindowImageRegistry {
    public static final String KEYWINDOW_FOLDER = "key-window";
    private static Logger logger = SkinLogger.getSkinLogger(GeneralKeyWindowImageRegistry.class).getLogger();
    private Display display;
    private Map<String, Image> keyWindowImageMap;

    public GeneralKeyWindowImageRegistry(Display display) {
        this.display = display;
        this.keyWindowImageMap = new HashMap<String, Image>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getKeyWindowImage(GeneralKeyWindowImageName name) {
        if (this.keyWindowImageMap.size() == 0) {
            GeneralKeyWindowImageName[] values;
            ClassLoader classLoader = this.getClass().getClassLoader();
            InputStream is = null;
            for (GeneralKeyWindowImageName value : values = GeneralKeyWindowImageName.values()) {
                String imageName = value.getName();
                String imagePath = "images/key-window/" + imageName;
                try {
                    is = classLoader.getResourceAsStream(imagePath);
                    if (null != is) {
                        logger.fine("KeyWindow image is loaded : " + imagePath);
                        this.keyWindowImageMap.put(imageName, new Image((Device)this.display, is));
                        continue;
                    }
                    logger.severe("missing image : " + imagePath);
                }
                finally {
                    IOUtil.close(is);
                }
            }
        }
        return this.keyWindowImageMap.get(name.getName());
    }

    public void dispose() {
        logger.info("dispose");
        if (null != this.keyWindowImageMap) {
            Image image2 = null;
            Collection<Image> images = this.keyWindowImageMap.values();
            for (Image image2 : images) {
                if (image2 == null) continue;
                image2.dispose();
            }
        }
    }

    public static enum GeneralKeyWindowImageName {
        KEYWINDOW_PATCH_LT("LT.png"),
        KEYWINDOW_PATCH_T("T.png"),
        KEYWINDOW_PATCH_RT("RT.png"),
        KEYWINDOW_PATCH_L("L.png"),
        KEYWINDOW_PATCH_R("R.png"),
        KEYWINDOW_PATCH_LB("LB.png"),
        KEYWINDOW_PATCH_B("B.png"),
        KEYWINDOW_PATCH_RB("RB.png"),
        KEYBUTTON_NORMAL("keybutton_nml.png"),
        KEYBUTTON_HOVER("keybutton_hover.png"),
        KEYBUTTON_PUSHED("keybutton_pushed.png"),
        SCROLL_UPBUTTON_NORMAL("scroll_button_up_nml.png"),
        SCROLL_UPBUTTON_HOVER("scroll_button_up_hover.png"),
        SCROLL_UPBUTTON_PUSHED("scroll_button_up_pushed.png"),
        SCROLL_DOWNBUTTON_NORMAL("scroll_button_down_nml.png"),
        SCROLL_DOWNBUTTON_HOVER("scroll_button_down_hover.png"),
        SCROLL_DOWNBUTTON_PUSHED("scroll_button_down_pushed.png"),
        SCROLL_THUMB("scroll_thumb.png"),
        SCROLL_SHAFT("scroll_back.png");

        private String name;

        private GeneralKeyWindowImageName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

