/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.image;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.tizen.emulator.skin.keywindow.dbi.ImageListType;
import org.tizen.emulator.skin.keywindow.dbi.KeyWindowUI;
import org.tizen.emulator.skin.log.SkinLogger;

public class SpecialKeyWindowImageRegistry {
    private static Logger logger = SkinLogger.getSkinLogger(SpecialKeyWindowImageRegistry.class).getLogger();
    private Display display;
    private String imagePath;
    private KeyWindowUI dbiContents;
    private Map<String, Image> keyWindowImageMap;

    public SpecialKeyWindowImageRegistry(Display display, KeyWindowUI dbiContents, String imagePath) {
        this.display = display;
        this.imagePath = imagePath;
        this.dbiContents = dbiContents;
        this.keyWindowImageMap = new HashMap<String, Image>();
    }

    private String makeKey(Short id, SpecailKeyWindowImageType imageType) {
        return id + ":" + imageType.ordinal();
    }

    public Image getKeyWindowImage(Short id, SpecailKeyWindowImageType imageType) {
        Image image = this.keyWindowImageMap.get(this.makeKey(id, imageType));
        if (image == null) {
            ImageListType imageList = this.dbiContents.getImageList();
            if (imageList == null) {
                return null;
            }
            logger.info("get Key Window image from " + this.imagePath);
            String mainImage = imageList.getMainImage();
            String keyPressedImage = imageList.getKeyPressedImage();
            String mainKey = this.makeKey(id, SpecailKeyWindowImageType.SPECIAL_IMAGE_TYPE_NORMAL);
            this.keyWindowImageMap.put(mainKey, new Image((Device)this.display, this.imagePath + File.separator + mainImage));
            String pressedKey = this.makeKey(id, SpecailKeyWindowImageType.SPECIAL_IMAGE_TYPE_PRESSED);
            this.keyWindowImageMap.put(pressedKey, new Image((Device)this.display, this.imagePath + File.separator + keyPressedImage));
            image = this.keyWindowImageMap.get(this.makeKey(id, imageType));
        }
        return image;
    }

    public void dispose() {
        logger.info("dispose");
        if (null != this.keyWindowImageMap) {
            Image image2 = null;
            Collection<Image> images = this.keyWindowImageMap.values();
            for (Image image2 : images) {
                if (image2 == null) continue;
                image2.dispose();
            }
        }
    }

    public static enum SpecailKeyWindowImageType {
        SPECIAL_IMAGE_TYPE_NORMAL,
        SPECIAL_IMAGE_TYPE_PRESSED;

    }
}

