/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.layout;

import java.util.logging.Logger;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.tizen.emulator.skin.EmulatorSkin;
import org.tizen.emulator.skin.EmulatorSkinMain;
import org.tizen.emulator.skin.comm.ICommunicator;
import org.tizen.emulator.skin.comm.sock.SocketCommunicator;
import org.tizen.emulator.skin.comm.sock.data.KeyEventData;
import org.tizen.emulator.skin.config.EmulatorConfig;
import org.tizen.emulator.skin.custom.CustomProgressBar;
import org.tizen.emulator.skin.dbi.DisplayType;
import org.tizen.emulator.skin.dbi.RegionType;
import org.tizen.emulator.skin.image.ImageRegistry;
import org.tizen.emulator.skin.image.ProfileSkinImageRegistry;
import org.tizen.emulator.skin.info.EmulatorSkinState;
import org.tizen.emulator.skin.layout.HWKey;
import org.tizen.emulator.skin.layout.HWKeyRegion;
import org.tizen.emulator.skin.layout.ISkinComposer;
import org.tizen.emulator.skin.layout.rotation.Rotation;
import org.tizen.emulator.skin.layout.rotation.SkinRotations;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.menu.PopupMenu;
import org.tizen.emulator.skin.util.SkinUtil;
import org.tizen.emulator.skin.util.SwtUtil;

public class ProfileSpecificSkinComposer
implements ISkinComposer {
    private Logger logger = SkinLogger.getSkinLogger(ProfileSpecificSkinComposer.class).getLogger();
    private EmulatorConfig config;
    private EmulatorSkin skin;
    private Shell shell;
    private Canvas lcdCanvas;
    private EmulatorSkinState currentState;
    private SocketCommunicator communicator;
    private PaintListener shellPaintListener;
    private MouseTrackListener shellMouseTrackListener;
    private MouseMoveListener shellMouseMoveListener;
    private MouseListener shellMouseListener;
    private ProfileSkinImageRegistry imageRegistry;
    private HWKey currentPressedHWKey;
    private HWKey currentHoveredHWKey;

    public ProfileSpecificSkinComposer(EmulatorConfig config, EmulatorSkin skin) {
        this.config = config;
        this.skin = skin;
        this.shell = skin.getShell();
        this.currentState = skin.getEmulatorSkinState();
        this.communicator = skin.communicator;
        this.imageRegistry = new ProfileSkinImageRegistry(this.shell.getDisplay(), config.getDbiContents(), skin.skinInfo.getSkinPath());
        this.currentPressedHWKey = null;
        this.currentHoveredHWKey = null;
    }

    @Override
    public Canvas compose(int style) {
        this.lcdCanvas = new Canvas((Composite)this.shell, style);
        int x = this.config.getValidWindowX();
        int y = this.config.getValidWindowY();
        int scale = this.currentState.getCurrentScale();
        short rotationId = this.currentState.getCurrentRotationId();
        this.composeInternal(this.lcdCanvas, x, y, scale, rotationId);
        this.logger.info("resolution : " + this.currentState.getCurrentResolution() + ", scale : " + scale);
        return this.lcdCanvas;
    }

    @Override
    public void composeInternal(Canvas lcdCanvas, int x, int y, int scale, short rotationId) {
        this.shell.setLocation(x, y);
        String emulatorName = SkinUtil.makeEmulatorName(this.config);
        this.shell.setText("Emulator - " + emulatorName);
        lcdCanvas.setBackground(this.shell.getDisplay().getSystemColor(2));
        this.shell.setImage(this.skin.getImageRegistry().getIcon(ImageRegistry.IconName.EMULATOR_ICON));
        this.skin.bootingProgress = new CustomProgressBar(this.skin, 0, true);
        this.skin.bootingProgress.setBackground(new Color((Device)this.shell.getDisplay(), new RGB(38, 38, 38)));
        this.arrangeSkin(scale, rotationId);
        if (this.currentState.getCurrentImage() == null) {
            this.logger.severe("Failed to load initial skin image. Kill this skin process.");
            SkinUtil.openMessage(this.shell, null, "Failed to load Skin image file.", 1, this.config);
            EmulatorSkinMain.terminateImmediately(-1);
        }
        this.addListeners();
        PopupMenu popupMenu = this.skin.getPopupMenu();
        if (popupMenu != null && popupMenu.keyWindowItem != null) {
            final int dockValue = this.config.getSkinPropertyInt("window.keywindow.position", 0);
            this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (dockValue == 0) {
                        ProfileSpecificSkinComposer.this.skin.getKeyWindowKeeper().openKeyWindow(0x1020000, false);
                    } else {
                        ProfileSpecificSkinComposer.this.skin.getKeyWindowKeeper().openKeyWindow(dockValue, false);
                    }
                }
            });
        }
    }

    @Override
    public void arrangeSkin(int scale, short rotationId) {
        Rectangle displayBounds = this.adjustDisplayGeometry(this.lcdCanvas, this.currentState.getCurrentResolutionWidth(), this.currentState.getCurrentResolutionHeight(), scale, rotationId);
        if (displayBounds == null) {
            this.logger.severe("Failed to read display information for skin.");
            SkinUtil.openMessage(this.shell, null, "Failed to read display information for skin.\nCheck the contents of skin dbi file.", 1, this.config);
            EmulatorSkinMain.terminateImmediately(-1);
        }
        this.logger.info("display bounds : " + displayBounds);
        Image originSkin = this.imageRegistry.getSkinImage(rotationId, ProfileSkinImageRegistry.SkinImageType.PROFILE_IMAGE_TYPE_NORMAL);
        Image profileSkin = SkinUtil.createScaledImage(this.shell.getDisplay(), originSkin, rotationId, scale);
        Image originSkinKeyPressed = this.imageRegistry.getSkinImage(rotationId, ProfileSkinImageRegistry.SkinImageType.PROFILE_IMAGE_TYPE_PRESSED);
        Image profileSkinKeyPressed = SkinUtil.createScaledImage(this.shell.getDisplay(), originSkinKeyPressed, rotationId, scale);
        Region region = SkinUtil.getTrimmedRegion(profileSkin);
        this.currentState.setCurrentScale(scale);
        this.currentState.setCurrentRotationId(rotationId);
        this.currentState.setDisplayBounds(displayBounds);
        Image tempImage = null;
        Image tempKeyPressedImage = null;
        if (this.currentState.getCurrentImage() != null) {
            tempImage = this.currentState.getCurrentImage();
        }
        if (this.currentState.getCurrentKeyPressedImage() != null) {
            tempKeyPressedImage = this.currentState.getCurrentKeyPressedImage();
        }
        this.currentState.setCurrentImage(profileSkin);
        this.currentState.setCurrentKeyPressedImage(profileSkinKeyPressed);
        if (tempImage != null) {
            tempImage.dispose();
        }
        if (tempKeyPressedImage != null) {
            tempKeyPressedImage.dispose();
        }
        if (SwtUtil.isMacPlatform()) {
            this.lcdCanvas.setBounds(this.currentState.getDisplayBounds());
        }
        if (this.skin.bootingProgress != null) {
            this.skin.bootingProgress.setBounds(displayBounds.x, displayBounds.y + displayBounds.height + 1, displayBounds.width, 2);
        }
        if (this.currentState.getCurrentImage() != null) {
            ImageData imageData = this.currentState.getCurrentImage().getImageData();
            this.shell.setSize(imageData.width, imageData.height);
        }
        if (region != null) {
            this.shell.setRegion(region);
        }
        this.currentState.setNeedToUpdateDisplay(true);
        this.shell.redraw();
    }

    @Override
    public Rectangle adjustDisplayGeometry(Canvas displayCanvas, int resolutionW, int resolutionH, int scale, short rotationId) {
        Rectangle displayBounds = new Rectangle(0, 0, 0, 0);
        float convertedScale = SkinUtil.convertScale(scale);
        Rotation rotation = SkinRotations.getRotation(rotationId);
        if (rotation == null) {
            return null;
        }
        DisplayType display = rotation.getDisplay();
        if (display == null) {
            return null;
        }
        RegionType region = display.getRegion();
        if (region == null) {
            return null;
        }
        Integer left = region.getLeft();
        Integer top = region.getTop();
        Integer width = region.getWidth();
        Integer height = region.getHeight();
        displayBounds.x = (int)((float)left.intValue() * convertedScale);
        displayBounds.y = (int)((float)top.intValue() * convertedScale);
        displayBounds.width = (int)((float)width.intValue() * convertedScale);
        displayBounds.height = (int)((float)height.intValue() * convertedScale);
        return displayBounds;
    }

    private void drawHover(HWKey hwKey) {
        if (hwKey == null || hwKey.getRegion() == null || hwKey.getRegion().width == 0 || hwKey.getRegion().height == 0) {
            return;
        }
        this.currentHoveredHWKey = hwKey;
        this.shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                GC gc = new GC((Drawable)ProfileSpecificSkinComposer.this.shell);
                if (gc != null) {
                    gc.setLineWidth(1);
                    gc.setForeground(ProfileSpecificSkinComposer.this.currentState.getHoverColor());
                    gc.drawRectangle(((ProfileSpecificSkinComposer)ProfileSpecificSkinComposer.this).currentHoveredHWKey.getRegion().x, ((ProfileSpecificSkinComposer)ProfileSpecificSkinComposer.this).currentHoveredHWKey.getRegion().y, ((ProfileSpecificSkinComposer)ProfileSpecificSkinComposer.this).currentHoveredHWKey.getRegion().width - 1, ((ProfileSpecificSkinComposer)ProfileSpecificSkinComposer.this).currentHoveredHWKey.getRegion().height - 1);
                    gc.dispose();
                }
            }
        });
    }

    private void removeHover() {
        if (this.currentHoveredHWKey == null || this.currentHoveredHWKey.getRegion() == null) {
            return;
        }
        this.shell.redraw(this.currentHoveredHWKey.getRegion().x, this.currentHoveredHWKey.getRegion().y, this.currentHoveredHWKey.getRegion().width, this.currentHoveredHWKey.getRegion().height, false);
        this.currentHoveredHWKey = null;
    }

    @Override
    public void updateSkin() {
        this.logger.info("update skin");
    }

    private void addListeners() {
        this.shellPaintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ProfileSpecificSkinComposer.this.currentState.isNeedToUpdateDisplay()) {
                    ProfileSpecificSkinComposer.this.currentState.setNeedToUpdateDisplay(false);
                    ProfileSpecificSkinComposer.this.logger.info("shell transform was changed");
                    if (!SwtUtil.isMacPlatform()) {
                        ProfileSpecificSkinComposer.this.lcdCanvas.setBounds(ProfileSpecificSkinComposer.this.currentState.getDisplayBounds());
                    }
                    ProfileSpecificSkinComposer.this.skin.setSuitableTransform();
                }
                if (ProfileSpecificSkinComposer.this.currentState.getCurrentImage() != null) {
                    ImageData imageData = ProfileSpecificSkinComposer.this.currentState.getCurrentImage().getImageData();
                    if (((ProfileSpecificSkinComposer)ProfileSpecificSkinComposer.this).shell.getSize().x != imageData.width || ((ProfileSpecificSkinComposer)ProfileSpecificSkinComposer.this).shell.getSize().y != imageData.height) {
                        ProfileSpecificSkinComposer.this.shell.setSize(imageData.width, imageData.height);
                    }
                }
                if (SwtUtil.isLinuxPlatform() && ProfileSpecificSkinComposer.this.shell.getRegion() != null && ((ProfileSpecificSkinComposer)ProfileSpecificSkinComposer.this).shell.getRegion().getBounds().x == e.x && ((ProfileSpecificSkinComposer)ProfileSpecificSkinComposer.this).shell.getRegion().getBounds().y == e.y && ((ProfileSpecificSkinComposer)ProfileSpecificSkinComposer.this).shell.getRegion().getBounds().width == e.width && ((ProfileSpecificSkinComposer)ProfileSpecificSkinComposer.this).shell.getRegion().getBounds().height == e.height) {
                    ProfileSpecificSkinComposer.this.logger.info("shell re-painting is required");
                    ProfileSpecificSkinComposer.this.skin.updateDisplay();
                }
                if (ProfileSpecificSkinComposer.this.currentState.getCurrentImage() != null) {
                    e.gc.drawImage(ProfileSpecificSkinComposer.this.currentState.getCurrentImage(), 0, 0);
                    if (ProfileSpecificSkinComposer.this.currentPressedHWKey != null && ProfileSpecificSkinComposer.this.currentState.getCurrentKeyPressedImage() != null && ProfileSpecificSkinComposer.this.currentPressedHWKey.getRegion() != null && ((ProfileSpecificSkinComposer)ProfileSpecificSkinComposer.this).currentPressedHWKey.getRegion().width != 0 && ((ProfileSpecificSkinComposer)ProfileSpecificSkinComposer.this).currentPressedHWKey.getRegion().height != 0) {
                        e.gc.drawImage(ProfileSpecificSkinComposer.this.currentState.getCurrentKeyPressedImage(), ((ProfileSpecificSkinComposer)ProfileSpecificSkinComposer.this).currentPressedHWKey.getRegion().x, ((ProfileSpecificSkinComposer)ProfileSpecificSkinComposer.this).currentPressedHWKey.getRegion().y, ((ProfileSpecificSkinComposer)ProfileSpecificSkinComposer.this).currentPressedHWKey.getRegion().width, ((ProfileSpecificSkinComposer)ProfileSpecificSkinComposer.this).currentPressedHWKey.getRegion().height, ((ProfileSpecificSkinComposer)ProfileSpecificSkinComposer.this).currentPressedHWKey.getRegion().x, ((ProfileSpecificSkinComposer)ProfileSpecificSkinComposer.this).currentPressedHWKey.getRegion().y, ((ProfileSpecificSkinComposer)ProfileSpecificSkinComposer.this).currentPressedHWKey.getRegion().width, ((ProfileSpecificSkinComposer)ProfileSpecificSkinComposer.this).currentPressedHWKey.getRegion().height);
                    }
                }
                ProfileSpecificSkinComposer.this.skin.getKeyWindowKeeper().redock(false, false);
            }
        };
        this.shell.addPaintListener(this.shellPaintListener);
        this.shellMouseTrackListener = new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                ProfileSpecificSkinComposer.this.shell.setToolTipText(null);
                ProfileSpecificSkinComposer.this.removeHover();
            }
        };
        this.shell.addMouseTrackListener(this.shellMouseTrackListener);
        this.shellMouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (ProfileSpecificSkinComposer.this.skin.isShellGrabbing() && e.button == 0 && ProfileSpecificSkinComposer.this.currentPressedHWKey == null) {
                    Point previousLocation = ProfileSpecificSkinComposer.this.shell.getLocation();
                    Point grabLocation = ProfileSpecificSkinComposer.this.skin.getGrabPosition();
                    if (grabLocation != null) {
                        int x = previousLocation.x + (e.x - grabLocation.x);
                        int y = previousLocation.y + (e.y - grabLocation.y);
                        ProfileSpecificSkinComposer.this.shell.setLocation(x, y);
                    }
                    ProfileSpecificSkinComposer.this.skin.getKeyWindowKeeper().redock(false, false);
                    return;
                }
                HWKey hwKey = SkinUtil.getHWKey(e.x, e.y, ProfileSpecificSkinComposer.this.currentState.getCurrentScale(), ProfileSpecificSkinComposer.this.currentState.getCurrentRotationId());
                if (hwKey == null) {
                    ProfileSpecificSkinComposer.this.shell.setToolTipText(null);
                    ProfileSpecificSkinComposer.this.removeHover();
                } else {
                    if (!hwKey.getTooltip().isEmpty()) {
                        ProfileSpecificSkinComposer.this.shell.setToolTipText(hwKey.getTooltip());
                    }
                    if (hwKey.getRegion() != null) {
                        HWKeyRegion keyBounds;
                        if (ProfileSpecificSkinComposer.this.currentHoveredHWKey != null && (keyBounds = ProfileSpecificSkinComposer.this.currentHoveredHWKey.getRegion()) != null) {
                            if (hwKey.getRegion().x == keyBounds.x && hwKey.getRegion().y == keyBounds.y && hwKey.getRegion().width == keyBounds.width && hwKey.getRegion().height == keyBounds.height) {
                                return;
                            }
                            ProfileSpecificSkinComposer.this.removeHover();
                        }
                        ProfileSpecificSkinComposer.this.drawHover(hwKey);
                    }
                }
            }
        };
        this.shell.addMouseMoveListener(this.shellMouseMoveListener);
        this.shellMouseListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    ProfileSpecificSkinComposer.this.skin.ungrabShell();
                    ProfileSpecificSkinComposer.this.skin.getKeyWindowKeeper().redock(false, true);
                    HWKey pressedHWKey = ProfileSpecificSkinComposer.this.currentPressedHWKey;
                    if (pressedHWKey == null) {
                        ProfileSpecificSkinComposer.this.logger.info("mouseUp in Skin : " + e.x + ", " + e.y);
                        return;
                    }
                    if (pressedHWKey.getKeyCode() != -1) {
                        ProfileSpecificSkinComposer.this.logger.info(pressedHWKey.getName() + " key is released");
                        KeyEventData keyEventData = new KeyEventData(ICommunicator.KeyEventType.RELEASED.value(), pressedHWKey.getKeyCode(), 0, 0);
                        ProfileSpecificSkinComposer.this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_HW_KEY_EVENT, keyEventData, false);
                        ProfileSpecificSkinComposer.this.currentPressedHWKey = null;
                        if (pressedHWKey.getRegion() != null && pressedHWKey.getRegion().width != 0 && pressedHWKey.getRegion().height != 0) {
                            ProfileSpecificSkinComposer.this.shell.redraw(pressedHWKey.getRegion().x, pressedHWKey.getRegion().y, pressedHWKey.getRegion().width, pressedHWKey.getRegion().height, false);
                            if (pressedHWKey.getRegion().isNeedUpdate()) {
                                SkinUtil.trimShell(ProfileSpecificSkinComposer.this.shell, ProfileSpecificSkinComposer.this.currentState.getCurrentImage(), pressedHWKey.getRegion().x, pressedHWKey.getRegion().y, pressedHWKey.getRegion().width, pressedHWKey.getRegion().height);
                            }
                        }
                    }
                }
            }

            public void mouseDown(MouseEvent e) {
                if (1 == e.button) {
                    ProfileSpecificSkinComposer.this.skin.grabShell(e.x, e.y);
                    HWKey hwKey = SkinUtil.getHWKey(e.x, e.y, ProfileSpecificSkinComposer.this.currentState.getCurrentScale(), ProfileSpecificSkinComposer.this.currentState.getCurrentRotationId());
                    if (hwKey == null) {
                        ProfileSpecificSkinComposer.this.logger.info("mouseDown in Skin : " + e.x + ", " + e.y);
                        return;
                    }
                    if (hwKey.getKeyCode() != -1) {
                        ProfileSpecificSkinComposer.this.logger.info(hwKey.getName() + " key is pressed");
                        ProfileSpecificSkinComposer.this.shell.setToolTipText(null);
                        KeyEventData keyEventData = new KeyEventData(ICommunicator.KeyEventType.PRESSED.value(), hwKey.getKeyCode(), 0, 0);
                        ProfileSpecificSkinComposer.this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_HW_KEY_EVENT, keyEventData, false);
                        ProfileSpecificSkinComposer.this.currentPressedHWKey = hwKey;
                        if (hwKey.getRegion() != null && hwKey.getRegion().width != 0 && hwKey.getRegion().height != 0) {
                            ProfileSpecificSkinComposer.this.shell.redraw(hwKey.getRegion().x, hwKey.getRegion().y, hwKey.getRegion().width, hwKey.getRegion().height, false);
                            if (hwKey.getRegion().isNeedUpdate()) {
                                SkinUtil.trimShell(ProfileSpecificSkinComposer.this.shell, ProfileSpecificSkinComposer.this.currentState.getCurrentKeyPressedImage(), hwKey.getRegion().x, hwKey.getRegion().y, hwKey.getRegion().width, hwKey.getRegion().height);
                            }
                        }
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        this.shell.addMouseListener(this.shellMouseListener);
    }

    @Override
    public void composerFinalize() {
        if (null != this.shellPaintListener) {
            this.shell.removePaintListener(this.shellPaintListener);
        }
        if (null != this.shellMouseTrackListener) {
            this.shell.removeMouseTrackListener(this.shellMouseTrackListener);
        }
        if (null != this.shellMouseMoveListener) {
            this.shell.removeMouseMoveListener(this.shellMouseMoveListener);
        }
        if (null != this.shellMouseListener) {
            this.shell.removeMouseListener(this.shellMouseListener);
        }
        this.imageRegistry.dispose();
    }
}

