/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.layout;

import java.util.logging.Logger;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.util.SwtUtil;

public class SkinPatches {
    private Logger logger = SkinLogger.getSkinLogger(SkinPatches.class).getLogger();
    private Display display = Display.getCurrent();
    private int patchWidth;
    private int patchHeight;
    private Image imageLT;
    private Image imageT;
    private Image imageRT;
    private Image imageL;
    private Image imageR;
    private Image imageLB;
    private Image imageB;
    private Image imageRB;

    public SkinPatches(Image leftTop, Image middleTop, Image rightTop, Image leftMiddle, Image rightMiddle, Image leftBottom, Image middleBottom, Image rightBottom) {
        this.imageLT = leftTop;
        this.imageT = middleTop;
        this.imageRT = rightTop;
        this.imageL = leftMiddle;
        this.imageR = rightMiddle;
        this.imageLB = leftBottom;
        this.imageB = middleBottom;
        this.imageRB = rightBottom;
        this.patchWidth = this.imageLT.getImageData().width;
        this.patchHeight = this.imageLT.getImageData().height;
        this.logger.info("patch size : " + this.patchWidth + "x" + this.patchHeight);
    }

    public int getPatchWidth() {
        return this.patchWidth;
    }

    public int getPatchHeight() {
        return this.patchHeight;
    }

    public Image getPatchedImage(int centerPatchWidth, int centerPatchHeight) {
        int patchedImageWidth = this.patchWidth * 2 + centerPatchWidth;
        int patchedImageHeight = this.patchHeight * 2 + centerPatchHeight;
        ImageData imageData = new ImageData(patchedImageWidth, patchedImageHeight, 32, new PaletteData(-16777216, 0xFF0000, 65280));
        imageData.transparentPixel = 0;
        Image patchedImage = new Image((Device)this.display, imageData);
        GC gc = new GC((Drawable)patchedImage);
        if (!SwtUtil.isLinuxPlatform()) {
            gc.setBackground(this.display.getSystemColor(11));
            gc.fillRectangle(0, 0, patchedImageWidth, patchedImageHeight);
        }
        gc.drawImage(this.imageLT, 0, 0);
        gc.drawImage(this.imageT, 0, 0, this.imageT.getImageData().width, this.imageT.getImageData().height, this.patchWidth, 0, centerPatchWidth, this.patchHeight);
        gc.drawImage(this.imageRT, this.patchWidth + centerPatchWidth, 0);
        gc.drawImage(this.imageL, 0, 0, this.imageL.getImageData().width, this.imageL.getImageData().height, 0, this.patchHeight, this.patchWidth, centerPatchHeight);
        gc.setBackground(new Color((Device)this.display, new RGB(38, 38, 38)));
        gc.fillRectangle(this.patchWidth, this.patchHeight, centerPatchWidth, centerPatchHeight);
        gc.drawImage(this.imageR, 0, 0, this.imageR.getImageData().width, this.imageR.getImageData().height, this.patchWidth + centerPatchWidth, this.patchHeight, this.patchWidth, centerPatchHeight);
        gc.drawImage(this.imageLB, 0, this.patchHeight + centerPatchHeight);
        gc.drawImage(this.imageB, 0, 0, this.imageB.getImageData().width, this.imageB.getImageData().height, this.patchWidth, this.patchHeight + centerPatchHeight, centerPatchWidth, this.patchHeight);
        gc.drawImage(this.imageRB, this.patchWidth + centerPatchWidth, this.patchHeight + centerPatchHeight);
        gc.dispose();
        return patchedImage;
    }
}

