/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.screenshot;

import java.util.logging.Logger;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;
import org.tizen.emulator.skin.EmulatorSdlSkin;
import org.tizen.emulator.skin.comm.ICommunicator;
import org.tizen.emulator.skin.comm.sock.SocketCommunicator;
import org.tizen.emulator.skin.config.EmulatorConfig;
import org.tizen.emulator.skin.exception.ScreenShotException;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.screenshot.ScreenShotDialog;

public class SdlScreenShotWindow
extends ScreenShotDialog {
    private static Logger logger = SkinLogger.getSkinLogger(SdlScreenShotWindow.class).getLogger();
    private PaletteData palette;

    public SdlScreenShotWindow(EmulatorSdlSkin emulatorSkin, EmulatorConfig config, PaletteData palette, Image icon) {
        super(emulatorSkin, config, icon);
        this.palette = palette;
    }

    @Override
    protected void capture() throws ScreenShotException {
        logger.info("screenshot capture");
        SocketCommunicator.DataTranfer dataTranfer = this.skin.communicator.sendDataToQEMU(ICommunicator.SendCommand.SEND_SCREENSHOT_REQ, null, true);
        byte[] receivedData = this.skin.communicator.getReceivedData(dataTranfer);
        if (null != receivedData) {
            int width = this.skin.getEmulatorSkinState().getCurrentResolutionWidth();
            int height = this.skin.getEmulatorSkinState().getCurrentResolutionHeight();
            ImageData imageData = new ImageData(width, height, 32, this.palette, 1, receivedData);
            imageData = this.getRotateImageData(imageData);
            Image tempImage = this.imageShot;
            this.imageShot = new Image((Device)Display.getDefault(), imageData);
            if (tempImage != null) {
                tempImage.dispose();
            }
        } else {
            throw new ScreenShotException("Fail to get image data.");
        }
        this.canvasShot.redraw();
    }
}

