/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.screenshot;

import java.util.logging.Logger;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;
import org.tizen.emulator.skin.EmulatorShmSkin;
import org.tizen.emulator.skin.config.EmulatorConfig;
import org.tizen.emulator.skin.exception.ScreenShotException;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.screenshot.ScreenShotDialog;

public class ShmScreenShotWindow
extends ScreenShotDialog {
    private static Logger logger = SkinLogger.getSkinLogger(ShmScreenShotWindow.class).getLogger();
    private PaletteData palette;

    public ShmScreenShotWindow(EmulatorShmSkin emulatorSkin, EmulatorConfig config, PaletteData palette, Image icon) {
        super(emulatorSkin, config, icon);
        this.palette = palette;
    }

    @Override
    protected void capture() throws ScreenShotException {
        logger.info("screenshot capture");
        int width = this.skin.getEmulatorSkinState().getCurrentResolutionWidth();
        int height = this.skin.getEmulatorSkinState().getCurrentResolutionHeight();
        int[] arrayFramebuffer = new int[width * height];
        ((EmulatorShmSkin)this.skin).getPixels(arrayFramebuffer);
        ImageData imageData = new ImageData(width, height, 24, this.palette);
        imageData.setPixels(0, 0, width * height, arrayFramebuffer, 0);
        imageData = this.getRotateImageData(imageData);
        Image tempImage = this.imageShot;
        this.imageShot = new Image((Device)Display.getDefault(), imageData);
        if (tempImage != null) {
            tempImage.dispose();
        }
        this.canvasShot.redraw();
    }
}

