/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;
import org.tizen.emulator.skin.comm.ICommunicator;
import org.tizen.emulator.skin.comm.sock.SocketCommunicator;
import org.tizen.emulator.skin.comm.sock.data.MouseEventData;
import org.tizen.emulator.skin.info.EmulatorSkinState;
import org.tizen.emulator.skin.log.SkinLogger;

public class EmulatorFingers {
    private static final int MAX_FINGER_CNT = 10;
    private static final int FINGER_POINT_SIZE = 32;
    private static final int FINGER_POINT_ALPHA = 126;
    private Logger logger = SkinLogger.getSkinLogger(EmulatorFingers.class).getLogger();
    private int multiTouchEnable;
    private int maxTouchPoint;
    protected int fingerCnt;
    private int grabFingerID = 0;
    private ArrayList<FingerPoint> FingerPointList;
    protected int fingerPointSize;
    protected int fingerPointSizeHalf;
    protected Image fingerPointImage;
    protected SocketCommunicator communicator;
    private EmulatorSkinState currentState;

    EmulatorFingers(int maximum, EmulatorSkinState currentState, SocketCommunicator communicator, PaletteData palette) {
        this.currentState = currentState;
        this.communicator = communicator;
        this.initMultiTouchState(maximum, palette);
    }

    public FingerPoint getFingerPointFromSlot(int index) {
        if (index < 0 || index > this.getMaxTouchPoint()) {
            return null;
        }
        return this.FingerPointList.get(index);
    }

    public FingerPoint getFingerPointSearch(int x, int y) {
        FingerPoint fingerPoint = null;
        int fingerRegion = this.fingerPointSize + 2;
        for (int i = this.fingerCnt - 1; i >= 0; --i) {
            fingerPoint = this.getFingerPointFromSlot(i);
            if (fingerPoint == null || x < fingerPoint.x - fingerRegion || x >= fingerPoint.x + fingerRegion || y < fingerPoint.y - fingerRegion || y >= fingerPoint.y + fingerRegion) continue;
            return fingerPoint;
        }
        return null;
    }

    private void initMultiTouchState(int maximum, PaletteData palette) {
        this.multiTouchEnable = 0;
        int fingerCntMax = maximum;
        if (fingerCntMax > 10) {
            fingerCntMax = 10;
        }
        this.setMaxTouchPoint(fingerCntMax);
        this.logger.info("maxTouchPoint : " + this.getMaxTouchPoint());
        this.fingerCnt = 0;
        this.FingerPointList = new ArrayList();
        for (int i = 0; i <= this.getMaxTouchPoint(); ++i) {
            this.FingerPointList.add(new FingerPoint(-1, -1, -1, -1));
        }
        this.fingerPointSize = 32;
        this.fingerPointSizeHalf = this.fingerPointSize / 2;
        Color pointOutlineColor = new Color((Device)Display.getCurrent(), 221, 221, 221);
        Color pointColor = new Color((Device)Display.getCurrent(), 15, 15, 15);
        ImageData imageData = new ImageData(this.fingerPointSize + 4, this.fingerPointSize + 4, 32, palette);
        imageData.transparentPixel = 0;
        this.fingerPointImage = new Image((Device)Display.getCurrent(), imageData);
        GC gc = new GC((Drawable)this.fingerPointImage);
        gc.setBackground(pointColor);
        gc.fillOval(2, 2, this.fingerPointSize, this.fingerPointSize);
        gc.setForeground(pointOutlineColor);
        gc.drawOval(0, 0, this.fingerPointSize + 2, this.fingerPointSize + 2);
        gc.dispose();
        pointOutlineColor.dispose();
        pointColor.dispose();
    }

    public void setMultiTouchEnable(int value) {
        this.multiTouchEnable = value;
    }

    public int getMultiTouchEnable() {
        return this.multiTouchEnable;
    }

    protected int addFingerPoint(int originX, int originY, int x, int y) {
        if (this.fingerCnt == this.getMaxTouchPoint()) {
            this.logger.warning("support multi-touch up to " + this.getMaxTouchPoint() + " fingers");
            return -1;
        }
        ++this.fingerCnt;
        this.FingerPointList.get(this.fingerCnt - 1).id = this.fingerCnt;
        this.FingerPointList.get(this.fingerCnt - 1).originX = originX;
        this.FingerPointList.get(this.fingerCnt - 1).originY = originY;
        this.FingerPointList.get(this.fingerCnt - 1).x = x;
        this.FingerPointList.get(this.fingerCnt - 1).y = y;
        this.logger.info(this.fingerCnt + " finger touching");
        return this.fingerCnt;
    }

    protected void drawFingerPoints(GC gc) {
        int alpha = gc.getAlpha();
        gc.setAlpha(126);
        FingerPoint fingerSlot = null;
        for (int i = 0; i < this.fingerCnt; ++i) {
            fingerSlot = this.getFingerPointFromSlot(i);
            if (fingerSlot == null) continue;
            gc.drawImage(this.fingerPointImage, fingerSlot.originX - this.fingerPointSizeHalf - 2, fingerSlot.originY - this.fingerPointSizeHalf - 2);
        }
        gc.setAlpha(alpha);
    }

    public void maruFingerProcessing1(int touchType, int originX, int originY, int x, int y) {
        FingerPoint finger = null;
        MouseEventData mouseEventData = null;
        if (touchType == ICommunicator.MouseEventType.PRESS.value() || touchType == ICommunicator.MouseEventType.DRAG.value()) {
            if (this.grabFingerID > 0) {
                finger = this.getFingerPointFromSlot(this.grabFingerID - 1);
                if (finger != null) {
                    finger.originX = originX;
                    finger.originY = originY;
                    finger.x = x;
                    finger.y = y;
                    if (finger.id != 0) {
                        this.logger.info("id " + this.grabFingerID + " finger multi-touch dragging : (" + x + ", " + y + ")");
                        mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), originX, originY, x, y, this.grabFingerID - 1);
                        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
                    }
                }
                return;
            }
            if (this.fingerCnt == 0) {
                if (this.addFingerPoint(originX, originY, x, y) == -1) {
                    return;
                }
                mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), originX, originY, x, y, 0);
                this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
            } else {
                finger = this.getFingerPointSearch(x, y);
                if (finger != null) {
                    this.grabFingerID = finger.id;
                    this.logger.info("id " + this.grabFingerID + " finger is grabbed");
                } else if (this.fingerCnt == this.getMaxTouchPoint()) {
                    finger = this.getFingerPointFromSlot(this.getMaxTouchPoint() - 1);
                    if (finger != null) {
                        mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.RELEASE.value(), originX, originY, finger.x, finger.y, this.getMaxTouchPoint() - 1);
                        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
                        finger.originX = originX;
                        finger.originY = originY;
                        finger.x = x;
                        finger.y = y;
                        if (finger.id != 0) {
                            mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), originX, originY, x, y, this.getMaxTouchPoint() - 1);
                            this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
                        }
                    }
                } else {
                    this.addFingerPoint(originX, originY, x, y);
                    mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), originX, originY, x, y, this.fingerCnt - 1);
                    this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
                }
            }
        } else if (touchType == ICommunicator.MouseEventType.RELEASE.value()) {
            this.logger.info("mouse up for multi touch");
            this.grabFingerID = 0;
        }
    }

    public void maruFingerProcessing2(int touchType, int originX, int originY, int x, int y) {
        FingerPoint finger = null;
        MouseEventData mouseEventData = null;
        if (touchType == ICommunicator.MouseEventType.PRESS.value() || touchType == ICommunicator.MouseEventType.DRAG.value()) {
            if (this.grabFingerID > 0) {
                finger = this.getFingerPointFromSlot(this.grabFingerID - 1);
                if (finger != null) {
                    int originDistanceX = originX - finger.originX;
                    int originDistanceY = originY - finger.originY;
                    int distanceX = x - finger.x;
                    int distanceY = y - finger.y;
                    int currrntScreenW = this.currentState.getCurrentResolutionWidth();
                    int currrntScreenH = this.currentState.getCurrentResolutionHeight();
                    int tempFingerX = 0;
                    int tempFingerY = 0;
                    int i = 0;
                    for (i = 0; i < this.fingerCnt; ++i) {
                        finger = this.getFingerPointFromSlot(i);
                        if (finger == null) continue;
                        tempFingerX = finger.x + distanceX;
                        tempFingerY = finger.y + distanceY;
                        if (tempFingerX <= currrntScreenW && tempFingerX >= 0 && tempFingerY <= currrntScreenH && tempFingerY >= 0) continue;
                        this.logger.info("id " + (i + 1) + " finger is out of bounds : (" + tempFingerX + ", " + tempFingerY + ")");
                        return;
                    }
                    for (i = 0; i < this.fingerCnt; ++i) {
                        finger = this.getFingerPointFromSlot(i);
                        if (finger == null) continue;
                        FingerPoint fingerPoint = finger;
                        fingerPoint.originX = fingerPoint.originX + originDistanceX;
                        fingerPoint = finger;
                        fingerPoint.originY = fingerPoint.originY + originDistanceY;
                        fingerPoint = finger;
                        fingerPoint.x = fingerPoint.x + distanceX;
                        fingerPoint = finger;
                        fingerPoint.y = fingerPoint.y + distanceY;
                        if (finger.id != 0) {
                            mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), originX, originY, finger.x, finger.y, i);
                            this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
                        }
                        try {
                            Thread.sleep(2L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                return;
            }
            if (this.fingerCnt == 0) {
                if (this.addFingerPoint(originX, originY, x, y) == -1) {
                    return;
                }
                mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), originX, originY, x, y, 0);
                this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
            } else {
                finger = this.getFingerPointSearch(x, y);
                if (finger != null) {
                    this.grabFingerID = finger.id;
                    this.logger.info("id " + this.grabFingerID + " finger is grabbed");
                } else if (this.fingerCnt != this.getMaxTouchPoint()) {
                    this.addFingerPoint(originX, originY, x, y);
                    mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), originX, originY, x, y, this.fingerCnt - 1);
                    this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
                }
            }
        } else if (touchType == ICommunicator.MouseEventType.RELEASE.value()) {
            this.logger.info("mouse up for multi touch");
            this.grabFingerID = 0;
        }
    }

    private Boolean calculateOriginCoordinates(int scaledDisplayWitdh, int scaledDisplayHeight, double scaleFactor, short rotationId, FingerPoint finger) {
        int pointX = 0;
        int pointY = 0;
        int rotatedPointX = 0;
        int rotatedPointY = 0;
        boolean flag = false;
        rotatedPointX = pointX = (int)((double)finger.x * scaleFactor);
        rotatedPointY = pointY = (int)((double)finger.y * scaleFactor);
        if (rotationId == 1) {
            rotatedPointX = pointY;
            rotatedPointY = scaledDisplayWitdh - pointX;
        } else if (rotationId == 2) {
            rotatedPointX = scaledDisplayWitdh - pointX;
            rotatedPointY = scaledDisplayHeight - pointY;
        } else if (rotationId == 3) {
            rotatedPointX = scaledDisplayHeight - pointY;
            rotatedPointY = pointX;
        }
        if (finger.originX != rotatedPointX) {
            this.logger.info("finger.originX: " + finger.originX);
            finger.originX = rotatedPointX;
            flag = true;
        }
        if (finger.originY != rotatedPointY) {
            this.logger.info("finger.originY: " + finger.originY);
            finger.originY = rotatedPointY;
            flag = true;
        }
        if (flag) {
            return true;
        }
        return false;
    }

    public int rearrangeFingerPoints(int displayWidth, int displayHeight, double scaleFactor, short rotationId) {
        if (this.multiTouchEnable == 0) {
            return 0;
        }
        int count = 0;
        FingerPoint finger = null;
        displayWidth = (int)((double)displayWidth * (scaleFactor /= 100.0));
        displayHeight = (int)((double)displayHeight * scaleFactor);
        for (int i = 0; i < this.fingerCnt; ++i) {
            finger = this.getFingerPointFromSlot(i);
            if (finger == null || finger.id == 0 || !this.calculateOriginCoordinates(displayWidth, displayHeight, scaleFactor, rotationId, finger).booleanValue()) continue;
            ++count;
        }
        return count;
    }

    public void clearFingerSlot(boolean keepEnable) {
        int i = 0;
        FingerPoint finger = null;
        if (!keepEnable) {
            this.setMultiTouchEnable(0);
        }
        this.logger.info("clear multi-touch : " + this.getMultiTouchEnable());
        for (i = 0; i < this.fingerCnt; ++i) {
            finger = this.getFingerPointFromSlot(i);
            if (finger == null) continue;
            if (finger.id > 0) {
                MouseEventData mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.RELEASE.value(), 0, 0, finger.x, finger.y, finger.id - 1);
                this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
            }
            finger.id = 0;
            finger.originX = (finger.originY = (finger.x = (finger.y = -1)));
        }
        this.grabFingerID = 0;
        this.fingerCnt = 0;
    }

    public void cleanupMultiTouchState() {
        this.clearFingerSlot(false);
        this.fingerPointImage.dispose();
    }

    public int getMaxTouchPoint() {
        if (this.maxTouchPoint <= 0) {
            this.setMaxTouchPoint(1);
        }
        return this.maxTouchPoint;
    }

    public void setMaxTouchPoint(int cnt) {
        if (cnt <= 0) {
            cnt = 1;
        }
        this.maxTouchPoint = cnt;
    }

    static class FingerPoint {
        private int id;
        private int originX;
        private int originY;
        private int x;
        private int y;

        FingerPoint(int originX, int originY, int x, int y) {
            this.originX = originX;
            this.originY = -originY;
            this.x = x;
            this.y = y;
        }

        FingerPoint(int id, int originX, int originY, int x, int y) {
            this.id = id;
            this.originX = originX;
            this.originY = -originY;
            this.x = x;
            this.y = y;
        }
    }
}

