/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin;

import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.PaletteData;
import org.tizen.emulator.skin.EmulatorSkin;
import org.tizen.emulator.skin.comm.ICommunicator;
import org.tizen.emulator.skin.comm.sock.data.DisplayStateData;
import org.tizen.emulator.skin.comm.sock.data.StartData;
import org.tizen.emulator.skin.config.EmulatorConfig;
import org.tizen.emulator.skin.dbi.OptionType;
import org.tizen.emulator.skin.exception.ScreenShotException;
import org.tizen.emulator.skin.image.ImageRegistry;
import org.tizen.emulator.skin.info.SkinInformation;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.screenshot.SdlScreenShotWindow;
import org.tizen.emulator.skin.util.SkinUtil;
import org.tizen.emulator.skin.util.SwtUtil;

public class EmulatorSdlSkin
extends EmulatorSkin {
    public static final int DISPLAY_COLOR_DEPTH = 32;
    private Logger logger = SkinLogger.getSkinLogger(EmulatorSdlSkin.class).getLogger();
    private PaletteData palette = new PaletteData(65280, 0xFF0000, -16777216);

    public EmulatorSdlSkin(EmulatorConfig config, SkinInformation skinInfo, boolean isOnTop) {
        super(config, skinInfo, 0x1000000, isOnTop);
    }

    @Override
    public StartData initSkin() {
        this.initLayout();
        long id = this.getDisplayHandleId();
        int width = this.getEmulatorSkinState().getCurrentResolutionWidth();
        int height = this.getEmulatorSkinState().getCurrentResolutionHeight();
        int scale = this.getEmulatorSkinState().getCurrentScale();
        short rotation = this.getEmulatorSkinState().getCurrentRotationId();
        boolean isBlankGuide = true;
        OptionType option = this.config.getDbiContents().getOption();
        if (option != null) {
            isBlankGuide = option.getBlankGuide() == null ? true : option.getBlankGuide().isVisible();
        }
        StartData startData = new StartData(id, width, height, scale, rotation, isBlankGuide);
        this.logger.info("" + startData);
        return startData;
    }

    private long getDisplayHandleId() {
        long windowHandleId = 0L;
        if (SwtUtil.isLinuxPlatform()) {
            try {
                Field field = this.lcdCanvas.getClass().getField("embeddedHandle");
                windowHandleId = field.getLong(this.lcdCanvas);
                this.logger.info("lcdCanvas.embeddedHandle:" + windowHandleId);
            }
            catch (IllegalArgumentException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                this.shutdown();
            }
            catch (IllegalAccessException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                this.shutdown();
            }
            catch (SecurityException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                this.shutdown();
            }
            catch (NoSuchFieldException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                this.shutdown();
            }
        } else if (SwtUtil.isWindowsPlatform()) {
            try {
                Field field = this.lcdCanvas.getClass().getField("handle");
                windowHandleId = field.getLong(this.lcdCanvas);
                this.logger.info("lcdCanvas.handle:" + windowHandleId);
            }
            catch (IllegalArgumentException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                this.shutdown();
            }
            catch (IllegalAccessException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                this.shutdown();
            }
            catch (SecurityException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                this.shutdown();
            }
            catch (NoSuchFieldException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                this.shutdown();
            }
        } else {
            this.logger.severe("Not Supported OS platform:" + SWT.getPlatform());
            this.shutdown();
        }
        return windowHandleId;
    }

    @Override
    public void updateDisplay() {
        this.logger.info("update display");
        DisplayStateData stateData = new DisplayStateData(this.currentState.getCurrentScale(), this.currentState.getCurrentRotationId());
        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_DISPLAY_STATE, stateData, false);
    }

    @Override
    public void displayOn() {
        super.displayOn();
    }

    @Override
    public void displayOff() {
        super.displayOff();
    }

    @Override
    protected void openScreenShotWindow() {
        if (this.screenShotDialog != null) {
            this.logger.info("screenshot window was already opened");
            return;
        }
        this.screenShotDialog = new SdlScreenShotWindow(this, this.config, this.palette, this.imageRegistry.getIcon(ImageRegistry.IconName.SCREENSHOT));
        try {
            this.screenShotDialog.open();
        }
        catch (ScreenShotException ex) {
            this.screenShotDialog = null;
            this.logger.log(Level.SEVERE, ex.getMessage(), ex);
            SkinUtil.openMessage(this.shell, null, "Fail to create a screen shot.", 1, this.config);
        }
        catch (Exception ex) {
            this.screenShotDialog = null;
            this.logger.log(Level.SEVERE, ex.getMessage(), ex);
            SkinUtil.openMessage(this.shell, null, "ScreenShot is not ready.\nPlease wait until the emulator is completely boot up.", 8, this.config);
        }
    }
}

